set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '2432403',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.281883,
      1.551561,
      NULL,
      NULL,
      '10-18-1978',
      NULL,
      NULL,
      2.659816,
      NULL,
      1.079627,
      ' 2-22-1976',
      NULL,
      2,
      107.725543,
      118.017009,
      NULL,
      ' 3-17-1975',
      ' 0-11-1983',
      NULL,
      0,
      1,
      1.655135,
      3,
      0,
      1.250746,
      1,
      1.987203,
      0.659713,
      421.477344,
      11,
      9,
      4.623284,
      12.619636,
      28,
      NULL,
      2.392664,
      2,
      3.592043,
      6,
      NULL,
      1,
      1.881512,
      0,
      1.194279,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0.858256,
      2.132888,
      1.637839,
      2,
      6,
      0.588673,
      7.967472,
      NULL,
      8,
      1.782828,
      NULL,
      0.051960,
      0,
      0.092123,
      1.667320,
      NULL,
      9,
      0.176279,
      NULL,
      3.907436,
      2.656754,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0.516489,
      1,
      NULL,
      0,
      2,
      1,
      1.072651,
      0.321892,
      0.111062,
      0,
      0.815948,
      1.260210,
      0.004854,
      2.967207,
      NULL,
      NULL,
      2.170762,
      2,
      NULL,
      0.297974,
      NULL,
      0.133703,
      1.801616,
      0.296392,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      8,
      2.245620,
      3.698744,
      4,
      11,
      1.253996,
      2,
      4.625753,
      NULL,
      1.908830,
      4.314487,
      0.302044,
      1,
      NULL,
      0,
      1.242900,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      7,
      0,
      7.034468,
      5,
      0,
      NULL,
      NULL,
      NULL,
      7.143607,
      5,
      10.389504,
      NULL,
      NULL,
      3,
      1.114512,
      6,
      4,
      1,
      6,
      NULL,
      5.916269,
      NULL,
      NULL,
      ' 9- 5-2000',
      NULL,
      ' 5- 1-1996',
      4.948250,
      1.321191,
      2,
      1,
      5,
      2,
      NULL,
      2,
      1.519232,
      2.680943,
      0,
      6,
      2.777921,
      5,
      NULL,
      NULL,
      3.957608,
      1.193265,
      6.611333,
      0.569804,
      0.124174,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.912088,
      0.208002,
      1,
      1,
      0,
      0,
      5.451723,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.011187,
      1,
      1,
      1.094185,
      0.548718,
      1.434081,
      0.124638,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.743911,
      0.964210,
      0.342933,
      3.899005,
      NULL,
      2.039601,
      2.437759,
      1,
      1.941280,
      3,
      3,
      0,
      NULL,
      NULL,
      3.040757,
      2.694841,
      3.802474,
      0,
      0,
      5.758894,
      4.912663,
      NULL,
      0.477913,
      1.697869,
      0.967787,
      NULL,
      1.826526,
      0.380997,
      0.162579,
      1,
      0.564871,
      0,
      3,
      NULL,
      6.890239,
      NULL,
      8,
      5.632331,
      NULL,
      1.106714,
      2,
      NULL,
      3,
      0.649856,
      NULL,
      3.679393,
      0.655242,
      NULL,
      NULL,
      16,
      1,
      2.376231,
      1,
      0.254657,
      '20033',
      '',
      '',
      0.196869,
      NULL,
      '',
      '',
      0.274196,
      '',
      '',
      '',
      0.632302,
      NULL,
      NULL,
      29.946489,
      0.468034,
      NULL,
      18.451964,
      83,
      NULL,
      2.540196,
      2.037489,
      1,
      0,
      NULL,
      NULL,
      2.944521,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.007712,
      NULL,
      NULL,
      NULL,
      3,
      0.881554,
      NULL,
      NULL,
      NULL,
      2.762993,
      0.066205,
      2.726013,
      0.966051,
      1,
      NULL,
      NULL,
      NULL,
      0.423587,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.703957,
      1,
      NULL,
      NULL,
      0.472719,
      NULL,
      NULL,
      3,
      1,
      3.320249,
      0,
      1.877158,
      NULL,
      1.619054,
      1,
      1,
      1.356919,
      1,
      NULL,
      2.110496,
      0,
      1.792487,
      NULL,
      1.510071,
      NULL,
      NULL,
      0.180172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.939904,
      0.654854,
      0.172143,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105293,
      0.883562,
      3.913719,
      1,
      0.293275,
      NULL,
      3.995544,
      0,
      NULL,
      0,
      0.375640,
      9,
      2,
      NULL,
      1.394309,
      3,
      0,
      0.510370,
      0,
      NULL,
      NULL,
      6,
      0.215931,
      0,
      NULL,
      NULL,
      1.219389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572428,
      NULL,
      NULL,
      1.992396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.562228,
      NULL,
      NULL,
      2.778367,
      1,
      NULL,
      0,
      NULL,
      0.451830,
      8.944895,
      2.925670,
      NULL,
      1.210990,
      3.564797,
      0.816254,
      0,
      0,
      0,
      NULL,
      0.365195,
      1,
      0.007686,
      NULL,
      NULL,
      2.463794,
      4.033257,
      3.620723,
      NULL,
      2,
      1.333086,
      2,
      0.131260,
      0,
      2.105499,
      1.396316,
      NULL,
      2,
      0.856212,
      0.831127,
      3.082029,
      3.573113,
      1.850282,
      4.272484,
      9.224467,
      NULL,
      3.698527,
      NULL,
      7.519053,
      2,
      1.450265,
      1,
      1,
      1.689027,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.622675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.207205,
      1,
      0,
      NULL,
      NULL,
      2.345400,
      0.738551,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.869554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.512379,
      NULL,
      NULL,
      3,
      0.218344,
      NULL,
      NULL,
      1.783565,
      2,
      NULL,
      NULL,
      3.831223,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.471928,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.448890,
      NULL,
      NULL,
      2.144961,
      1,
      NULL,
      NULL,
      NULL,
      0.260597,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390728,
      138.075284,
      225,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      94.197207,
      30,
      1.258623,
      NULL,
      NULL,
      1.628787,
      37,
      1.450487,
      0.922111,
      0,
      1.471534,
      1.316002,
      NULL,
      1.018736,
      0,
      1.805093,
      0.938745,
      1.998650,
      NULL,
      0,
      1.491406,
      NULL,
      1,
      1.063709,
      1.208471,
      0,
      1,
      1.786479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.190457,
      4.402215,
      2,
      NULL,
      0,
      1,
      0.437158,
      0.396671,
      1,
      0,
      1,
      1.263161,
      1,
      0.598950,
      0,
      NULL,
      0,
      1,
      3,
      0,
      1,
      0,
      0,
      0.785155,
      0.760140,
      NULL,
      NULL,
      1,
      1.191050,
      0.663516,
      NULL,
      1,
      NULL,
      2,
      2.738758,
      NULL,
      NULL,
      1.176931,
      NULL,
      NULL,
      2.652050,
      1.409029,
      0,
      NULL,
      1,
      NULL,
      1.424437,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.462489,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.259730,
      NULL,
      3.261903,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      19,
      3,
      NULL,
      0.700231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708964,
      3.806064,
      1.549180,
      0.466030,
      NULL,
      1,
      6,
      2,
      6,
      1.723840,
      NULL,
      NULL,
      74.704320,
      32.650301,
      0.701508,
      1.449448,
      2.803943,
      '41034',
      NULL,
      '',
      1.809663,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


