set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      NULL,
      36.544180,
      12,
      NULL,
      0.190768,
      1.837449,
      NULL,
      1,
      '3213',
      2,
      0,
      NULL,
      NULL,
      ' 9-27-1974',
      55.438774,
      4,
      NULL,
      0.860929,
      NULL,
      ' 3-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      0.386771,
      NULL,
      NULL,
      ' 2-24-1975',
      1,
      NULL,
      2.760884,
      NULL,
      1.268082,
      0,
      2.539156,
      0.503434,
      0,
      NULL,
      2,
      3.448918,
      9.261775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.051037,
      1,
      0,
      NULL,
      0.606355,
      3.644731,
      0.827547,
      1.125410,
      NULL,
      5,
      1.177062,
      4,
      1,
      1,
      0.806329,
      1.000835,
      1.042970,
      1,
      1,
      1.525804,
      1,
      1.929656,
      NULL,
      1.213683,
      NULL,
      0.986032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762693,
      1.838800,
      0,
      0.975019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.555751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726523,
      0.862899,
      1,
      0.523469,
      NULL,
      0.631295,
      NULL,
      0.876351,
      1,
      NULL,
      1.315127,
      1,
      3.118188,
      0.065141,
      NULL,
      NULL,
      0.650323,
      NULL,
      NULL,
      0,
      0,
      0,
      1.349361,
      1,
      0,
      2,
      6.650500,
      1,
      2,
      NULL,
      NULL,
      NULL,
      5.691063,
      NULL,
      1,
      4.505185,
      5,
      1,
      4.563933,
      5.737778,
      NULL,
      2,
      NULL,
      3.196320,
      0.023011,
      NULL,
      1.360061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.827201,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.516359,
      1,
      NULL,
      4.052580,
      0.880031,
      1,
      1.322735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.609917,
      1,
      2,
      0.983580,
      NULL,
      NULL,
      NULL,
      0.259928,
      0,
      NULL,
      1,
      0.130526,
      1.673546,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.852828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.416587,
      1.757652,
      1,
      3,
      1,
      NULL,
      1,
      3.477528,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.595284,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      2,
      3.194121,
      2,
      2.098921,
      2,
      3.787045,
      NULL,
      2.291340,
      0,
      NULL,
      1.698929,
      0.427120,
      3.987303,
      5.585771,
      0.557583,
      0.521964,
      0,
      0,
      NULL,
      1.309521,
      0.164426,
      1,
      0.736453,
      5,
      1,
      2.124372,
      NULL,
      0,
      5,
      5,
      0.779074,
      NULL,
      2.975267,
      5,
      NULL,
      2,
      2.151360,
      65,
      0.200581,
      1,
      68.009324,
      NULL,
      23,
      48,
      1.940995,
      2,
      0.754031,
      '22303',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.255881,
      '',
      '',
      '',
      3,
      1,
      53,
      22,
      0.898999,
      19.182651,
      14,
      NULL,
      3.141066,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.004798,
      0,
      NULL,
      1.717857,
      2.644841,
      1.931919,
      2,
      3.391516,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.368920,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.136981,
      NULL,
      NULL,
      2.156960,
      3.274159,
      1.523319,
      0,
      NULL,
      NULL,
      0.418646,
      3,
      2,
      1.507831,
      1,
      NULL,
      NULL,
      NULL,
      0.796626,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1.586044,
      NULL,
      NULL,
      1.324986,
      NULL,
      NULL,
      0.693928,
      2,
      1,
      1.612661,
      1.710692,
      3,
      1.840960,
      1,
      2.640617,
      0.593157,
      0.978376,
      1,
      2,
      NULL,
      0.593606,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0.996351,
      NULL,
      0,
      0.897522,
      NULL,
      NULL,
      NULL,
      1.451366,
      NULL,
      NULL,
      NULL,
      0.464459,
      1.219718,
      0,
      2.667593,
      1.040605,
      1,
      0,
      2,
      0,
      3,
      1.487859,
      1,
      6,
      2.135936,
      3,
      0.985419,
      1,
      1.441379,
      2.498422,
      1.488447,
      3.423849,
      4.492128,
      7.544685,
      1.229856,
      1.020491,
      NULL,
      NULL,
      0.138724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.735867,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.391398,
      NULL,
      1.026595,
      3.096617,
      4.105766,
      1,
      5,
      4.523132,
      2.543534,
      NULL,
      NULL,
      1.595263,
      2.640190,
      NULL,
      1.054022,
      0.704004,
      NULL,
      NULL,
      5.508482,
      2,
      2,
      2.563296,
      1,
      1.158720,
      2.445736,
      0.116864,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      9.548628,
      2.689209,
      1,
      4.042684,
      7.208131,
      1.905490,
      1.958470,
      3,
      9,
      0,
      NULL,
      1,
      1,
      0.087479,
      2,
      NULL,
      NULL,
      2.761596,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.565455,
      NULL,
      NULL,
      0.011467,
      NULL,
      NULL,
      0.389295,
      NULL,
      NULL,
      0.454947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161190,
      NULL,
      NULL,
      0.217007,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558118,
      1,
      1,
      1,
      0.867095,
      3.197414,
      NULL,
      NULL,
      NULL,
      1.699333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961921,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702167,
      0.755941,
      NULL,
      NULL,
      1.096136,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.654130,
      2,
      NULL,
      NULL,
      0.802193,
      0,
      NULL,
      NULL,
      3.307640,
      3.257620,
      NULL,
      NULL,
      1.810437,
      0,
      NULL,
      NULL,
      1,
      1.791356,
      NULL,
      NULL,
      3,
      0.123016,
      NULL,
      NULL,
      1.905718,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.570745,
      NULL,
      NULL,
      11.104551,
      4,
      NULL,
      NULL,
      0.642705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      380.664086,
      3,
      18,
      2,
      0.927917,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3.055439,
      NULL,
      1,
      1.813332,
      0,
      1.180500,
      0.153798,
      1,
      NULL,
      1,
      NULL,
      0.724404,
      1.027429,
      1,
      1.048225,
      1.833555,
      0,
      NULL,
      1.425858,
      1.303256,
      NULL,
      0.692662,
      0.910042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.670242,
      NULL,
      0,
      3,
      3.766136,
      0,
      5,
      5.143837,
      0.762833,
      2.246938,
      NULL,
      0,
      1.507043,
      0,
      NULL,
      0,
      2,
      NULL,
      1.743162,
      0,
      0.492155,
      0.155481,
      0.513255,
      NULL,
      NULL,
      0.895250,
      0,
      1.797209,
      NULL,
      0,
      1.143156,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.231856,
      3.518824,
      3.984447,
      NULL,
      1,
      1.148763,
      1.605971,
      NULL,
      0.042716,
      1.357705,
      0,
      0,
      NULL,
      2,
      1.357738,
      2.769131,
      0.904700,
      NULL,
      0.636503,
      1,
      1,
      1,
      0.333585,
      1.023622,
      1.204634,
      0,
      1,
      NULL,
      1.416440,
      2,
      0,
      2,
      0,
      1.760951,
      1.866316,
      1.321431,
      6.886928,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710786,
      NULL,
      0,
      NULL,
      0,
      1.625188,
      6.083343,
      9.246743,
      0.996500,
      2.860548,
      1,
      3,
      60,
      NULL,
      3,
      2.881515,
      0,
      '02143',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.167350,
      '',
      NULL,
      '');
commit;
end;
/


