set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4324341',
      NULL,
      0,
      3,
      1,
      '0313',
      3.852956,
      0.118178,
      NULL,
      NULL,
      ' 3-24-1979',
      9.481057,
      NULL,
      0,
      NULL,
      6.382847,
      ' 9-25-1977',
      NULL,
      3.765410,
      321.777544,
      87,
      2,
      '10-20-1994',
      ' 9-12-1975',
      ' 1-19-1995',
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      3.221887,
      1.700681,
      NULL,
      NULL,
      NULL,
      10.047396,
      NULL,
      NULL,
      33.116424,
      2,
      15,
      3,
      4.471648,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.805406,
      1,
      2,
      NULL,
      1.228210,
      1.151609,
      NULL,
      6.591319,
      7.863819,
      7.148162,
      1,
      3,
      1.642783,
      1.068381,
      NULL,
      2.209768,
      1,
      0,
      0,
      NULL,
      0.866170,
      NULL,
      NULL,
      1.952352,
      NULL,
      NULL,
      9.979801,
      0.632287,
      2,
      2.797999,
      2.232562,
      1,
      2.724487,
      NULL,
      0.512363,
      NULL,
      2.916891,
      1.347423,
      2,
      1,
      0.709778,
      0,
      NULL,
      1,
      1.207391,
      NULL,
      3,
      3,
      5.261487,
      0,
      5.609577,
      0.789993,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.113743,
      1.338411,
      5,
      0,
      0,
      NULL,
      1.723680,
      NULL,
      0.317160,
      0,
      1.965038,
      5,
      0.309445,
      1.641152,
      0,
      NULL,
      NULL,
      NULL,
      1.653937,
      0,
      0.470145,
      0,
      0,
      0.446164,
      1,
      4,
      1,
      0,
      1.173744,
      0,
      0.816936,
      1,
      0,
      0.130830,
      2,
      2,
      4,
      4.726752,
      NULL,
      3,
      4,
      2,
      1.438497,
      NULL,
      0.528925,
      0.673131,
      ' 0-27-1979',
      5.114088,
      NULL,
      2,
      2,
      0.724472,
      NULL,
      2.426140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482632,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.653796,
      NULL,
      NULL,
      3,
      0.853454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.404419,
      2.127833,
      NULL,
      2.411137,
      2.666178,
      4.818632,
      9,
      2.352766,
      1.414656,
      NULL,
      2.077107,
      0,
      NULL,
      NULL,
      1.726567,
      NULL,
      1.767119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      2.029166,
      25.057562,
      0.669228,
      0.710985,
      NULL,
      NULL,
      NULL,
      1,
      0.631622,
      0.102279,
      3.276479,
      1.697537,
      2,
      3.697773,
      3.690651,
      NULL,
      0.467153,
      2,
      NULL,
      0.355477,
      2.531137,
      1,
      0,
      0.029432,
      3.853341,
      0.172000,
      0,
      0,
      NULL,
      0.543505,
      0,
      1,
      1,
      0,
      0,
      0,
      2,
      4,
      1,
      10,
      5.528362,
      NULL,
      3.942517,
      4.774355,
      7,
      5.020315,
      3,
      0.943074,
      3,
      3.820273,
      0.075212,
      44,
      2,
      3,
      NULL,
      NULL,
      5,
      41.523590,
      5.822052,
      NULL,
      3,
      '00301',
      NULL,
      '',
      1.973041,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.184432,
      NULL,
      NULL,
      NULL,
      0.196473,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.463023,
      NULL,
      1.730921,
      7472,
      826,
      0.635240,
      1.200327,
      1,
      1.725830,
      NULL,
      1,
      1.586873,
      0.436976,
      0,
      0,
      1,
      0,
      0.686267,
      1.980633,
      0.761750,
      0.118078,
      0,
      1.409999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693276,
      3.953704,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051246,
      NULL,
      0.616584,
      NULL,
      0.478383,
      NULL,
      1.734787,
      NULL,
      NULL,
      NULL,
      0.956558,
      NULL,
      1.467595,
      NULL,
      NULL,
      NULL,
      1.437223,
      NULL,
      0.489982,
      NULL,
      0.903093,
      NULL,
      NULL,
      1.079730,
      1.075020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.019285,
      NULL,
      1.192253,
      NULL,
      0.218135,
      NULL,
      NULL,
      NULL,
      0.866409,
      1,
      1.955603,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3.741362,
      NULL,
      10,
      NULL,
      0.643272,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.852113,
      3.372414,
      3,
      0,
      2.028718,
      1.199105,
      NULL,
      1.398327,
      1,
      NULL,
      0,
      1,
      NULL,
      1.193262,
      1,
      NULL,
      2.124795,
      2.968141,
      NULL,
      NULL,
      0,
      NULL,
      2.755337,
      NULL,
      NULL,
      0.749885,
      1.743372,
      NULL,
      3,
      3.086435,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.103512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646839,
      NULL,
      0.319194,
      NULL,
      1.109847,
      5.130632,
      NULL,
      0.771503,
      NULL,
      NULL,
      NULL,
      115.832771,
      2.134883,
      1,
      3.155094,
      '44041',
      '22104',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


