set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.074205,
      3.626725,
      NULL,
      1.950587,
      3,
      NULL,
      3.490425,
      3.403246,
      '43',
      '42',
      NULL,
      41,
      '4304041',
      0,
      1,
      NULL,
      1,
      NULL,
      0.460504,
      1.332704,
      NULL,
      NULL,
      ' 6-28-1981',
      116.874539,
      25.436420,
      NULL,
      3,
      0.010920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.492273,
      ' 0-12-1998',
      ' 5-20-1982',
      '11-18-1976',
      0.770972,
      NULL,
      0.650503,
      NULL,
      1,
      0.731940,
      0,
      1.201191,
      NULL,
      3.182167,
      1.933011,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.261972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.732740,
      NULL,
      6,
      1,
      1,
      NULL,
      0.638947,
      1.428065,
      NULL,
      0.996265,
      0,
      1,
      1,
      0,
      5,
      0.664654,
      1.482168,
      0,
      1.600621,
      0,
      NULL,
      NULL,
      0.727208,
      0.135294,
      5,
      1,
      1.281456,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.233613,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.851463,
      5.927697,
      0.026910,
      1.767392,
      NULL,
      0,
      1.097115,
      1.988332,
      1,
      0.936541,
      0,
      NULL,
      0.327305,
      1,
      0,
      0,
      0.916325,
      0,
      NULL,
      0,
      1.110651,
      4,
      NULL,
      NULL,
      1.439505,
      NULL,
      NULL,
      1.541516,
      6,
      3,
      2,
      1.981963,
      4.415934,
      NULL,
      NULL,
      2.715325,
      5.610349,
      4,
      NULL,
      4.035537,
      NULL,
      1,
      2,
      0.636435,
      NULL,
      0.707997,
      1,
      ' 1-26-1975',
      462.904654,
      ' 9-20-1986',
      69,
      2.389250,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435446,
      0.896496,
      0.799882,
      0.130901,
      1.456372,
      2.702149,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.330084,
      0,
      2.407239,
      1.627920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.550270,
      1,
      3,
      0.207612,
      1,
      NULL,
      1.497865,
      NULL,
      2.280276,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      9,
      1,
      5,
      6.619005,
      0,
      NULL,
      ' 0-28-2000',
      NULL,
      ' 5-12-1975',
      4.714142,
      0,
      1.858940,
      1.538499,
      0.649730,
      0,
      0.067465,
      0.332431,
      NULL,
      1.320152,
      0.820534,
      3,
      8.258416,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.048855,
      1.152534,
      3,
      1,
      1.071963,
      3,
      0.619831,
      4,
      2.517994,
      1,
      2.998634,
      3,
      3.104192,
      2.500006,
      1,
      NULL,
      8.641878,
      NULL,
      1,
      NULL,
      1,
      1,
      1.417801,
      0,
      0.035758,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.784897,
      10.868695,
      9.584333,
      5,
      8,
      6.624235,
      NULL,
      1.749460,
      NULL,
      3,
      NULL,
      3,
      1.505271,
      NULL,
      1.321349,
      1,
      24,
      NULL,
      12,
      11.567293,
      NULL,
      1,
      NULL,
      '40412',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.010307,
      16.453309,
      NULL,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.691710,
      0,
      3.087384,
      1,
      NULL,
      NULL,
      1.356575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.679386,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.633933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.285562,
      NULL,
      NULL,
      1.186810,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.949433,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.710972,
      NULL,
      NULL,
      1.918950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.562956,
      3.201574,
      1.244646,
      2.469983,
      NULL,
      3.544443,
      NULL,
      NULL,
      2,
      0.685460,
      NULL,
      0,
      NULL,
      NULL,
      0.491095,
      NULL,
      2,
      NULL,
      3,
      3,
      0,
      0.409742,
      NULL,
      1.732226,
      2.997577,
      2,
      2,
      3,
      NULL,
      2.940150,
      3.189324,
      0,
      NULL,
      0.622175,
      1.489959,
      0,
      NULL,
      NULL,
      NULL,
      3.935202,
      3.931957,
      NULL,
      NULL,
      NULL,
      0.509030,
      NULL,
      NULL,
      0.938134,
      0.852810,
      0.733110,
      0,
      NULL,
      0.573365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.747065,
      2.961711,
      1,
      NULL,
      1.547904,
      1.268999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.605957,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.393003,
      NULL,
      NULL,
      NULL,
      0.179951,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248191,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.823061,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918990,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.491559,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.474117,
      0,
      1.806179,
      1.061774,
      1,
      1.903010,
      0.630314,
      0,
      1.319368,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.093416,
      2,
      9.031864,
      0.373606,
      6,
      NULL,
      5,
      1.180294,
      2,
      1,
      NULL,
      NULL,
      1.487164,
      NULL,
      1.994711,
      0.930050,
      1.208127,
      NULL,
      3.018893,
      1,
      0,
      NULL,
      0.633392,
      NULL,
      NULL,
      2,
      1,
      1,
      3.597550,
      0,
      0.842067,
      0.386886,
      0,
      1.322782,
      3,
      0,
      1,
      2,
      0,
      1.679371,
      3.499252,
      0.012747,
      2,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.338634,
      1.026239,
      2,
      1.012917,
      NULL,
      1.508281,
      1.896973,
      NULL,
      NULL,
      45.799260,
      NULL,
      NULL,
      1.774295,
      '44122',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.620400,
      '',
      '',
      '');
commit;
end;
/


