set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.009273,
      1,
      NULL,
      3,
      '3022',
      NULL,
      1.975289,
      NULL,
      NULL,
      ' 1-14-1980',
      NULL,
      NULL,
      3.477305,
      NULL,
      0.207818,
      ' 5- 1-1988',
      12,
      3.159695,
      40.399090,
      43.437732,
      1,
      ' 5-21-1976',
      ' 6- 8-1980',
      ' 3-13-1997',
      NULL,
      1.490258,
      2,
      NULL,
      0.848322,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.851739,
      2.650289,
      11.668667,
      NULL,
      4,
      2.263528,
      NULL,
      0.867220,
      4,
      0,
      3.806211,
      0,
      1,
      0,
      NULL,
      0.541396,
      0,
      1,
      0.141027,
      1.930617,
      0,
      5,
      3.561255,
      0.938990,
      NULL,
      1,
      0.157646,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.663653,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957360,
      0.713425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.195361,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068535,
      NULL,
      1.231169,
      NULL,
      0.852590,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.384601,
      NULL,
      4,
      NULL,
      1.576666,
      1,
      1.493662,
      NULL,
      7.933571,
      0,
      1.590379,
      1.157573,
      0,
      0.925248,
      0,
      NULL,
      2.105276,
      0,
      0.343883,
      0.156516,
      0.138859,
      NULL,
      1.330885,
      0.251054,
      NULL,
      NULL,
      0,
      3.054954,
      2,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.262082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.942278,
      1.264565,
      1.113808,
      0.567903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.866521,
      0,
      NULL,
      NULL,
      5.094936,
      0.039994,
      2.271970,
      3.171956,
      0.830539,
      NULL,
      NULL,
      NULL,
      5,
      1.142465,
      0,
      1,
      0.052620,
      NULL,
      NULL,
      NULL,
      NULL,
      2.452804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.084042,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      5.176313,
      0.315329,
      1,
      NULL,
      NULL,
      NULL,
      2.514833,
      0.488398,
      2,
      3,
      1,
      3,
      3,
      NULL,
      2.989063,
      6,
      0.727374,
      3,
      0.227684,
      NULL,
      10,
      NULL,
      121.670892,
      NULL,
      119,
      4.381163,
      NULL,
      158.498553,
      0.626806,
      0.552254,
      0,
      1.238845,
      0,
      1,
      0.909126,
      7,
      NULL,
      1,
      4,
      NULL,
      NULL,
      6,
      NULL,
      3.966666,
      4,
      2,
      1,
      3.830924,
      2.770998,
      3.376315,
      NULL,
      NULL,
      0.873981,
      NULL,
      NULL,
      24.416059,
      16,
      3.220425,
      1.767435,
      2.944453,
      '10310',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      8.800326,
      NULL,
      NULL,
      3,
      29.029551,
      NULL,
      3,
      3,
      1.894860,
      1,
      0,
      0,
      NULL,
      NULL,
      0.685801,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.854578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.258021,
      NULL,
      NULL,
      0.487040,
      NULL,
      NULL,
      0,
      5,
      0.390247,
      1.903666,
      0.875072,
      NULL,
      NULL,
      NULL,
      1.695105,
      NULL,
      NULL,
      NULL,
      3.707362,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.470183,
      NULL,
      NULL,
      0.766926,
      1,
      1.993150,
      1.777265,
      0.013467,
      NULL,
      3,
      0.454506,
      0,
      0,
      1.801908,
      0.752926,
      0.258777,
      2.071707,
      2.005919,
      0.827185,
      0,
      NULL,
      NULL,
      1.843500,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.536978,
      4,
      1.330800,
      1.104314,
      0.536475,
      NULL,
      NULL,
      NULL,
      1.096369,
      NULL,
      NULL,
      NULL,
      1.492267,
      NULL,
      NULL,
      0.507718,
      NULL,
      NULL,
      3,
      NULL,
      0.693412,
      0,
      NULL,
      NULL,
      4.657989,
      3,
      0,
      0.476230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.012710,
      2,
      0.940938,
      0.976524,
      NULL,
      NULL,
      0.083710,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919468,
      NULL,
      NULL,
      1,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.484021,
      2.564636,
      0,
      0,
      NULL,
      NULL,
      1.671807,
      NULL,
      NULL,
      2,
      0,
      0.596411,
      0.797019,
      NULL,
      NULL,
      NULL,
      0.413860,
      1,
      3,
      1.451604,
      1,
      0.458118,
      2.416458,
      1.803992,
      NULL,
      0.233870,
      1,
      1,
      NULL,
      NULL,
      3.539569,
      1.697770,
      0,
      3.355551,
      5,
      2.483320,
      1,
      NULL,
      NULL,
      1.765799,
      NULL,
      1.797353,
      1,
      0,
      0.995589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202655,
      0,
      NULL,
      0,
      1.462981,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.682754,
      0.019712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697003,
      NULL,
      0.084322,
      NULL,
      1.400933,
      0,
      NULL,
      1.673236,
      0.092357,
      0.133031,
      NULL,
      1,
      0.870974,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.185315,
      3,
      5,
      0.043886,
      NULL,
      2,
      1,
      NULL,
      2,
      2.158349,
      NULL,
      1.510716,
      0.250207,
      NULL,
      1,
      1,
      NULL,
      3.651775,
      2,
      NULL,
      1.620544,
      0.656926,
      NULL,
      3.764093,
      3,
      NULL,
      NULL,
      1.799546,
      NULL,
      1.788429,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.133713,
      NULL,
      1.664335,
      1,
      NULL,
      1.862566,
      1.476002,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854654,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.766926,
      2.686115,
      4.225681,
      0.006457,
      NULL,
      NULL,
      9.723427,
      139,
      5.625044,
      0.782958,
      1.527221,
      '03141',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL);
commit;
end;
/


