set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1,
      3.653481,
      0,
      0,
      NULL,
      0,
      0,
      '422',
      '44210444',
      52.277302,
      44.154614,
      '3142411',
      2.200887,
      NULL,
      5,
      2,
      '0411',
      3,
      1,
      NULL,
      NULL,
      ' 9-23-1978',
      NULL,
      39,
      NULL,
      3,
      3.346437,
      ' 0-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3-13-1974',
      NULL,
      ' 9-11-1985',
      0.444391,
      0,
      1.919451,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      5.143734,
      NULL,
      NULL,
      NULL,
      NULL,
      3.738965,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      0.787028,
      0.707418,
      NULL,
      3,
      2.737774,
      NULL,
      6,
      0.315535,
      1.196469,
      0,
      NULL,
      4.738976,
      7,
      1.410614,
      0,
      1,
      NULL,
      1,
      1.781627,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.304486,
      NULL,
      NULL,
      9,
      0,
      NULL,
      1,
      1.628943,
      NULL,
      2.991764,
      1.085377,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.205358,
      1,
      2,
      1,
      2.827198,
      2,
      6,
      NULL,
      6,
      6,
      1,
      2,
      1.416792,
      1.038558,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.702922,
      NULL,
      2,
      2,
      3,
      0,
      NULL,
      1,
      NULL,
      1.445745,
      0,
      5.018767,
      NULL,
      NULL,
      1.396019,
      1,
      0,
      0.492231,
      NULL,
      NULL,
      NULL,
      6.878627,
      1.290797,
      4,
      2,
      0.424944,
      2,
      7.637184,
      0.245295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675268,
      1.301585,
      3,
      2,
      NULL,
      4,
      1.234755,
      0,
      4,
      NULL,
      0.200890,
      0,
      2.910729,
      0,
      ' 9-22-1977',
      93.996019,
      NULL,
      48,
      1,
      0.616563,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904450,
      NULL,
      1.844816,
      0.609917,
      1.714182,
      1.387562,
      1.372472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.357874,
      0.216383,
      0.036486,
      1,
      1.438685,
      0,
      3,
      NULL,
      2,
      6.201990,
      0.261444,
      3,
      3,
      0.405351,
      NULL,
      0,
      4,
      3,
      2.235073,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.419165,
      1,
      7.268602,
      1.093726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      1,
      0.709357,
      1.781055,
      0.184941,
      10.819355,
      3.269233,
      NULL,
      NULL,
      NULL,
      NULL,
      3.734260,
      1,
      3.462450,
      2,
      NULL,
      0,
      0,
      3,
      0.551868,
      NULL,
      0,
      3.953187,
      1.950789,
      3.982499,
      1,
      3,
      3,
      NULL,
      0.596967,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.941572,
      2,
      NULL,
      0,
      1,
      1.436248,
      2.069150,
      1,
      5,
      NULL,
      0,
      7.763914,
      11,
      4,
      3.022471,
      NULL,
      NULL,
      0.437224,
      2,
      2.515809,
      18.797422,
      3.471392,
      3.369154,
      23,
      NULL,
      24.383207,
      9,
      NULL,
      NULL,
      0.351643,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.471100,
      '',
      '',
      '',
      3.140138,
      NULL,
      NULL,
      18.748355,
      0.984842,
      14,
      3,
      0,
      NULL,
      2.060341,
      1,
      NULL,
      1.365949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.210484,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571993,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.183954,
      1.158394,
      1.406685,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.109778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.446805,
      1,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4.132450,
      1.183502,
      0.139385,
      1.884791,
      NULL,
      NULL,
      1.767841,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687514,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      3,
      1,
      NULL,
      7.562140,
      NULL,
      5.086571,
      0.079724,
      NULL,
      0.859438,
      NULL,
      NULL,
      1.907782,
      3.774996,
      1.595768,
      3.886820,
      3,
      3.777463,
      0,
      NULL,
      2,
      0.072819,
      5,
      3.319753,
      1.893300,
      3.881090,
      NULL,
      2,
      0,
      2.419938,
      0.457854,
      NULL,
      2.379267,
      NULL,
      NULL,
      0,
      NULL,
      6,
      2.329512,
      1.005011,
      2.493847,
      NULL,
      1,
      4.777594,
      6.820576,
      0,
      1,
      NULL,
      1.994771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475000,
      NULL,
      NULL,
      0.198144,
      NULL,
      NULL,
      0.253667,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.234844,
      NULL,
      NULL,
      2.268892,
      NULL,
      NULL,
      1.440233,
      NULL,
      NULL,
      NULL,
      3.599530,
      NULL,
      1,
      NULL,
      3.178102,
      1.078251,
      NULL,
      NULL,
      0.023709,
      NULL,
      NULL,
      NULL,
      461,
      NULL,
      NULL,
      NULL,
      1.038764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.029981,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.659691,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.628982,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.845339,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.355170,
      NULL,
      NULL,
      NULL,
      0.425348,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.394399,
      NULL,
      NULL,
      NULL,
      0.138116,
      0.177497,
      1,
      1,
      NULL,
      2.883796,
      0,
      NULL,
      NULL,
      1,
      5.141326,
      19.266358,
      NULL,
      NULL,
      NULL,
      0.509331,
      NULL,
      NULL,
      0.822437,
      NULL,
      1.011057,
      209.567689,
      5,
      0.312647,
      NULL,
      NULL,
      1.439365,
      1,
      1,
      0.963872,
      NULL,
      1,
      1.633775,
      NULL,
      1,
      1.507877,
      0.502472,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.442810,
      2.053058,
      1.980070,
      1,
      3.723383,
      NULL,
      3.955652,
      2,
      1.243395,
      3.174327,
      1.226687,
      0.608187,
      0,
      NULL,
      1,
      1,
      NULL,
      0.613939,
      0,
      NULL,
      1.601274,
      0,
      NULL,
      0,
      1,
      NULL,
      1.191605,
      1,
      NULL,
      1.611249,
      1,
      NULL,
      1.366617,
      1,
      NULL,
      1.441496,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.217650,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.735913,
      NULL,
      3.791368,
      7,
      6,
      1,
      NULL,
      NULL,
      NULL,
      126.579783,
      2,
      5,
      0,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1.638024,
      '',
      '',
      '');
commit;
end;
/


