set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7114559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3234321',
      0,
      0,
      1,
      0,
      '0141',
      1,
      1,
      1.124307,
      14,
      NULL,
      NULL,
      NULL,
      2.376330,
      1,
      1.826739,
      ' 8-25-1986',
      8.020147,
      1.695498,
      325,
      NULL,
      6.337169,
      NULL,
      NULL,
      '10- 9-1981',
      NULL,
      0.549255,
      NULL,
      1.628394,
      NULL,
      NULL,
      4.065145,
      1,
      1.713771,
      NULL,
      2.955471,
      NULL,
      10,
      6.987730,
      5.698119,
      7,
      8.434058,
      6,
      5.481810,
      10,
      1.841016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.126321,
      0.450357,
      1,
      1.389144,
      0.694823,
      0.263527,
      0.760108,
      NULL,
      0,
      1,
      1,
      1.906084,
      1.118570,
      1,
      0.130131,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010963,
      1.427660,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180928,
      0.478429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.017439,
      NULL,
      1.882019,
      1.899877,
      2,
      1.212756,
      NULL,
      NULL,
      NULL,
      0.764940,
      0,
      1.594004,
      NULL,
      NULL,
      1,
      1.260105,
      NULL,
      0.613630,
      0.623464,
      NULL,
      0,
      1.743375,
      4,
      1.810455,
      NULL,
      NULL,
      2,
      3.145304,
      1,
      1.292177,
      1.462646,
      3.376032,
      NULL,
      1.074927,
      0.121398,
      7.221134,
      2,
      0.833386,
      1,
      0.251722,
      2.714802,
      0.368487,
      6.806244,
      9,
      4.797242,
      7.239038,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.873867,
      0.131408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592429,
      0,
      0,
      1,
      NULL,
      1.464388,
      0.932292,
      0.992704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290404,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.440831,
      0,
      1.444490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.098273,
      NULL,
      0.734376,
      NULL,
      NULL,
      0.703639,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.853952,
      1,
      2,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      2,
      10,
      NULL,
      3,
      3.424543,
      1,
      4.471065,
      NULL,
      0,
      1.188148,
      0.599988,
      0.645087,
      0,
      NULL,
      1,
      0.558125,
      NULL,
      4.702782,
      0.814799,
      8,
      3.804924,
      0,
      0.983988,
      0.533351,
      1.511366,
      NULL,
      0.042568,
      3,
      2,
      3,
      2,
      13,
      0.330649,
      0,
      51,
      NULL,
      NULL,
      NULL,
      6.598574,
      1.181784,
      2,
      '3334',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      2.688010,
      '0012',
      '',
      '',
      3,
      6.068438,
      230.838043,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.372587,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716740,
      NULL,
      NULL,
      1.238865,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.983563,
      NULL,
      NULL,
      1.071442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470009,
      NULL,
      NULL,
      0.129467,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.051003,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.337656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.497436,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      16.956857,
      15.092335,
      0.407421,
      NULL,
      NULL,
      5,
      1,
      0.749698,
      8.940593,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.530046,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.688677,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.627870,
      14,
      9,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.128690,
      1,
      NULL,
      3.408132,
      13,
      0,
      2,
      NULL,
      0.862015,
      NULL,
      0.947206,
      2,
      1.014384,
      NULL,
      1.860487,
      NULL,
      NULL,
      NULL,
      3.045306,
      NULL,
      1.009228,
      0.089621,
      14.706213,
      1.483936,
      NULL,
      NULL,
      6.460055,
      NULL,
      2.769364,
      3,
      1.562657,
      NULL,
      NULL,
      1.479988,
      1.800593,
      NULL,
      1.694175,
      NULL,
      1.806488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.789977,
      0.387864,
      NULL,
      1,
      0.789772,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354764,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.130945,
      NULL,
      NULL,
      0.895768,
      NULL,
      NULL,
      0,
      NULL,
      343.624246,
      1,
      NULL,
      NULL,
      1.076754,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5689.794066,
      841,
      1,
      1.653447,
      1.795620,
      1,
      1.438262,
      0,
      NULL,
      0.658691,
      1.350760,
      0.862263,
      1.058267,
      0,
      1.498855,
      1,
      0.169642,
      0,
      0.814405,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.245090,
      NULL,
      NULL,
      3,
      5.461084,
      NULL,
      7.949426,
      NULL,
      3.065778,
      1,
      1.932948,
      0,
      NULL,
      NULL,
      0.039144,
      NULL,
      NULL,
      3.399075,
      NULL,
      NULL,
      0.128543,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.157638,
      NULL,
      NULL,
      0.459334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.960569,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844005,
      NULL,
      0,
      NULL,
      0.814673,
      NULL,
      0,
      3.340153,
      11,
      0,
      2.242691,
      1,
      92.940797,
      NULL,
      5.694624,
      NULL,
      NULL,
      '4233',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.903569,
      '2211',
      '',
      '');
commit;
end;
/


