set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1020034',
      3.353407,
      0.823296,
      5,
      1,
      '4032',
      NULL,
      1.127254,
      NULL,
      NULL,
      ' 8- 4-1980',
      58,
      NULL,
      4.985200,
      3.559915,
      1.983801,
      ' 0-25-1984',
      2.218557,
      1.670766,
      48.573618,
      NULL,
      3,
      ' 9-16-1983',
      NULL,
      '11-11-1992',
      NULL,
      1.253723,
      0.005992,
      NULL,
      0,
      NULL,
      3,
      0,
      1.586407,
      3.858582,
      11,
      7,
      0,
      29.493034,
      2.569462,
      1.195936,
      7.002344,
      3,
      6,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.788905,
      0,
      12.133310,
      2,
      0.348830,
      NULL,
      3,
      NULL,
      0.513705,
      4,
      4.490825,
      1.204834,
      NULL,
      1.454109,
      NULL,
      0,
      NULL,
      6.101185,
      2.522655,
      1.039212,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.546106,
      0.977305,
      3.240544,
      0,
      0.392788,
      1,
      2.995611,
      3,
      0,
      0.028592,
      NULL,
      1.613102,
      3.685338,
      0,
      1,
      NULL,
      2,
      3,
      7,
      5,
      NULL,
      9.978701,
      4,
      3,
      0.738074,
      1.529297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.577267,
      11,
      0,
      2.718499,
      7,
      NULL,
      4,
      1,
      NULL,
      3.873913,
      1,
      2.966181,
      NULL,
      2,
      NULL,
      1.676802,
      0.328736,
      0.549983,
      NULL,
      NULL,
      0,
      7.427097,
      5,
      NULL,
      2,
      5,
      7.365663,
      1,
      0.518957,
      0,
      6.308217,
      1,
      NULL,
      8,
      NULL,
      0,
      0.006837,
      NULL,
      0,
      6.968550,
      NULL,
      0,
      8.271962,
      1.815645,
      NULL,
      1.839862,
      7,
      1,
      ' 5-10-1990',
      33,
      NULL,
      NULL,
      0.752850,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      5,
      0.604125,
      NULL,
      3.765218,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.812867,
      2,
      2.939494,
      1,
      2.053180,
      1.603246,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233467,
      1.387697,
      3,
      1.721869,
      0.072875,
      2,
      96,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.065573,
      2,
      0.895767,
      2,
      NULL,
      NULL,
      1.755286,
      0.161234,
      NULL,
      3.089736,
      3.327701,
      2.606188,
      3,
      2.458419,
      NULL,
      1,
      0.677438,
      0.211839,
      1,
      3.113719,
      1,
      1.102370,
      1.559202,
      1.671416,
      NULL,
      1.330477,
      NULL,
      2,
      3,
      NULL,
      4,
      7.726260,
      7,
      1,
      3.666790,
      5.306109,
      4.164385,
      3,
      5,
      3,
      1,
      NULL,
      26.335773,
      3.950442,
      1,
      NULL,
      9,
      10.060581,
      NULL,
      1,
      NULL,
      1.454790,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      42.074862,
      90.227892,
      NULL,
      0.923489,
      NULL,
      0,
      0.519642,
      0,
      3,
      3.524532,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0.580007,
      3,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.937817,
      NULL,
      NULL,
      NULL,
      1.616036,
      NULL,
      NULL,
      1,
      3,
      0.085609,
      0,
      0.363136,
      0.899315,
      0.355430,
      NULL,
      3.332146,
      0.669002,
      NULL,
      1,
      NULL,
      NULL,
      6,
      5.047421,
      3.347322,
      1,
      3.954468,
      1.023101,
      1.319700,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.808828,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.556439,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.834769,
      1,
      0.183766,
      0,
      3.321693,
      0,
      1.213120,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.704459,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.976258,
      NULL,
      NULL,
      0.882643,
      NULL,
      NULL,
      5,
      7,
      0,
      0.968615,
      1.066111,
      0.217348,
      NULL,
      0,
      NULL,
      9,
      5.695899,
      2,
      1.388943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.734521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.154219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.684447,
      3,
      1.566483,
      2.435884,
      1.483105,
      4.437604,
      NULL,
      0.966212,
      2,
      3.568249,
      3,
      3,
      3.591305,
      NULL,
      0.010866,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      5.369469,
      7,
      NULL,
      3.480367,
      NULL,
      1,
      3,
      5.068401,
      1.746900,
      0,
      NULL,
      1.512613,
      3.858905,
      3.870915,
      NULL,
      7,
      3,
      NULL,
      61,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1.644791,
      NULL,
      NULL,
      1.008414,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.569961,
      NULL,
      3,
      0.296682,
      NULL,
      11,
      7,
      NULL,
      3.787440,
      0,
      0.654798,
      0.746250,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.873891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436358,
      NULL,
      NULL,
      NULL,
      1.142598,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.568216,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.995731,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      1.402836,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.689818,
      1,
      NULL,
      NULL,
      1.682667,
      NULL,
      NULL,
      0.836550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1,
      NULL,
      1,
      281,
      0.116100,
      0.161579,
      1.235570,
      NULL,
      0.609480,
      1,
      1.452555,
      1.193825,
      NULL,
      0.487224,
      NULL,
      1,
      NULL,
      0,
      0,
      1.404926,
      1.578410,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.291615,
      NULL,
      1,
      NULL,
      2.392818,
      2,
      8.694985,
      0,
      1.096654,
      0.723607,
      0.352675,
      1.870135,
      1,
      0,
      3,
      2.808707,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      2.898908,
      NULL,
      3,
      3.003255,
      NULL,
      0,
      0.366058,
      NULL,
      3,
      2.297417,
      0.419786,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.057594,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1.996203,
      9.192064,
      5,
      1,
      NULL,
      NULL,
      66,
      115,
      0,
      1.884867,
      3.816822,
      '00043',
      '',
      NULL,
      0.649061,
      '',
      '',
      NULL,
      0.601567,
      '',
      '',
      '');
commit;
end;
/


