set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '44',
      18,
      1,
      '4043304',
      3.562836,
      0,
      2,
      1,
      '2334',
      1.859255,
      0.581739,
      NULL,
      NULL,
      NULL,
      7.919755,
      6.213575,
      NULL,
      NULL,
      9,
      ' 2- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '10- 9-1989',
      1,
      0,
      NULL,
      0,
      2.969725,
      1.489340,
      3.790744,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.913516,
      0.093456,
      0,
      3,
      NULL,
      0,
      1.925432,
      0,
      1,
      0,
      1.073645,
      0,
      1.305974,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1.911214,
      1.975372,
      2,
      0.555847,
      0.732629,
      NULL,
      2.961390,
      NULL,
      2,
      1.702766,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.670756,
      0,
      1.771992,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.333673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.144375,
      0.432403,
      0,
      NULL,
      0,
      NULL,
      0,
      1.889648,
      5.716474,
      0.108773,
      1.360455,
      0,
      NULL,
      0,
      1.340238,
      NULL,
      NULL,
      1,
      NULL,
      1.053330,
      0.238554,
      NULL,
      0.297050,
      1.883656,
      NULL,
      5.835568,
      1.094892,
      0,
      1,
      NULL,
      0.998225,
      1,
      NULL,
      1.185592,
      NULL,
      0,
      1,
      1.031384,
      0,
      0,
      1,
      1.345989,
      3.504184,
      1,
      1,
      NULL,
      0.232101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.428957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001959,
      1,
      1.068389,
      NULL,
      NULL,
      0.006045,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681836,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626965,
      0,
      1.408827,
      0,
      0,
      1.602106,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636070,
      1.553106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.655359,
      NULL,
      1.048325,
      1.748796,
      1,
      1.266956,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.471123,
      1,
      NULL,
      2.795284,
      2.682637,
      NULL,
      0,
      1.586630,
      3,
      1.337762,
      3,
      NULL,
      4,
      7.148174,
      2.797762,
      1,
      8,
      0.410793,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1.690053,
      0,
      0.048090,
      3,
      0.501795,
      2.465650,
      0.801919,
      NULL,
      NULL,
      4,
      11,
      7.352116,
      6,
      5.435828,
      0,
      NULL,
      3.691160,
      1,
      NULL,
      49,
      1,
      1.786138,
      125,
      NULL,
      NULL,
      NULL,
      3,
      5.133116,
      NULL,
      '04231',
      NULL,
      '',
      0,
      '11440',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.770248,
      5,
      133,
      55.196476,
      1.158465,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.218838,
      NULL,
      NULL,
      0,
      NULL,
      1.449044,
      3,
      1.358965,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.471190,
      NULL,
      NULL,
      1.471493,
      NULL,
      NULL,
      1.275548,
      NULL,
      NULL,
      4.285880,
      1,
      0.768043,
      0,
      0.512064,
      NULL,
      NULL,
      NULL,
      0.903512,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.359475,
      NULL,
      NULL,
      1.715282,
      NULL,
      NULL,
      0.109253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457744,
      NULL,
      NULL,
      0.079537,
      NULL,
      NULL,
      1.269419,
      NULL,
      NULL,
      0.249298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.989937,
      1,
      1.796529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.346142,
      0,
      3,
      1,
      0.700226,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847530,
      NULL,
      1.373754,
      NULL,
      NULL,
      0.556589,
      NULL,
      NULL,
      0.273315,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564014,
      NULL,
      NULL,
      1.986449,
      NULL,
      NULL,
      0,
      NULL,
      0.297889,
      1.220037,
      0.536090,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.960226,
      1,
      NULL,
      NULL,
      3,
      0.592575,
      1,
      0,
      NULL,
      NULL,
      2,
      5.060827,
      1.913832,
      0,
      3.914300,
      2.591706,
      1,
      NULL,
      0,
      0.723554,
      3,
      NULL,
      3.511917,
      1,
      1,
      1,
      1.783654,
      4.925028,
      0,
      NULL,
      NULL,
      0.995186,
      NULL,
      NULL,
      1,
      1,
      0.574264,
      0,
      1,
      0.105101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.359445,
      1.122144,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.965800,
      NULL,
      NULL,
      NULL,
      1.608147,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.984216,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.317556,
      NULL,
      NULL,
      NULL,
      1.935134,
      NULL,
      NULL,
      NULL,
      0.037780,
      NULL,
      NULL,
      NULL,
      1.640018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.533168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.522194,
      NULL,
      NULL,
      1.294669,
      NULL,
      1,
      1.556388,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.631884,
      0,
      1.337858,
      0.978974,
      0.998987,
      0.707041,
      0.453089,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1.809700,
      NULL,
      0.443039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.344113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486902,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032320,
      0.123414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.631570,
      NULL,
      1.315895,
      NULL,
      NULL,
      NULL,
      1.964873,
      0.039700,
      NULL,
      NULL,
      1.704771,
      NULL,
      0.526872,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.038528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.183561,
      4.498063,
      2,
      7,
      2,
      0,
      4.517101,
      3,
      14.641387,
      2.298175,
      0,
      1,
      0,
      1.436716,
      1.685347,
      1,
      0.451963,
      1,
      1.963986,
      1.509453,
      0,
      0.106247,
      1.305620,
      1.119294,
      1.258847,
      1.091636,
      0.207515,
      2.229832,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2.441113,
      1,
      2.384443,
      1.871860,
      1,
      NULL,
      1.743980,
      2,
      0,
      NULL,
      1.745223,
      1.571372,
      1,
      NULL,
      NULL,
      1.948467,
      0.183440,
      1.977132,
      NULL,
      NULL,
      1.056063,
      0.515846,
      NULL,
      0.939767,
      0.045192,
      1,
      1,
      0.145759,
      2,
      0.240955,
      2,
      0.035529,
      1.053504,
      1,
      NULL,
      0,
      1.149939,
      1.167291,
      NULL,
      1.584219,
      0,
      34.285046,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037962,
      NULL,
      0,
      0,
      0,
      1,
      1.473825,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      25.584534,
      130.154794,
      6,
      0,
      3.607853,
      '12320',
      '',
      '',
      1.988664,
      '44223',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


