set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '2222324',
      0,
      1,
      4,
      0,
      '2441',
      2,
      1,
      NULL,
      NULL,
      NULL,
      68.319823,
      NULL,
      NULL,
      3,
      1,
      ' 3-13-1988',
      9.558983,
      4,
      139,
      21.072731,
      2,
      '11-14-1996',
      ' 5- 3-1992',
      ' 6-29-1999',
      2.286197,
      3.207123,
      0.535020,
      2,
      1.402219,
      0,
      NULL,
      0,
      NULL,
      NULL,
      7.926717,
      14,
      1,
      15.518615,
      14.044872,
      7.754703,
      19.499409,
      3,
      0,
      3,
      1,
      0,
      1.965589,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365959,
      0.037693,
      1,
      NULL,
      3,
      4,
      2,
      3,
      NULL,
      1,
      0,
      5,
      0,
      1.901183,
      2,
      1,
      NULL,
      2.020938,
      1.585981,
      0,
      7.700424,
      1.084409,
      NULL,
      NULL,
      4.250378,
      1.180647,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.453288,
      2.410398,
      3,
      1,
      2,
      3.926390,
      1.538653,
      3,
      NULL,
      NULL,
      3.709071,
      3,
      2.832382,
      0.498281,
      1,
      2,
      3.222258,
      0,
      0,
      2,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.481251,
      NULL,
      NULL,
      6,
      2,
      4,
      2.807160,
      2,
      NULL,
      3,
      2.028554,
      5,
      1,
      3,
      2,
      NULL,
      NULL,
      0.655422,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      4.364851,
      3.265381,
      NULL,
      2,
      NULL,
      0.407233,
      3.136820,
      2,
      NULL,
      NULL,
      NULL,
      2.016556,
      7,
      2,
      0,
      2,
      11,
      8.512746,
      4,
      3,
      6,
      8.888255,
      7.825462,
      5,
      3.876825,
      NULL,
      ' 1-13-1991',
      216.502852,
      NULL,
      NULL,
      0.113288,
      NULL,
      NULL,
      1.071786,
      0.567031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013304,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      1.116720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.785970,
      3,
      1,
      1,
      1,
      3.969018,
      1.940316,
      0,
      0.539324,
      0,
      9,
      0.390674,
      NULL,
      NULL,
      NULL,
      0,
      4.715004,
      0.460929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900066,
      0.271793,
      1.376812,
      NULL,
      1,
      2.620567,
      0,
      3.094098,
      33.538834,
      3.960885,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.766421,
      0.037115,
      0,
      NULL,
      0.980199,
      2,
      3.539065,
      0.253851,
      3,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      44.117741,
      NULL,
      NULL,
      155,
      109,
      1.969287,
      1.333183,
      1,
      1.809684,
      1.907849,
      NULL,
      1,
      14,
      0.396836,
      NULL,
      NULL,
      0,
      3.917139,
      7.423623,
      3,
      4.622685,
      NULL,
      NULL,
      7.422291,
      3.270844,
      NULL,
      3.838310,
      18.124903,
      1,
      3.855322,
      NULL,
      10.659324,
      22.125117,
      12.464615,
      1,
      0,
      1,
      '40002',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.263812,
      32,
      1,
      32,
      3,
      25,
      4.445289,
      NULL,
      3.929468,
      NULL,
      3.660290,
      1,
      0.765499,
      NULL,
      NULL,
      1,
      NULL,
      1.413809,
      2.115293,
      NULL,
      0.573946,
      1,
      1,
      0.216479,
      1,
      NULL,
      NULL,
      3,
      3.548031,
      1,
      NULL,
      2,
      0.965246,
      1,
      NULL,
      NULL,
      2.946789,
      1,
      1.534209,
      2,
      0.391477,
      0,
      1.833157,
      NULL,
      NULL,
      NULL,
      3.670138,
      1,
      1.098582,
      0.341477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.232987,
      NULL,
      2,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1.203687,
      NULL,
      1,
      2,
      0,
      NULL,
      3,
      NULL,
      2.828296,
      2,
      0.437078,
      3,
      3,
      1.956424,
      3.850143,
      1,
      1.396472,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.350209,
      10,
      5.098714,
      2.571839,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.286306,
      NULL,
      NULL,
      1.189787,
      1,
      0,
      1,
      NULL,
      NULL,
      0.437750,
      NULL,
      NULL,
      9.214443,
      2,
      3.709105,
      2.206519,
      2.772198,
      3,
      1.308124,
      0,
      2,
      8,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006798,
      NULL,
      NULL,
      0.094611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.172427,
      NULL,
      NULL,
      1.416896,
      0,
      1.348726,
      8,
      2.134772,
      NULL,
      3,
      7.059779,
      NULL,
      7.482104,
      NULL,
      2.405486,
      3,
      0.669148,
      1,
      0,
      0.692959,
      2,
      3,
      NULL,
      0.945680,
      NULL,
      4,
      3,
      1.736089,
      0,
      1.921878,
      NULL,
      1,
      NULL,
      3.198285,
      1.745322,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      4.736359,
      0.876939,
      1,
      2,
      2,
      6,
      0.478648,
      1.436555,
      0.200527,
      0,
      1,
      3.841502,
      NULL,
      NULL,
      1.522895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.699468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.392158,
      0,
      0.208976,
      NULL,
      1,
      3.548705,
      1,
      NULL,
      NULL,
      3.769308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.892159,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.074672,
      NULL,
      NULL,
      NULL,
      1.515945,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.032352,
      8,
      22.097429,
      1.100915,
      9,
      2,
      NULL,
      NULL,
      NULL,
      0.976206,
      0.506012,
      0.541506,
      0,
      65.956761,
      3.266766,
      1,
      0,
      11,
      0.723663,
      NULL,
      1.549436,
      66.765159,
      1.002381,
      NULL,
      0.331292,
      0.669437,
      1.312890,
      0,
      NULL,
      NULL,
      0,
      0,
      1.147993,
      NULL,
      1.726657,
      NULL,
      1,
      0.839748,
      NULL,
      0,
      1.341177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127427,
      1.381603,
      2.276774,
      9,
      NULL,
      3.517338,
      4,
      1.700753,
      NULL,
      NULL,
      2.756488,
      0.640475,
      0.573298,
      1.410498,
      NULL,
      NULL,
      1.235838,
      NULL,
      0.774696,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.404148,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.536801,
      NULL,
      NULL,
      3,
      NULL,
      0.417927,
      NULL,
      NULL,
      1,
      1.998215,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678491,
      NULL,
      1.889069,
      NULL,
      NULL,
      NULL,
      6.468449,
      NULL,
      1,
      0.843490,
      NULL,
      NULL,
      67.736491,
      14.210939,
      0,
      0,
      NULL,
      '10424',
      '',
      '',
      1.668231,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


