set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7703389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      0,
      0.433772,
      5.030115,
      1.952960,
      0.714514,
      2.826049,
      '411',
      '43430011',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350670,
      NULL,
      NULL,
      ' 8-23-1993',
      126,
      57,
      NULL,
      1,
      0.896408,
      ' 9- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      2.229589,
      NULL,
      NULL,
      ' 3-14-2002',
      NULL,
      0.299647,
      2.074670,
      1,
      NULL,
      1,
      0.858026,
      1,
      0.146695,
      134.427498,
      8.808217,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990776,
      2.939011,
      NULL,
      2.178422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.199061,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.755676,
      NULL,
      1,
      0,
      1.081308,
      0,
      0.303991,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925384,
      NULL,
      1.207122,
      0.170865,
      1.187326,
      1,
      2.407901,
      0.925977,
      0.908918,
      1.954929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.301308,
      1.102562,
      NULL,
      1.466191,
      3,
      3.394435,
      NULL,
      4.876927,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711557,
      NULL,
      1.104685,
      0.608057,
      1,
      1.947803,
      NULL,
      1.115270,
      NULL,
      0,
      1.406123,
      NULL,
      0,
      0,
      1,
      1.160088,
      0.700634,
      0.907661,
      0,
      NULL,
      1,
      1.166890,
      0,
      0.633142,
      0.347836,
      1,
      1.296214,
      1.832170,
      0,
      1,
      1,
      1,
      0,
      1,
      0.288405,
      1,
      1,
      1.039219,
      1,
      0.407560,
      0.327372,
      1,
      1,
      NULL,
      0.319609,
      1,
      0,
      NULL,
      ' 9- 6-1988',
      1899,
      ' 0-26-1995',
      716.906026,
      1,
      1.386211,
      1.475975,
      1,
      0.624594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.685908,
      NULL,
      1.904989,
      1,
      1.630362,
      0.632452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940691,
      0.017594,
      1.514252,
      1.733196,
      0,
      1,
      1.757073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149852,
      0.892114,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328686,
      NULL,
      0,
      1,
      1,
      0.369165,
      0.280907,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.817420,
      5,
      3,
      3,
      NULL,
      2,
      4.396142,
      NULL,
      4.106439,
      1.225738,
      5,
      1,
      0.785865,
      0.415290,
      0.077698,
      NULL,
      1.701174,
      0.808851,
      NULL,
      0.816800,
      NULL,
      0.040025,
      1,
      0,
      1,
      1,
      0.808723,
      3,
      5.585594,
      0.308399,
      1,
      5.659328,
      1.504246,
      11.020891,
      10.068486,
      6.534078,
      5,
      NULL,
      3.672449,
      3,
      2.084253,
      1,
      25.174036,
      0.714175,
      1,
      67,
      NULL,
      NULL,
      NULL,
      4.395462,
      0.469975,
      0,
      '11222',
      '',
      '',
      1.497948,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      3,
      18,
      NULL,
      33,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.017050,
      3,
      1.271038,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.551436,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.686341,
      NULL,
      0,
      1,
      1.612986,
      1,
      3,
      0.462247,
      1,
      NULL,
      0,
      0.140311,
      2,
      1,
      0.575679,
      1.147309,
      0.733826,
      0,
      6,
      NULL,
      9,
      3.838608,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.549954,
      2.889628,
      3.410862,
      NULL,
      1.790103,
      3,
      1,
      NULL,
      3,
      3,
      NULL,
      1.348887,
      2.557484,
      NULL,
      2,
      3.381414,
      1,
      3,
      NULL,
      0,
      0.236529,
      0.899830,
      3.341196,
      1,
      NULL,
      1.995309,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.741527,
      0,
      1,
      10,
      3,
      1.111478,
      0,
      1.711425,
      NULL,
      NULL,
      NULL,
      0.944118,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.278844,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.206225,
      NULL,
      NULL,
      2.128910,
      1,
      1,
      NULL,
      1.382437,
      0.311796,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394638,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.516768,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820554,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.220379,
      NULL,
      NULL,
      2,
      0.098663,
      4,
      0,
      NULL,
      NULL,
      NULL,
      2.609311,
      1.521384,
      3.967410,
      NULL,
      NULL,
      1.572000,
      2.653582,
      2,
      2.406481,
      1,
      3,
      0.463273,
      0,
      0,
      3.611457,
      NULL,
      1.128096,
      1,
      0.874926,
      0,
      3.477900,
      0.238048,
      3,
      5,
      4.049484,
      NULL,
      0.489608,
      NULL,
      NULL,
      3,
      3,
      0.455210,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.808573,
      NULL,
      NULL,
      99,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262997,
      NULL,
      NULL,
      0.306795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574896,
      NULL,
      NULL,
      1.940239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298019,
      NULL,
      NULL,
      0.256145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.064799,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.847768,
      NULL,
      NULL,
      NULL,
      1.978054,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.643717,
      0,
      NULL,
      1.321593,
      1.010230,
      152.981830,
      373,
      1,
      74.652319,
      4.376282,
      NULL,
      NULL,
      NULL,
      1,
      25,
      3.197413,
      1.441668,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859854,
      NULL,
      1.668635,
      NULL,
      17,
      1,
      NULL,
      0.271838,
      2.798567,
      0.252713,
      NULL,
      0,
      2,
      0,
      1.291636,
      0,
      1,
      NULL,
      1,
      1.296233,
      0,
      NULL,
      0.069614,
      NULL,
      0.418241,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.816325,
      NULL,
      3,
      NULL,
      20.362271,
      NULL,
      2.040296,
      15,
      NULL,
      0.885032,
      1,
      NULL,
      NULL,
      0.812553,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.256471,
      NULL,
      1.162905,
      NULL,
      0.713537,
      NULL,
      1.758639,
      NULL,
      0.520168,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.877942,
      NULL,
      NULL,
      NULL,
      0.849753,
      2.342250,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223364,
      0.368825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.950230,
      NULL,
      NULL,
      NULL,
      1.505081,
      NULL,
      0.430270,
      NULL,
      1,
      NULL,
      1.762577,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695265,
      NULL,
      NULL,
      0.405665,
      NULL,
      0.729358,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.816689,
      0,
      1.571899,
      NULL,
      NULL,
      1.404731,
      0.992327,
      1,
      2,
      1.546164,
      0.480179,
      NULL,
      NULL,
      1.376351,
      1.376944,
      NULL,
      NULL,
      1.418314,
      NULL,
      0,
      1.335543,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.984806,
      1,
      NULL,
      1.958303,
      1,
      NULL,
      1.457532,
      2.783968,
      NULL,
      1.065590,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.230993,
      NULL,
      0.802548,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      42,
      1,
      0.913606,
      5,
      2,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.343664,
      NULL,
      NULL,
      '');
commit;
end;
/


