set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9423644';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.908523,
      2.341978,
      2.967747,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      '03003121',
      53.246422,
      NULL,
      '1303333',
      0,
      0.212534,
      0,
      1,
      '0023',
      0,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1978',
      139.461099,
      5,
      NULL,
      1.750133,
      1.553319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '11-25-1983',
      0.155915,
      1.859076,
      1.836146,
      1,
      1,
      NULL,
      2,
      3.280986,
      NULL,
      NULL,
      NULL,
      8.911914,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.081579,
      0,
      0.732384,
      0,
      0.451529,
      0,
      0,
      1.398731,
      3,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0.604840,
      1.779100,
      1.944405,
      1,
      0.800509,
      0.157140,
      0,
      0.989234,
      0,
      0.847133,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799057,
      0.444423,
      NULL,
      1.765672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641009,
      1.569153,
      1.937758,
      1,
      1.863088,
      1,
      0.962399,
      0.562894,
      0.999694,
      0.557850,
      0,
      0,
      1,
      0.164731,
      0.290201,
      0.000918,
      0,
      NULL,
      1.726143,
      NULL,
      1,
      1.279577,
      NULL,
      1,
      1.767382,
      1.411556,
      0.303041,
      2,
      1,
      1,
      0,
      NULL,
      0.095367,
      1.536419,
      1.626005,
      NULL,
      NULL,
      1.601530,
      1,
      1,
      5.871220,
      1,
      0,
      0,
      NULL,
      NULL,
      0.097443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.553061,
      0.932626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.730843,
      0,
      1.612073,
      1.273082,
      1.019592,
      1.920898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374098,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.454850,
      2,
      1.596539,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.699368,
      0.058822,
      1.301086,
      0,
      0.419957,
      NULL,
      NULL,
      NULL,
      0.366593,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.017059,
      0,
      1.294581,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637348,
      3,
      3.686012,
      2,
      0.885928,
      NULL,
      3.253170,
      1.866698,
      NULL,
      0.428467,
      NULL,
      0.920380,
      NULL,
      1,
      NULL,
      0.069554,
      NULL,
      NULL,
      NULL,
      1.514224,
      NULL,
      0,
      0.839300,
      0,
      0.485460,
      NULL,
      NULL,
      0,
      1.154505,
      1.110287,
      1.439172,
      11.608927,
      6.495376,
      3.517869,
      7,
      3,
      5.744300,
      2,
      0.992545,
      1.491835,
      1,
      3.292978,
      3.183372,
      63,
      3.192246,
      0.372823,
      45,
      NULL,
      NULL,
      NULL,
      3,
      2.895166,
      NULL,
      '21213',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '4211',
      NULL,
      NULL,
      3.489209,
      14,
      206,
      40,
      0.148589,
      37.003160,
      NULL,
      6.450580,
      0,
      0.959210,
      1,
      1.725581,
      0.124066,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      NULL,
      NULL,
      1.138069,
      NULL,
      NULL,
      1.562087,
      3,
      2.707110,
      NULL,
      1,
      1,
      0.524846,
      1,
      1.635637,
      NULL,
      2.638061,
      1.647312,
      1.980048,
      2.716156,
      0.716094,
      3.382273,
      NULL,
      NULL,
      0,
      10.168854,
      NULL,
      0,
      1.431566,
      NULL,
      NULL,
      NULL,
      1.244395,
      1.374988,
      0.352809,
      0,
      2,
      NULL,
      1.555871,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.702531,
      1.946182,
      0,
      0.653101,
      0.952536,
      3.405003,
      0.469920,
      NULL,
      2.975400,
      1,
      0,
      1,
      1.282542,
      0.911901,
      1,
      1.410095,
      NULL,
      NULL,
      0.198309,
      NULL,
      NULL,
      2.018369,
      1.826404,
      1,
      1.359445,
      1.788892,
      0.016341,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.227601,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.818511,
      0,
      0,
      NULL,
      NULL,
      5,
      6.100150,
      0,
      2.167210,
      NULL,
      1,
      0,
      0,
      0.916064,
      3.193663,
      NULL,
      1.993075,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.110072,
      NULL,
      NULL,
      1.459049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.346083,
      NULL,
      NULL,
      1.928820,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.147772,
      NULL,
      0,
      NULL,
      1,
      0.178193,
      1.183854,
      NULL,
      NULL,
      1.452503,
      1.452480,
      0,
      1,
      1,
      0.390226,
      2.549524,
      1,
      1,
      5,
      0,
      1,
      0.003985,
      1.280792,
      2,
      3,
      0.935182,
      NULL,
      2,
      NULL,
      3,
      3.945015,
      2.548920,
      NULL,
      NULL,
      2,
      3,
      8,
      NULL,
      1.248249,
      1,
      NULL,
      3,
      1.362366,
      NULL,
      1.219067,
      1,
      0.722701,
      2.203738,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.668205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.584588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.772556,
      NULL,
      NULL,
      0.328970,
      NULL,
      NULL,
      2.942885,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.300079,
      2,
      NULL,
      1,
      NULL,
      8,
      2,
      NULL,
      NULL,
      0.291647,
      1,
      NULL,
      NULL,
      3.690541,
      2,
      NULL,
      NULL,
      0.251766,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      2.651271,
      NULL,
      NULL,
      NULL,
      0.370176,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.456271,
      1.937777,
      NULL,
      NULL,
      1.367116,
      0,
      1.663832,
      NULL,
      0.195030,
      0.979342,
      1,
      NULL,
      NULL,
      NULL,
      3.717328,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.472614,
      0.145786,
      0,
      NULL,
      2.137905,
      0.731730,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.059187,
      NULL,
      3,
      NULL,
      2.329021,
      2,
      3,
      7,
      3.466832,
      NULL,
      384,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      20.687192,
      6,
      NULL,
      NULL,
      54.533809,
      NULL,
      2,
      1,
      1.272178,
      NULL,
      0,
      38.483374,
      1.867538,
      0.105099,
      1,
      0.375703,
      NULL,
      1,
      1.362603,
      1,
      0,
      1.869580,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.172916,
      0,
      0,
      1.617059,
      1,
      0.902067,
      3.590761,
      0,
      1,
      0.902423,
      0.143364,
      0.132840,
      0,
      0.179914,
      3,
      NULL,
      NULL,
      2.077005,
      NULL,
      1.277164,
      0,
      1,
      1.644198,
      1.470977,
      1.111578,
      1,
      0,
      1.484703,
      1.318560,
      3,
      1,
      0.364028,
      1,
      0.922728,
      0,
      NULL,
      1.486711,
      0.026422,
      NULL,
      1,
      1,
      0,
      NULL,
      0.650025,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.050669,
      1,
      1.090203,
      0,
      0,
      2,
      1.414273,
      1.383949,
      NULL,
      NULL,
      115,
      113,
      3.818809,
      1.231040,
      2.735254,
      '22144',
      '',
      '',
      1.441093,
      '',
      '',
      '',
      NULL,
      '4400',
      NULL,
      '');
commit;
end;
/


