set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3400144',
      0.427135,
      1,
      2,
      1,
      '3200',
      NULL,
      1,
      NULL,
      NULL,
      ' 9-26-1980',
      59,
      NULL,
      5.945171,
      2,
      2.320339,
      '10-14-1988',
      17.417187,
      3.353684,
      112.601804,
      NULL,
      4,
      NULL,
      NULL,
      '10-10-1987',
      0,
      NULL,
      2,
      1.748431,
      1,
      0.015460,
      0,
      0,
      NULL,
      2,
      9,
      10,
      6.400791,
      NULL,
      3,
      NULL,
      31.772410,
      0.653884,
      2,
      7,
      1.539429,
      3.669763,
      NULL,
      0,
      NULL,
      NULL,
      0.043395,
      3,
      1,
      NULL,
      1,
      0,
      0.780218,
      0.371543,
      0,
      NULL,
      NULL,
      NULL,
      0.142703,
      0,
      NULL,
      4,
      0,
      0,
      0,
      1.253373,
      NULL,
      7.474807,
      0,
      NULL,
      0,
      NULL,
      0.458277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.246220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293005,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.557200,
      NULL,
      2.108764,
      7,
      1.006800,
      0,
      3.948296,
      NULL,
      NULL,
      1,
      NULL,
      1.087252,
      0,
      1.582489,
      0.070093,
      0,
      NULL,
      1,
      0.341276,
      5.953025,
      NULL,
      0.193878,
      1.903675,
      NULL,
      0.138194,
      0,
      0,
      0.281638,
      1,
      0,
      NULL,
      0,
      1,
      1.142885,
      0.386803,
      NULL,
      5.748720,
      NULL,
      7,
      3.976517,
      2,
      0.228946,
      0,
      NULL,
      2,
      ' 3- 0-1976',
      287.496024,
      NULL,
      439.162310,
      NULL,
      1,
      0.549594,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849997,
      1.811820,
      1.414769,
      0.573836,
      0.543235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.288463,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.090831,
      0.938739,
      0,
      1,
      1.697309,
      1.782817,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.434603,
      1.242481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.778645,
      1,
      1.368075,
      NULL,
      NULL,
      3.226793,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.475001,
      NULL,
      3.806894,
      NULL,
      1,
      1.846691,
      1,
      3,
      0,
      2,
      1.132449,
      3.656451,
      0,
      3.425781,
      2.852814,
      1.494429,
      0,
      1,
      0.647379,
      2,
      NULL,
      1.024310,
      0.263707,
      NULL,
      1.786171,
      1,
      0,
      NULL,
      1.601204,
      4,
      NULL,
      9.024285,
      3.287627,
      NULL,
      10,
      10.766408,
      0,
      0.182057,
      3,
      1.652901,
      2.651109,
      1,
      3,
      7.122460,
      3.770532,
      1,
      54.522252,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.656516,
      '31022',
      '',
      '',
      1.825013,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      2.129643,
      41.139423,
      NULL,
      27,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.873757,
      0,
      NULL,
      NULL,
      0.623299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.289359,
      0.712258,
      1,
      0,
      NULL,
      NULL,
      3.597092,
      2,
      2,
      1.047285,
      NULL,
      NULL,
      0.599032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392979,
      NULL,
      NULL,
      1.652996,
      NULL,
      NULL,
      3,
      5.777944,
      0,
      1.270712,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667291,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875052,
      NULL,
      NULL,
      1.008229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146306,
      NULL,
      NULL,
      0.550479,
      NULL,
      NULL,
      0.356880,
      NULL,
      NULL,
      0.746181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.576606,
      NULL,
      NULL,
      1.392576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.777906,
      2,
      3.190983,
      0,
      NULL,
      NULL,
      5.639707,
      2.341934,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.707369,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.593960,
      NULL,
      NULL,
      1.131287,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      3,
      NULL,
      1.878633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.224025,
      0,
      2,
      NULL,
      0.609288,
      1.691962,
      NULL,
      NULL,
      5,
      2.877837,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      3,
      0,
      2.057452,
      0,
      0,
      7.516367,
      3.167917,
      0,
      NULL,
      NULL,
      NULL,
      3.755912,
      1.596770,
      1.529184,
      0,
      1.070013,
      NULL,
      0.985971,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634664,
      NULL,
      NULL,
      NULL,
      0.184156,
      0,
      0,
      0.287465,
      0,
      1,
      NULL,
      NULL,
      1.526203,
      NULL,
      NULL,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.156646,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.287730,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.548529,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.461426,
      NULL,
      NULL,
      NULL,
      1.945791,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      2,
      NULL,
      11.516398,
      1.723593,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.559507,
      NULL,
      1,
      0,
      0.075608,
      NULL,
      NULL,
      NULL,
      0.924755,
      1,
      0,
      0.703338,
      1.065510,
      1.693205,
      NULL,
      0,
      0.591902,
      1,
      0,
      0.817625,
      1,
      1.084299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.820226,
      NULL,
      10,
      2.032878,
      4.229275,
      0.540796,
      NULL,
      NULL,
      1,
      1.978680,
      0,
      1.625222,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.303197,
      1.993793,
      NULL,
      1,
      1.064547,
      NULL,
      NULL,
      0.878227,
      NULL,
      0,
      2.597756,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.686310,
      NULL,
      0.848204,
      1,
      NULL,
      2.810913,
      3,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1,
      0.391385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.951486,
      0.242054,
      0,
      NULL,
      38.998417,
      37,
      1,
      2,
      3.452204,
      '10220',
      NULL,
      '',
      0.988163,
      '',
      '',
      '',
      1.520268,
      NULL,
      '',
      NULL);
commit;
end;
/


