set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119514';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '2023234',
      3.112448,
      0,
      2,
      1,
      '1330',
      2.829466,
      NULL,
      NULL,
      NULL,
      ' 4-11-1991',
      NULL,
      NULL,
      0,
      0.432707,
      0.093648,
      ' 6-25-1990',
      11,
      0.039595,
      63.127252,
      82.307902,
      0,
      ' 2-10-1990',
      '11- 1-1975',
      NULL,
      NULL,
      2,
      0,
      0.823394,
      1.629804,
      0.179871,
      1.069133,
      0,
      1,
      NULL,
      7.721925,
      8.421597,
      4.194806,
      5,
      8.977523,
      4.551680,
      4,
      0,
      NULL,
      8,
      1.931732,
      5.835943,
      0,
      0.178847,
      1,
      0,
      0,
      0,
      1,
      0.949598,
      1,
      1.966765,
      0,
      1,
      1,
      0,
      1.106827,
      0,
      3,
      1.875391,
      0,
      NULL,
      1.042264,
      0,
      1,
      1.609071,
      0,
      2,
      NULL,
      3,
      0.786796,
      1.072946,
      1,
      NULL,
      NULL,
      3.089477,
      1.330530,
      1.793146,
      1,
      NULL,
      0.715989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016606,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946317,
      NULL,
      4.745640,
      1.734586,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.554023,
      0.555022,
      1,
      0,
      0,
      1,
      0.476665,
      1.396259,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.956330,
      1,
      4,
      2.058752,
      5.847568,
      7.644718,
      3.856241,
      3.824231,
      6.542374,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.135014,
      2,
      9.865001,
      NULL,
      7.246708,
      1.290925,
      0,
      0,
      1.553453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.908071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741080,
      1.186653,
      4,
      5,
      0,
      1.114465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      22,
      1.522148,
      0,
      2.696809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.315417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274858,
      0.001134,
      9.433973,
      7.578208,
      NULL,
      2,
      3,
      3,
      1.706709,
      1.113300,
      2.316493,
      1.512425,
      2,
      NULL,
      NULL,
      4.865310,
      4.370763,
      ' 7-15-1982',
      NULL,
      ' 8- 0-1974',
      1,
      0.039855,
      1,
      NULL,
      2,
      3.355775,
      NULL,
      0.488790,
      NULL,
      0,
      2,
      3,
      NULL,
      3.305338,
      3.567351,
      40,
      0,
      13,
      1,
      1.424231,
      2,
      0,
      NULL,
      3,
      NULL,
      0,
      2,
      2.096121,
      2.323446,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.278716,
      1,
      3,
      1.827833,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0.794383,
      1.193817,
      1,
      0,
      0.821240,
      0.904085,
      5,
      NULL,
      4.637566,
      2.316897,
      2.973219,
      4.237673,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      31.330339,
      2,
      1,
      NULL,
      43.696287,
      70.201104,
      84.537638,
      5.448962,
      0.091237,
      NULL,
      '02220',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.211050,
      '',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.514915,
      1.813516,
      0.162809,
      2,
      NULL,
      0.525795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359236,
      NULL,
      NULL,
      0.861326,
      NULL,
      NULL,
      1.167511,
      9,
      1,
      954,
      2.461261,
      0,
      NULL,
      0.864137,
      0,
      0,
      0,
      NULL,
      NULL,
      0.033843,
      0.900139,
      NULL,
      0.309594,
      1.284567,
      0,
      0.241137,
      1,
      0,
      0.456102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.867457,
      NULL,
      2.489491,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.072883,
      NULL,
      0.901960,
      0.227964,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.153000,
      NULL,
      1.485086,
      NULL,
      1.979439,
      NULL,
      NULL,
      1.304724,
      2.484140,
      NULL,
      1.303795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.331463,
      2.658500,
      NULL,
      NULL,
      NULL,
      0.394630,
      NULL,
      NULL,
      NULL,
      1.575407,
      NULL,
      0.382747,
      NULL,
      1.204941,
      NULL,
      0.666772,
      NULL,
      1.458188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.813703,
      NULL,
      0.810046,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.812131,
      0.999594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.918005,
      0.302881,
      0.711119,
      8,
      NULL,
      0.838107,
      1,
      5.120719,
      NULL,
      3.827454,
      3,
      0,
      1,
      1,
      NULL,
      0.297744,
      NULL,
      NULL,
      0,
      3.601018,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      1.909260,
      2,
      NULL,
      0,
      2.469336,
      NULL,
      0,
      1,
      NULL,
      1.630544,
      0.444085,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521449,
      0.243104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358453,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.405581,
      5.839369,
      9.723877,
      0,
      NULL,
      2,
      16.306346,
      42,
      5,
      1.609623,
      3,
      NULL,
      NULL,
      '',
      1.832314,
      '',
      '',
      '',
      1.337817,
      '',
      NULL,
      '');
commit;
end;
/


