set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      2.021090,
      1.045495,
      0,
      2,
      '1410',
      3.153739,
      NULL,
      NULL,
      NULL,
      NULL,
      31.430106,
      NULL,
      3.965616,
      1,
      0.423202,
      NULL,
      44,
      2,
      50,
      44.340118,
      3,
      ' 1- 4-1989',
      ' 7- 4-1993',
      '11-26-1986',
      1,
      1,
      2,
      2.874321,
      1.135521,
      0.030394,
      NULL,
      0,
      NULL,
      6,
      NULL,
      7.298924,
      1,
      25,
      5.971042,
      7,
      NULL,
      0,
      3,
      5.379247,
      0,
      0.641081,
      0.551663,
      NULL,
      0.313636,
      0.870070,
      1.395232,
      1.758900,
      1.013718,
      0,
      0,
      4.098430,
      3.396457,
      7,
      NULL,
      0.952156,
      1,
      NULL,
      NULL,
      3.788482,
      0.870614,
      5,
      0,
      9,
      1,
      0.858942,
      NULL,
      7.804697,
      3,
      1.693161,
      1,
      3,
      1.936956,
      NULL,
      NULL,
      1,
      1.192342,
      NULL,
      6,
      0.216969,
      0,
      2,
      0.171963,
      0.758367,
      2,
      NULL,
      NULL,
      2.646457,
      1,
      1,
      2.526674,
      1.192167,
      NULL,
      1,
      0,
      1,
      0.057819,
      0,
      NULL,
      4.446354,
      NULL,
      2.842694,
      2.519207,
      0,
      0.723508,
      NULL,
      NULL,
      2,
      0,
      1.513181,
      0,
      1,
      2.960126,
      1,
      4.163903,
      0,
      NULL,
      1.232898,
      0,
      NULL,
      NULL,
      3.774436,
      NULL,
      NULL,
      0,
      1.260999,
      1.839443,
      1.441565,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539448,
      7.874438,
      3.619648,
      0.072176,
      5.422921,
      3,
      NULL,
      1.673724,
      NULL,
      1.685871,
      1.007816,
      1.670655,
      7,
      2.105267,
      NULL,
      7,
      NULL,
      0.002190,
      6,
      2.829383,
      NULL,
      6,
      6,
      0,
      NULL,
      1,
      ' 3- 5-1983',
      NULL,
      ' 7- 2-1995',
      30.163660,
      0.039509,
      2,
      0.933923,
      1.490039,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      5.965406,
      1,
      0,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502391,
      NULL,
      NULL,
      2,
      3,
      3.512862,
      0.829256,
      0,
      0.908932,
      NULL,
      5.823029,
      0,
      1,
      0,
      0.179843,
      1.035194,
      NULL,
      3.330533,
      0,
      6.309302,
      2.076481,
      7.139952,
      6,
      5,
      3,
      9,
      0,
      0,
      8.515194,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      ' 9-28-1987',
      NULL,
      0.171086,
      5,
      0.588847,
      3,
      1.448395,
      NULL,
      3.759421,
      0.680811,
      1.426815,
      NULL,
      0,
      50,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.649934,
      1.773771,
      3.773476,
      2.869789,
      0.732334,
      3.167499,
      1.120756,
      NULL,
      0,
      2,
      2.576977,
      2.952748,
      3,
      0.064304,
      0.383272,
      0,
      0,
      3,
      5.807847,
      0.264075,
      1,
      0,
      1.372366,
      1.383470,
      0.708560,
      NULL,
      1.869683,
      NULL,
      3,
      1,
      0.059293,
      NULL,
      6.160121,
      6,
      1.766926,
      1.949115,
      5.988323,
      2.308186,
      0,
      2,
      2.873981,
      1,
      NULL,
      2.431530,
      0,
      NULL,
      NULL,
      10,
      2.329712,
      0,
      0,
      2.340167,
      '44440',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1.517052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.027606,
      1,
      1,
      0.623950,
      NULL,
      NULL,
      1.739908,
      1.182050,
      0.710514,
      2,
      3,
      1,
      1.945633,
      NULL,
      NULL,
      1,
      NULL,
      1,
      77.730476,
      NULL,
      0.767288,
      1.700217,
      0.933391,
      1,
      0,
      1,
      1.141299,
      1.228050,
      NULL,
      0.301260,
      1,
      1,
      0,
      0.027337,
      1.113893,
      1,
      NULL,
      0.228534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.392001,
      NULL,
      0.393811,
      5,
      1,
      0,
      2.105379,
      4.868982,
      NULL,
      2,
      2.649725,
      NULL,
      0,
      0.370029,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.119331,
      NULL,
      3,
      0.286953,
      NULL,
      3,
      3.221580,
      NULL,
      1,
      0.018429,
      NULL,
      0,
      1.497538,
      NULL,
      0.588098,
      0.180927,
      NULL,
      1.129208,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.273742,
      NULL,
      NULL,
      0,
      0.104595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844950,
      NULL,
      1.748891,
      1,
      NULL,
      NULL,
      29.691067,
      36.225183,
      1,
      0.551576,
      0.703993,
      '41323',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.844007,
      '',
      '',
      '');
commit;
end;
/


