set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9321577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '03',
      3.110217,
      12,
      '4442243',
      1,
      0,
      0,
      0,
      '0341',
      4.042426,
      0.748331,
      NULL,
      NULL,
      ' 1-19-1997',
      6,
      57,
      NULL,
      NULL,
      3.199877,
      ' 7- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1981',
      ' 3-21-1979',
      ' 9-20-2003',
      0.650961,
      NULL,
      3.186904,
      2,
      0.357961,
      NULL,
      2.958660,
      0,
      0.036073,
      6,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902800,
      3,
      NULL,
      0,
      3,
      0,
      1.644470,
      0.883449,
      0.172265,
      1.265144,
      2,
      0.171362,
      1,
      0.065189,
      1,
      0,
      2.060545,
      3.670218,
      1.391142,
      0,
      NULL,
      3,
      1.859194,
      5.451805,
      3.044597,
      NULL,
      1,
      1,
      0.519745,
      NULL,
      0.519508,
      0.967671,
      0,
      NULL,
      0.527156,
      1,
      NULL,
      NULL,
      0.116322,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.540778,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895010,
      NULL,
      0.346529,
      0.245288,
      1,
      1.233115,
      0.309111,
      0.954880,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.908381,
      NULL,
      0.622627,
      1.676842,
      1,
      1,
      0.912539,
      NULL,
      1.475943,
      1,
      0,
      1.009263,
      1.124238,
      0,
      0.956196,
      1,
      1,
      1,
      9,
      3.798644,
      4.918052,
      2,
      NULL,
      5,
      NULL,
      2,
      0.056184,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767609,
      1,
      NULL,
      0.854560,
      1.122989,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.408017,
      5,
      NULL,
      2.230050,
      1,
      NULL,
      NULL,
      NULL,
      0.905847,
      1,
      1.677055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663009,
      1,
      0,
      0.807633,
      0.169463,
      1,
      2,
      12,
      2,
      1.069114,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.895901,
      0.305804,
      0.121764,
      1.945176,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5.067322,
      1,
      1,
      0,
      3,
      0.923404,
      0,
      1.685254,
      NULL,
      1.720482,
      NULL,
      NULL,
      NULL,
      1.685654,
      1,
      0.452018,
      0,
      11.694759,
      10,
      1.615435,
      0,
      6.223859,
      6.991295,
      0,
      2.686055,
      2.289980,
      1,
      3,
      2,
      59.820128,
      NULL,
      2,
      24,
      NULL,
      6.733743,
      NULL,
      0,
      0.636290,
      0.148775,
      '03313',
      '10343',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.785117,
      18.018528,
      10.419092,
      31,
      1.635158,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845748,
      3,
      0.795744,
      1.740197,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.177195,
      1,
      1.354380,
      NULL,
      0.393553,
      0.445285,
      2,
      2,
      0.444972,
      1.815043,
      1.907672,
      3.826613,
      NULL,
      NULL,
      NULL,
      NULL,
      3.412191,
      0,
      0.120300,
      3.875353,
      0.997206,
      1,
      0,
      1.450249,
      3,
      0,
      0,
      5.396877,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.464298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227163,
      3.002671,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.620981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.516453,
      NULL,
      2.213356,
      0.723958,
      3.355055,
      3.924923,
      0.586769,
      NULL,
      NULL,
      6.266056,
      2.871957,
      0.077324,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615391,
      NULL,
      NULL,
      0.915522,
      NULL,
      NULL,
      0.922934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.199300,
      0.368954,
      NULL,
      1,
      NULL,
      0,
      3.905145,
      2.817756,
      7.671339,
      1.005479,
      NULL,
      NULL,
      1.446846,
      2.223239,
      3,
      1.801968,
      NULL,
      3.905379,
      1.925133,
      NULL,
      NULL,
      5.194170,
      NULL,
      2.513934,
      1,
      NULL,
      NULL,
      0.140086,
      NULL,
      NULL,
      NULL,
      1,
      0.212084,
      1.738007,
      1.508527,
      1.562104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.562412,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      17,
      NULL,
      NULL,
      2.408420,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.882170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926825,
      1.957150,
      NULL,
      NULL,
      1.716354,
      NULL,
      NULL,
      NULL,
      1.862505,
      1,
      NULL,
      NULL,
      0,
      5.092325,
      NULL,
      NULL,
      1.362806,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      10,
      0.519424,
      1.202090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      1.912442,
      0.475778,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      3.461395,
      0,
      2.480052,
      NULL,
      NULL,
      NULL,
      1.008618,
      NULL,
      3.720503,
      NULL,
      NULL,
      NULL,
      76,
      NULL,
      3,
      NULL,
      35.452843,
      NULL,
      NULL,
      0.388285,
      NULL,
      1.674558,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.164868,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.820450,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811882,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.470239,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.182683,
      0.689076,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      3.984462,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.653991,
      1,
      0.656431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171598,
      0,
      NULL,
      0.924865,
      NULL,
      0.239852,
      NULL,
      NULL,
      NULL,
      1.496570,
      1,
      1,
      2,
      NULL,
      0.246978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.206192,
      NULL,
      NULL,
      2.999209,
      32.711672,
      NULL,
      0.851359,
      NULL,
      NULL,
      NULL,
      2.329435,
      NULL,
      NULL,
      1,
      3,
      0.055389,
      1.088592,
      0.205205,
      3.077428,
      2.233359,
      1.855273,
      2,
      0.776654,
      1,
      0.042510,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.436286,
      0,
      NULL,
      1,
      0.792542,
      0,
      1.388271,
      1.358876,
      0,
      NULL,
      0.378440,
      0,
      1.888690,
      1,
      0,
      0.641511,
      0.223585,
      0.679697,
      0.580765,
      2,
      3,
      NULL,
      1,
      0,
      3,
      0.271792,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.733671,
      NULL,
      0.067180,
      NULL,
      0.874160,
      NULL,
      7,
      1,
      0,
      NULL,
      NULL,
      18.752342,
      46,
      5,
      4.466246,
      2,
      '01201',
      '44144',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '02310',
      '',
      '');
commit;
end;
/


