set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      '00',
      12,
      33,
      '1040331',
      1.980131,
      0.981481,
      3,
      0,
      '2042',
      0.435507,
      1,
      NULL,
      NULL,
      ' 1-10-1986',
      77,
      46.736363,
      NULL,
      2,
      2.262220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 2-11-1998',
      NULL,
      '10-20-1977',
      2,
      NULL,
      1,
      0.009479,
      0,
      0.341554,
      2.443899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.641682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.206248,
      NULL,
      1,
      3.533907,
      1.999583,
      0,
      3.949161,
      0,
      4.165766,
      2,
      3,
      3.933215,
      2,
      0.246350,
      1.999821,
      NULL,
      7,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.780311,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.549332,
      0.479677,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      1.254466,
      NULL,
      NULL,
      NULL,
      0.855845,
      5,
      NULL,
      NULL,
      7,
      1.542696,
      1,
      2.149668,
      1,
      NULL,
      NULL,
      0.433490,
      NULL,
      NULL,
      0,
      6.054906,
      0,
      0,
      5,
      0,
      1,
      0,
      2.048941,
      1.926940,
      NULL,
      0.917526,
      0,
      0,
      0.989853,
      0.741367,
      0.209369,
      1,
      1,
      NULL,
      1,
      1.571381,
      NULL,
      NULL,
      4.304989,
      NULL,
      6.856019,
      NULL,
      0.828632,
      0,
      5.015527,
      1.998894,
      0,
      5.054869,
      7,
      NULL,
      NULL,
      5,
      8,
      NULL,
      4.106956,
      9.497990,
      0.230393,
      1,
      0.656771,
      3.251309,
      3.591915,
      2,
      NULL,
      NULL,
      ' 0-12-1988',
      95.277765,
      0.303284,
      0.058029,
      1,
      6.459024,
      0.424311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950665,
      NULL,
      0,
      1.708782,
      0.880354,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      134.442580,
      1,
      2.423245,
      1.802725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.611898,
      0.503549,
      0,
      2,
      0,
      0.793068,
      0.068459,
      0.072040,
      5.895181,
      3,
      NULL,
      5.762177,
      1,
      0.576771,
      NULL,
      NULL,
      1.443833,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.862384,
      29.149912,
      0.937851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211189,
      0.100598,
      0,
      3.392948,
      2.667908,
      0,
      0.949203,
      NULL,
      NULL,
      1,
      1,
      2.169607,
      3,
      0,
      1.876329,
      1.734454,
      0,
      0,
      3,
      1.004717,
      1.208121,
      0,
      1,
      1,
      0.369456,
      NULL,
      1.652766,
      1,
      0,
      NULL,
      0,
      NULL,
      11.257278,
      NULL,
      0.594860,
      10,
      7.163389,
      1.148329,
      0,
      5,
      NULL,
      1.896240,
      1.001834,
      61,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      30,
      1,
      2.754990,
      NULL,
      '02121',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.842553,
      '',
      '',
      '',
      NULL,
      37,
      35,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.278890,
      1.322288,
      NULL,
      NULL,
      NULL,
      2,
      3.512998,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.856802,
      2.320807,
      0.294236,
      NULL,
      NULL,
      1.755265,
      NULL,
      NULL,
      1.850899,
      NULL,
      NULL,
      1.681106,
      NULL,
      NULL,
      0.259549,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.268190,
      NULL,
      2.297953,
      1,
      1.432256,
      NULL,
      NULL,
      NULL,
      0.662549,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.708352,
      2,
      0.921371,
      0,
      0,
      NULL,
      NULL,
      1,
      1.611936,
      1.992264,
      0.894649,
      1,
      2,
      3,
      0.623538,
      1,
      1,
      NULL,
      1.136355,
      2.588721,
      1.205345,
      0,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      0.357089,
      NULL,
      NULL,
      8.261073,
      9,
      6.028363,
      0.282251,
      1.470573,
      NULL,
      NULL,
      NULL,
      1.781690,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.400914,
      0.350279,
      2,
      3.096914,
      1.286415,
      1,
      NULL,
      NULL,
      7,
      NULL,
      0.444720,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.387866,
      NULL,
      NULL,
      1.287548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.934605,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.634067,
      7.256319,
      1,
      1,
      NULL,
      NULL,
      1,
      3.403216,
      1,
      0.218322,
      2,
      0.508951,
      1,
      3.208052,
      1.473856,
      NULL,
      2.186062,
      2,
      NULL,
      0.967730,
      1,
      3,
      1,
      2.778175,
      NULL,
      3,
      3.776948,
      NULL,
      3.460840,
      NULL,
      4,
      NULL,
      5,
      2,
      1,
      3.279647,
      NULL,
      0.287409,
      1.471238,
      NULL,
      NULL,
      0.892081,
      NULL,
      NULL,
      1.667446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279887,
      NULL,
      NULL,
      1.699349,
      NULL,
      NULL,
      0.908814,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.147536,
      NULL,
      NULL,
      2.212280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.083918,
      0,
      NULL,
      NULL,
      3.998164,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470147,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.224701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.273880,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.074233,
      NULL,
      NULL,
      NULL,
      0.155616,
      NULL,
      NULL,
      NULL,
      0.230316,
      NULL,
      NULL,
      NULL,
      2.190871,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.426727,
      3.572519,
      8,
      0.203620,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.729795,
      NULL,
      NULL,
      0.551389,
      NULL,
      0.327985,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.540091,
      0.761575,
      1.271827,
      1,
      1,
      1,
      1.110869,
      NULL,
      0.540727,
      1,
      NULL,
      0,
      0.293955,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.690968,
      0,
      6,
      3.840404,
      6.872796,
      7,
      0.348473,
      0,
      1,
      1.268140,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.694530,
      3,
      NULL,
      3,
      1.339358,
      NULL,
      3,
      0.141834,
      NULL,
      NULL,
      NULL,
      NULL,
      2.281598,
      NULL,
      NULL,
      NULL,
      0.520533,
      NULL,
      1.182547,
      2,
      NULL,
      NULL,
      3.522728,
      NULL,
      1,
      0.846780,
      NULL,
      NULL,
      0.089539,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869021,
      NULL,
      0,
      NULL,
      1.061262,
      NULL,
      0,
      1.640040,
      3.939104,
      0.803397,
      NULL,
      NULL,
      10.180325,
      43,
      5,
      1.671012,
      2.266384,
      '41041',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.374376,
      '',
      '',
      '');
commit;
end;
/


