set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6458228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2014302',
      3,
      0.931427,
      NULL,
      0,
      '2341',
      3,
      2,
      4,
      8,
      ' 9-21-1997',
      NULL,
      NULL,
      1,
      1,
      1.929685,
      ' 4-28-1992',
      47.879043,
      5,
      19.032266,
      NULL,
      0.634010,
      NULL,
      NULL,
      NULL,
      1,
      0.700971,
      1,
      0.087438,
      0.298850,
      0,
      3.986585,
      0,
      0,
      473.676280,
      0.152342,
      7.025822,
      2,
      NULL,
      18,
      0.709690,
      3.483489,
      3,
      2,
      3,
      0,
      0,
      1,
      1,
      1,
      0,
      0.689376,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      5.236753,
      1,
      5,
      0,
      0,
      0,
      0.570285,
      0,
      4,
      0,
      1,
      NULL,
      1,
      0,
      1.656882,
      1,
      0.261613,
      NULL,
      NULL,
      1.580093,
      NULL,
      NULL,
      0.674060,
      NULL,
      NULL,
      0.306432,
      2,
      0,
      3,
      1,
      0.873072,
      0,
      0,
      0,
      NULL,
      0.742159,
      1,
      1,
      1,
      2.578634,
      2,
      1,
      NULL,
      0,
      1.231209,
      1,
      NULL,
      7.844360,
      1.714252,
      4,
      1,
      1.566037,
      NULL,
      NULL,
      1.670740,
      NULL,
      NULL,
      0.949306,
      0,
      3,
      NULL,
      5.419507,
      0.022952,
      1.742881,
      1,
      0.167811,
      1,
      1,
      1,
      0.700188,
      1.989988,
      1,
      1,
      1.051534,
      1.457863,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.466624,
      5.981245,
      3,
      5,
      1,
      2.551873,
      2.771761,
      NULL,
      0.414789,
      1,
      1.493396,
      5,
      9,
      4,
      4.168229,
      9,
      0.661518,
      5,
      9,
      3,
      8.906395,
      1,
      1,
      ' 9- 0-2001',
      1313,
      ' 0- 1-1990',
      NULL,
      0.302070,
      1.714359,
      1,
      1.417837,
      0.960746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146933,
      1,
      0,
      1.041749,
      1,
      0,
      NULL,
      1.383282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.106709,
      1,
      3.908741,
      1.710792,
      1,
      0,
      NULL,
      7.210024,
      8,
      4,
      NULL,
      0.167347,
      NULL,
      NULL,
      NULL,
      1.459860,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.776957,
      0.407766,
      0.209058,
      3,
      1,
      1.625577,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.948585,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      3.833368,
      1,
      2,
      NULL,
      0.819142,
      1,
      NULL,
      0.396852,
      1,
      NULL,
      1.691477,
      0.347345,
      1,
      NULL,
      1,
      0,
      NULL,
      1.349329,
      0,
      0,
      2,
      0.266482,
      6.965109,
      6.941105,
      1,
      1.632530,
      1.841553,
      5,
      NULL,
      3.405930,
      7,
      1.817102,
      3,
      0,
      27,
      NULL,
      NULL,
      4.735420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.719696,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.732110,
      '',
      '',
      NULL,
      2,
      4,
      635,
      NULL,
      2.387780,
      47.251135,
      17.977748,
      61,
      3.119305,
      0.325379,
      NULL,
      2.460945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.289363,
      1.997958,
      NULL,
      3,
      NULL,
      2,
      6.191568,
      NULL,
      NULL,
      1.148559,
      NULL,
      1.000761,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      2.341844,
      5.627635,
      2.379770,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.136610,
      NULL,
      18,
      NULL,
      0,
      2.840619,
      3,
      NULL,
      0.921104,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.234250,
      2,
      2.282737,
      1,
      0.613640,
      0,
      NULL,
      0,
      0.199005,
      1.892617,
      1.865070,
      1,
      0.745399,
      0.871122,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.990607,
      NULL,
      NULL,
      7,
      NULL,
      1.744451,
      0.043988,
      0,
      NULL,
      NULL,
      NULL,
      1.434122,
      5,
      0.707621,
      13,
      0,
      NULL,
      NULL,
      9.819875,
      NULL,
      NULL,
      NULL,
      NULL,
      13.369118,
      0,
      NULL,
      NULL,
      2.369420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.098279,
      NULL,
      NULL,
      1.903810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      0.233712,
      NULL,
      NULL,
      2.904532,
      7,
      2.764845,
      3.053034,
      6,
      7,
      2,
      NULL,
      NULL,
      NULL,
      16,
      1,
      1,
      1.953046,
      2.705026,
      3.483554,
      16.738184,
      NULL,
      5.014618,
      2.508126,
      4,
      3.734934,
      NULL,
      1.753897,
      NULL,
      1.526113,
      3.714753,
      NULL,
      NULL,
      NULL,
      3,
      1.460896,
      2.223077,
      6,
      4.444042,
      5.772932,
      NULL,
      3,
      0,
      3,
      3.188520,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      0.396534,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.319297,
      NULL,
      NULL,
      0.210554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      14.470475,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.647003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.825816,
      NULL,
      NULL,
      3,
      2.257148,
      0.601606,
      0,
      0,
      NULL,
      2,
      NULL,
      5.971755,
      2,
      5.610429,
      NULL,
      7.605997,
      NULL,
      4,
      NULL,
      2.165652,
      NULL,
      0.597644,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.389766,
      NULL,
      NULL,
      NULL,
      0,
      1.798012,
      NULL,
      NULL,
      17,
      8.465997,
      NULL,
      NULL,
      13,
      1.090689,
      3.423369,
      NULL,
      3,
      1,
      19.902718,
      NULL,
      0,
      NULL,
      17.604490,
      NULL,
      NULL,
      1.883906,
      2,
      NULL,
      NULL,
      0,
      0.376892,
      NULL,
      2,
      1.425542,
      1.502831,
      NULL,
      2,
      0.479045,
      1,
      NULL,
      NULL,
      NULL,
      0.245931,
      NULL,
      2.741394,
      NULL,
      NULL,
      NULL,
      2.966945,
      2,
      3,
      NULL,
      15.968741,
      NULL,
      9,
      NULL,
      165.742212,
      1.158227,
      0,
      6,
      1,
      1,
      266.775194,
      95,
      2,
      451.353617,
      30.786269,
      NULL,
      NULL,
      NULL,
      1.197715,
      NULL,
      NULL,
      NULL,
      74.403300,
      9.766351,
      0,
      NULL,
      NULL,
      3.066160,
      1509.495987,
      NULL,
      14142.995957,
      1005.307297,
      1,
      NULL,
      0,
      2.938991,
      0.718643,
      1.916910,
      NULL,
      1.985626,
      NULL,
      1,
      1,
      1.005249,
      1.902654,
      0,
      0,
      1.235658,
      0.029006,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.953713,
      NULL,
      0.058007,
      NULL,
      1.631190,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.359991,
      0,
      NULL,
      0.595409,
      3,
      NULL,
      0,
      7.378583,
      0.008254,
      0,
      0.290107,
      1.566348,
      0,
      1,
      0.763852,
      1.147304,
      2.706776,
      1,
      NULL,
      1.557043,
      1,
      1,
      NULL,
      1.510776,
      3,
      3,
      1.810501,
      0,
      2,
      0,
      3.249646,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.713255,
      1,
      2,
      0.946491,
      1.405847,
      1,
      0,
      0,
      1.666853,
      1.230535,
      0.425924,
      0,
      NULL,
      1,
      NULL,
      0.564956,
      NULL,
      NULL,
      NULL,
      0.928835,
      NULL,
      1.925564,
      NULL,
      0.595574,
      NULL,
      0.099768,
      NULL,
      1.106541,
      NULL,
      3,
      NULL,
      0.000524,
      NULL,
      0,
      NULL,
      NULL,
      42,
      1.544363,
      NULL,
      NULL,
      0.868418,
      NULL,
      NULL,
      1.574240,
      NULL,
      1.622739,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.282121,
      NULL,
      0.428254,
      NULL,
      0.402216,
      NULL,
      1.714830,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.200040,
      NULL,
      NULL,
      9.086480,
      NULL,
      NULL,
      1.991125,
      1,
      0,
      0,
      1,
      0.380373,
      5.972433,
      2.355505,
      0.717197,
      NULL,
      1,
      2,
      55,
      49.244871,
      NULL,
      1,
      1.422588,
      '22032',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '43024',
      '42310',
      '');
commit;
end;
/


