set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621804';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '12',
      37.806356,
      NULL,
      '3041434',
      3.155871,
      1.693703,
      4,
      1,
      '2124',
      2.875621,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      53,
      NULL,
      0,
      1.687606,
      '10- 6-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1992',
      ' 9-15-1979',
      NULL,
      2,
      1,
      3,
      1,
      0.829738,
      1.327752,
      2.497342,
      1,
      0,
      1.013089,
      NULL,
      4,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      4.457950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.142873,
      1.727246,
      NULL,
      0.112302,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      10.675961,
      2,
      7,
      3.199993,
      2,
      1,
      3.740582,
      1.865547,
      0.640694,
      5.432516,
      1.211653,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.498870,
      3.142784,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.727404,
      NULL,
      5.759409,
      0.386263,
      NULL,
      1.934085,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      0.025959,
      1,
      1,
      3.790011,
      0,
      1,
      1.047872,
      1.418184,
      1.658438,
      1.511999,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.368118,
      NULL,
      0,
      0,
      1,
      1,
      1.383687,
      NULL,
      0,
      5,
      0.703234,
      0,
      1,
      1,
      1.308972,
      5,
      0.860428,
      5,
      NULL,
      1.860320,
      9,
      NULL,
      6.567740,
      NULL,
      NULL,
      6.824799,
      NULL,
      0.435108,
      1.485321,
      NULL,
      ' 9- 6-1977',
      119,
      '10-28-1984',
      26.768033,
      3.695552,
      5,
      1,
      2.451994,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172448,
      0,
      NULL,
      0.227716,
      NULL,
      1.892697,
      0.921379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.637386,
      3,
      0.488700,
      1.117116,
      0,
      6.292637,
      0,
      NULL,
      NULL,
      1.751260,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.140528,
      NULL,
      1,
      1,
      0.903206,
      6,
      NULL,
      0.912858,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610679,
      0.724174,
      0.695157,
      2.414152,
      NULL,
      3.825565,
      1,
      2,
      1.814172,
      3,
      3,
      3.363282,
      2.790976,
      1,
      NULL,
      0.217816,
      0.855579,
      0,
      0,
      NULL,
      0.368016,
      0,
      1,
      1.936288,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      3,
      9,
      5.693358,
      8.192478,
      NULL,
      6,
      4.409208,
      0.789210,
      1,
      NULL,
      1,
      2.325710,
      62,
      1.337544,
      1,
      77,
      NULL,
      24.785915,
      31,
      7,
      0,
      0.789496,
      '41410',
      '44022',
      '',
      3,
      '3312',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.901696,
      20.032264,
      20,
      0.986681,
      2,
      NULL,
      3.689494,
      0,
      2.123046,
      1,
      2,
      NULL,
      1.568437,
      NULL,
      NULL,
      0.989600,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      1.999133,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.651024,
      1.868114,
      3,
      NULL,
      0.363002,
      1.850168,
      NULL,
      NULL,
      NULL,
      1.251608,
      1.111321,
      NULL,
      1,
      NULL,
      NULL,
      0.045417,
      1,
      2.419227,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124625,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.204009,
      3,
      1.408855,
      0,
      0.695221,
      1,
      NULL,
      0,
      1.384296,
      0.833236,
      0.610337,
      NULL,
      2.134776,
      1,
      0,
      1,
      3.023462,
      1,
      0.717189,
      NULL,
      2,
      0.571044,
      0.035195,
      NULL,
      NULL,
      1.803287,
      NULL,
      0.321475,
      NULL,
      5,
      2,
      0.064969,
      0.316065,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      0.077673,
      1.337600,
      NULL,
      NULL,
      4,
      3.865009,
      2,
      0,
      NULL,
      NULL,
      0.780387,
      NULL,
      NULL,
      0.474367,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.465095,
      NULL,
      NULL,
      0.616698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345654,
      NULL,
      NULL,
      0.406441,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.986086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.300594,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      0.953252,
      1,
      NULL,
      NULL,
      0.616463,
      5,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.203707,
      NULL,
      2.621252,
      NULL,
      3.584739,
      1.845909,
      0.578447,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.674923,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.519551,
      0,
      2.982096,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      60.504325,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.132160,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.605436,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.134273,
      1.008034,
      0,
      7.639797,
      1,
      1.337609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191676,
      NULL,
      NULL,
      0.434074,
      NULL,
      NULL,
      1.292243,
      NULL,
      NULL,
      1.823870,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.104640,
      NULL,
      1,
      0.916168,
      0.557885,
      0,
      0,
      1,
      0,
      0.264441,
      0,
      1,
      1,
      1,
      1.724864,
      1,
      0.478918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.935365,
      0,
      1.871122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472779,
      1.021134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600994,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.233163,
      1,
      NULL,
      NULL,
      NULL,
      154,
      NULL,
      1,
      NULL,
      2,
      1.428978,
      0,
      NULL,
      NULL,
      NULL,
      65.431934,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2.142877,
      35.791715,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.748830,
      3.784863,
      NULL,
      NULL,
      0.112175,
      2,
      0,
      3.782743,
      1,
      3.930005,
      3.337079,
      0,
      1,
      1,
      NULL,
      0.534669,
      NULL,
      NULL,
      0.869972,
      0,
      NULL,
      0,
      1.671736,
      NULL,
      0,
      1.748478,
      NULL,
      0.048320,
      0,
      NULL,
      1.010276,
      0.038950,
      NULL,
      0.178274,
      0.908399,
      NULL,
      1,
      1,
      NULL,
      1,
      2.510997,
      NULL,
      NULL,
      2,
      NULL,
      3.508191,
      0,
      1.832497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631652,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      9.651354,
      2,
      0.399780,
      NULL,
      NULL,
      69,
      NULL,
      5.293192,
      1.073570,
      NULL,
      '20144',
      '41324',
      NULL,
      NULL,
      '3323',
      NULL,
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


