set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018757';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '1303',
      NULL,
      1.031998,
      NULL,
      NULL,
      NULL,
      12.507463,
      NULL,
      4.131231,
      0.460402,
      0,
      ' 4- 6-2002',
      19,
      2,
      347,
      121,
      NULL,
      '11- 9-1994',
      ' 0- 1-1986',
      NULL,
      1,
      0,
      NULL,
      1.431660,
      1.886362,
      0,
      NULL,
      0.513809,
      NULL,
      6.432223,
      3,
      0,
      9,
      12.978163,
      16,
      0.641161,
      17.691123,
      5,
      2.471644,
      3.099640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.422387,
      0,
      3.518966,
      1.011771,
      3.626220,
      1,
      1.137256,
      NULL,
      0.351971,
      0.990410,
      4,
      1.092871,
      7.024268,
      1,
      5.011618,
      4,
      NULL,
      0,
      NULL,
      0.967252,
      NULL,
      0.639522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      6,
      1,
      3,
      NULL,
      1,
      0,
      1.853950,
      2.846531,
      1.340299,
      3.775491,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638919,
      0,
      1.789859,
      0,
      0.768270,
      5.337645,
      7,
      NULL,
      5.356461,
      1.616506,
      1.682028,
      NULL,
      NULL,
      1.193536,
      NULL,
      NULL,
      1,
      1.479186,
      4.424110,
      NULL,
      9.841657,
      0.565980,
      5.964211,
      0,
      0.686035,
      2.753243,
      0,
      1.790471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.236012,
      2.833239,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.069364,
      3,
      NULL,
      1,
      0.284049,
      3.477847,
      3.583157,
      1.697318,
      NULL,
      4,
      9,
      4.475391,
      1,
      4,
      3,
      0,
      3.907671,
      0,
      NULL,
      0,
      ' 8-13-1994',
      NULL,
      NULL,
      3,
      NULL,
      1.381045,
      1.946350,
      3,
      NULL,
      NULL,
      NULL,
      3.373272,
      NULL,
      0,
      NULL,
      NULL,
      4.142179,
      4,
      2,
      NULL,
      0,
      3.110026,
      3.780500,
      0.952115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.986116,
      1.693144,
      2,
      0,
      3.898046,
      3,
      1.952051,
      1.910769,
      0.193944,
      1.671277,
      1.544540,
      7.870556,
      0,
      NULL,
      NULL,
      NULL,
      1.073565,
      1.488406,
      1.757647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.227023,
      0.337647,
      0.578165,
      1,
      0.363772,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.570498,
      1.494087,
      1.752016,
      NULL,
      4.605029,
      4,
      1.596066,
      NULL,
      1,
      NULL,
      4.980601,
      NULL,
      NULL,
      3,
      0,
      5.933609,
      1.655914,
      0,
      1,
      3,
      0,
      NULL,
      1,
      1,
      0.280607,
      1.430002,
      1.992111,
      0.885168,
      0,
      0,
      0.739218,
      2.248212,
      5,
      0,
      1,
      1,
      3,
      4,
      3,
      5.887119,
      0.387759,
      1.975719,
      1.341996,
      64,
      NULL,
      2,
      NULL,
      45,
      33,
      14,
      0,
      1,
      5.368958,
      '44220',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.191480,
      '',
      '',
      '',
      3,
      19.533001,
      105.068211,
      4,
      2.913880,
      11,
      2.960161,
      6.265848,
      3.395411,
      2.486208,
      1.550600,
      0.961558,
      1.466428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.938155,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      0.910537,
      NULL,
      NULL,
      3.144097,
      1,
      NULL,
      0.955839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0.664674,
      0.594297,
      1.172342,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.587770,
      1,
      1.259734,
      1,
      NULL,
      NULL,
      0.795748,
      NULL,
      NULL,
      2.052507,
      0.970781,
      1,
      3.575050,
      1,
      1.784045,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2.227217,
      3.458931,
      1.919821,
      NULL,
      0,
      0.882210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.429947,
      NULL,
      1.751905,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      2,
      NULL,
      1.179432,
      1.673304,
      NULL,
      NULL,
      NULL,
      5,
      1.543684,
      0.186232,
      1.337865,
      0.994389,
      3.363809,
      1.985106,
      0,
      2,
      1.430236,
      0.890835,
      0,
      NULL,
      NULL,
      1.441236,
      NULL,
      NULL,
      1.437645,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.995216,
      NULL,
      NULL,
      1.926422,
      NULL,
      NULL,
      NULL,
      1.476976,
      0,
      7,
      NULL,
      NULL,
      2,
      3,
      0,
      3.069698,
      0,
      0.330667,
      1,
      NULL,
      NULL,
      1.207585,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.543504,
      NULL,
      NULL,
      2,
      0.147225,
      1,
      NULL,
      NULL,
      2.112309,
      NULL,
      4.667833,
      1,
      6,
      0.366191,
      NULL,
      0,
      NULL,
      3.310979,
      1,
      1,
      NULL,
      1.242647,
      NULL,
      1,
      NULL,
      6.309659,
      NULL,
      NULL,
      76,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.231597,
      1,
      NULL,
      0.585585,
      0.155518,
      NULL,
      3,
      2,
      NULL,
      3,
      0.154871,
      NULL,
      1,
      1.167216,
      NULL,
      1.961099,
      0,
      NULL,
      NULL,
      1.802042,
      NULL,
      5.502609,
      NULL,
      NULL,
      2,
      1.824791,
      0,
      1,
      0,
      NULL,
      2.543606,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827447,
      0,
      NULL,
      NULL,
      0.232826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.321541,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783895,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.119925,
      1,
      NULL,
      NULL,
      1,
      1.088300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.382394,
      1,
      NULL,
      NULL,
      1.824171,
      0,
      3.037442,
      3.331080,
      3.856595,
      35.825932,
      33.750052,
      3.951926,
      0.339596,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      77.838233,
      NULL,
      0.455222,
      NULL,
      NULL,
      1,
      NULL,
      0.535111,
      290,
      1.889445,
      0.691964,
      NULL,
      1,
      1.379758,
      1.352675,
      0.596727,
      1.703702,
      0,
      1,
      1.019731,
      0,
      1,
      0.723564,
      1.444048,
      1,
      1.411164,
      1.378908,
      2,
      NULL,
      1.960366,
      NULL,
      NULL,
      NULL,
      0.963620,
      NULL,
      NULL,
      NULL,
      0.787254,
      NULL,
      NULL,
      NULL,
      0.205080,
      34,
      5.101452,
      1.202924,
      1.403223,
      NULL,
      NULL,
      1,
      NULL,
      1.657604,
      NULL,
      NULL,
      NULL,
      1.248583,
      NULL,
      0.086785,
      NULL,
      1.353934,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.858188,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.962342,
      0,
      1.606947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981500,
      1.567751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.564023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      1.375730,
      NULL,
      NULL,
      1.360889,
      1.301981,
      1,
      NULL,
      0.505214,
      1,
      0,
      1.372113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063271,
      NULL,
      1.690137,
      5.990668,
      0.193489,
      1,
      1,
      0,
      0.059000,
      NULL,
      1,
      NULL,
      1.005341,
      0.702757,
      1.295720,
      0,
      1.608037,
      NULL,
      0,
      2,
      1,
      0,
      0.998785,
      1,
      NULL,
      3.398354,
      1.480918,
      1,
      0,
      NULL,
      2.307385,
      3,
      1.042154,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0.700610,
      1,
      0,
      1,
      0,
      0.857081,
      0.330059,
      NULL,
      1.535099,
      1.227366,
      2.625698,
      NULL,
      0.387521,
      NULL,
      1,
      NULL,
      1.021823,
      NULL,
      0,
      NULL,
      0.199750,
      NULL,
      0.901107,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.166533,
      NULL,
      1,
      30,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.880892,
      0.619517,
      0.738515,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91.215882,
      3.637226,
      NULL,
      0.036434,
      '30103',
      '42233',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


