set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.803087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.207602,
      '222',
      '13104313',
      35,
      32,
      NULL,
      3.728543,
      1,
      6,
      3,
      '0140',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-2001',
      157.183924,
      52.674996,
      NULL,
      0,
      2.360933,
      '11-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      1.239310,
      '10- 0-2001',
      ' 8-22-1986',
      NULL,
      3,
      3,
      3,
      0.625208,
      3.118322,
      0.119048,
      3.346245,
      0.759380,
      0.632316,
      21.175613,
      4.068145,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.735548,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.906397,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      3.112157,
      11,
      0,
      1.400086,
      3.404503,
      1.938288,
      7,
      4.077602,
      0,
      6.809035,
      0.060326,
      1.777087,
      1.679713,
      9.081180,
      NULL,
      NULL,
      3.847729,
      3.292337,
      1,
      NULL,
      NULL,
      0.241647,
      NULL,
      NULL,
      3,
      0.633673,
      8.235080,
      2.615497,
      0,
      0.918636,
      NULL,
      0,
      0.590555,
      0,
      NULL,
      1,
      2,
      0.703805,
      1,
      2,
      3.125422,
      NULL,
      3,
      NULL,
      NULL,
      5,
      4,
      NULL,
      3,
      0.129841,
      NULL,
      NULL,
      NULL,
      0.236696,
      NULL,
      NULL,
      1.342654,
      4,
      5.597057,
      0.639083,
      0.560818,
      0,
      0,
      1,
      NULL,
      NULL,
      4.632642,
      NULL,
      1.201173,
      6.559718,
      NULL,
      1,
      0,
      3.871386,
      3.042704,
      0.623594,
      9.562718,
      NULL,
      1.723453,
      1.613237,
      0,
      1.976605,
      3,
      0.878728,
      NULL,
      6.208383,
      5,
      NULL,
      NULL,
      NULL,
      1.451420,
      8,
      NULL,
      1,
      5,
      NULL,
      5.330067,
      1,
      3,
      1,
      NULL,
      NULL,
      2.745629,
      1,
      NULL,
      NULL,
      ' 4- 6-1991',
      306.519327,
      2.016598,
      0.791496,
      0.274965,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811179,
      0.063078,
      NULL,
      1,
      4.119419,
      0,
      0.973714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      25.619583,
      NULL,
      NULL,
      2.878408,
      1,
      1.763657,
      2.433366,
      1.224004,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.677123,
      5.806878,
      0.593042,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.879526,
      0.862177,
      0,
      1.018492,
      2,
      102.393888,
      3,
      1.797206,
      22,
      145.886886,
      0.266414,
      1.681119,
      1,
      2.691418,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2.770700,
      1,
      0,
      3.734021,
      3.161043,
      NULL,
      NULL,
      0,
      0,
      0,
      1.460212,
      NULL,
      1.753456,
      1.224264,
      NULL,
      1.288164,
      1.580209,
      0.163535,
      0.376151,
      1,
      NULL,
      0.158381,
      7.035683,
      6.108972,
      6.390465,
      10,
      1,
      0,
      NULL,
      0,
      NULL,
      3,
      3,
      0.264379,
      9,
      3.496376,
      3,
      NULL,
      NULL,
      NULL,
      22,
      3.914428,
      5.036992,
      2.034026,
      '40331',
      '',
      NULL,
      0.645566,
      '',
      '',
      NULL,
      NULL,
      '4444',
      '',
      '',
      2.447878,
      NULL,
      225.764693,
      NULL,
      NULL,
      4.189217,
      NULL,
      NULL,
      2.358892,
      1.264863,
      1,
      1.868568,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631237,
      0.935774,
      NULL,
      NULL,
      3.884686,
      0.331547,
      NULL,
      2,
      0,
      2.366743,
      0.636041,
      1,
      1.319116,
      3.928049,
      1,
      NULL,
      3,
      NULL,
      3.163241,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3,
      NULL,
      0.814771,
      0.336052,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.344980,
      NULL,
      NULL,
      NULL,
      3.057602,
      1,
      3,
      0,
      1.195868,
      1,
      2.974746,
      1,
      1,
      3,
      NULL,
      0.367555,
      0,
      1,
      1,
      1,
      0.430352,
      NULL,
      0,
      NULL,
      1,
      1,
      0.153601,
      NULL,
      NULL,
      1,
      1.133941,
      0,
      NULL,
      0.429565,
      9.686793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896070,
      NULL,
      NULL,
      3,
      3.917010,
      NULL,
      3,
      0,
      3.810819,
      1.350003,
      NULL,
      NULL,
      6,
      5,
      7.584184,
      2.056590,
      1.002848,
      0,
      3.826152,
      1,
      0.016835,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.740011,
      NULL,
      1,
      1,
      1.806469,
      2.018384,
      1,
      2,
      0,
      1.506020,
      1.201754,
      0,
      5,
      4,
      6,
      6.783431,
      0.044368,
      5.430433,
      0,
      NULL,
      NULL,
      0,
      1.931748,
      2.862955,
      3.440084,
      NULL,
      2,
      1,
      0.727343,
      NULL,
      7.033322,
      3.232986,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.859071,
      2.017598,
      2.433039,
      2,
      3.651475,
      0.364441,
      NULL,
      3.324328,
      7.282444,
      6,
      2.126606,
      NULL,
      2.752299,
      2.202192,
      9.058535,
      1.893030,
      1,
      0.673911,
      1.504735,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745701,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.856018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.027105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.779058,
      NULL,
      NULL,
      0.279471,
      NULL,
      0,
      1,
      0,
      0.904088,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.027528,
      NULL,
      NULL,
      NULL,
      0.933473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363210,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.943155,
      NULL,
      NULL,
      NULL,
      1.450126,
      NULL,
      NULL,
      NULL,
      1.760263,
      NULL,
      NULL,
      NULL,
      1.911113,
      NULL,
      NULL,
      NULL,
      1.996314,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.214620,
      92.612841,
      10,
      1.344892,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15.599313,
      NULL,
      3.459003,
      NULL,
      14,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.312326,
      179.142727,
      0,
      0.496387,
      0,
      0,
      0,
      NULL,
      0.109459,
      0.053939,
      1.963136,
      NULL,
      NULL,
      1.594978,
      0,
      NULL,
      1.488543,
      1,
      1.856172,
      0.696966,
      1.763159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.162397,
      0.128913,
      6,
      5.400688,
      7,
      1,
      0,
      9,
      3,
      NULL,
      0.623352,
      2,
      3.860178,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1.597309,
      1,
      NULL,
      1,
      0.017341,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.827183,
      2,
      NULL,
      0.614568,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.487345,
      0.406377,
      0.613424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3,
      2.848585,
      1,
      3.380592,
      21,
      NULL,
      4,
      NULL,
      0,
      '13200',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.705814,
      NULL,
      NULL,
      '');
commit;
end;
/


