set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5800019';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2443243',
      3.111391,
      NULL,
      2,
      0,
      '3342',
      3,
      1,
      NULL,
      NULL,
      ' 3-24-1987',
      9,
      NULL,
      5.355291,
      0.342171,
      NULL,
      ' 7- 8-2001',
      9.991159,
      1.214686,
      133,
      NULL,
      NULL,
      ' 4- 0-1996',
      ' 8-19-1980',
      '11- 0-1985',
      NULL,
      0,
      1.308298,
      2,
      1.386714,
      NULL,
      2,
      1,
      1.853072,
      205,
      4.998950,
      NULL,
      6.166744,
      166.020828,
      144,
      NULL,
      23.445085,
      3.018137,
      3.624937,
      NULL,
      1.699440,
      0.115684,
      0,
      0.723692,
      0.698763,
      0.396387,
      1.886791,
      1,
      NULL,
      0.472814,
      NULL,
      2,
      2.871139,
      0,
      0,
      5.356147,
      1,
      0,
      3.829949,
      3,
      3,
      3,
      0.337867,
      3.780003,
      0.596900,
      1,
      NULL,
      11.296140,
      0,
      1,
      NULL,
      0,
      1.685939,
      NULL,
      NULL,
      1.897472,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      0.804350,
      0,
      0.623761,
      1,
      0.136317,
      0.726533,
      1.639312,
      NULL,
      1.469503,
      1.457308,
      1.378333,
      0.199913,
      1.370724,
      1.760230,
      NULL,
      NULL,
      1,
      1.403221,
      1,
      1,
      5.461668,
      1,
      0.357808,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      8.310668,
      7.412038,
      NULL,
      6,
      4,
      7.421763,
      NULL,
      NULL,
      1,
      0.600867,
      NULL,
      1,
      5,
      NULL,
      NULL,
      1.005180,
      0.618865,
      1,
      NULL,
      NULL,
      2,
      4.949626,
      2,
      3,
      2.356608,
      NULL,
      0.896644,
      1,
      0,
      7.289395,
      NULL,
      NULL,
      2.992755,
      6,
      8.468588,
      3.986191,
      NULL,
      9.195121,
      5.515004,
      1,
      10.116134,
      7.721137,
      6.691218,
      NULL,
      NULL,
      9.438661,
      NULL,
      ' 8- 6-1999',
      180,
      ' 7-24-1978',
      9.674094,
      NULL,
      1.481781,
      0.024759,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.757098,
      NULL,
      NULL,
      0,
      1,
      3.565446,
      0.252428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      1.463362,
      1.903097,
      0.381055,
      NULL,
      0,
      1,
      7.211545,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.873710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215586,
      NULL,
      1.169976,
      NULL,
      0.670346,
      0,
      1.163272,
      1,
      858.233186,
      1,
      3,
      189.430875,
      1695,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.007339,
      NULL,
      2.806162,
      8.186830,
      2,
      3,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      52,
      0.095812,
      1.408594,
      NULL,
      54.353906,
      19.308045,
      NULL,
      3.933341,
      0,
      1.511423,
      '34213',
      '',
      '',
      0.399258,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      19,
      1,
      NULL,
      1,
      93,
      NULL,
      NULL,
      3.177320,
      2.534391,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.316279,
      NULL,
      NULL,
      1.169277,
      NULL,
      NULL,
      2,
      2,
      1,
      0.297027,
      NULL,
      NULL,
      0.097106,
      NULL,
      NULL,
      1.438916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.195820,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.024836,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3,
      1,
      0.419603,
      0,
      1,
      NULL,
      0,
      0,
      1.569269,
      NULL,
      1,
      0,
      NULL,
      0,
      1.121392,
      0,
      1.073850,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.942143,
      2.749560,
      1.988107,
      0.882006,
      NULL,
      NULL,
      NULL,
      0.161879,
      NULL,
      NULL,
      NULL,
      1.048649,
      NULL,
      NULL,
      2.753896,
      0,
      NULL,
      NULL,
      3.654487,
      0,
      1,
      NULL,
      NULL,
      4.901122,
      8.968595,
      5,
      0,
      3.033532,
      0,
      1,
      NULL,
      NULL,
      1.835238,
      9,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.208234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      3.493938,
      0.377285,
      NULL,
      6.253317,
      NULL,
      2.124168,
      2.540235,
      4,
      0.069561,
      5.494042,
      NULL,
      3.930294,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      NULL,
      1.058344,
      2,
      NULL,
      8.996244,
      0,
      3,
      2.844717,
      2,
      1,
      0.505738,
      1.128724,
      NULL,
      3,
      2.278063,
      0,
      3,
      8,
      10.457102,
      4,
      NULL,
      NULL,
      1,
      1.274930,
      2.143147,
      0.813130,
      NULL,
      1,
      0,
      0,
      1.650147,
      2.406598,
      NULL,
      NULL,
      0.915949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.448595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.043463,
      NULL,
      NULL,
      1.037501,
      NULL,
      NULL,
      1.269716,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.872100,
      0,
      0,
      1,
      1.124459,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.686232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836273,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.565507,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.201696,
      2.347010,
      NULL,
      NULL,
      1.937582,
      NULL,
      NULL,
      NULL,
      2.482522,
      0.499558,
      NULL,
      NULL,
      3.814126,
      0.918779,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.960260,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306458,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      2.514915,
      NULL,
      NULL,
      1.284797,
      NULL,
      NULL,
      NULL,
      1.348395,
      151.042234,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208679,
      NULL,
      NULL,
      NULL,
      69.314568,
      12.204880,
      0.352174,
      NULL,
      NULL,
      0.068195,
      NULL,
      1.308937,
      2232,
      349,
      1.717797,
      1,
      1,
      1.372748,
      0.920910,
      1.860160,
      0.309478,
      0,
      0.347729,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.724131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.674566,
      11,
      2.751964,
      7.211442,
      0.818858,
      5,
      20,
      NULL,
      0,
      1.767911,
      17,
      9.948947,
      0,
      NULL,
      NULL,
      0.248645,
      0.584851,
      0,
      NULL,
      17.263611,
      12.470542,
      0.215879,
      10,
      0,
      0,
      7,
      5,
      1.188684,
      NULL,
      18.080440,
      1.260867,
      5.176084,
      4,
      0.635224,
      15,
      17,
      NULL,
      10.980973,
      NULL,
      NULL,
      15,
      7.362273,
      NULL,
      2.569059,
      1.519400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.952920,
      0.720071,
      0,
      NULL,
      1.388046,
      7,
      5,
      NULL,
      2.299123,
      NULL,
      0.992707,
      55,
      18,
      3.609666,
      1.944345,
      2,
      '43222',
      '',
      '',
      0.570216,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


