set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9022953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      '1300',
      1,
      1,
      NULL,
      NULL,
      ' 0- 3-1984',
      53.089209,
      NULL,
      3,
      0.899227,
      1,
      ' 3- 3-1997',
      59.707976,
      3,
      186,
      11.100295,
      3.792252,
      ' 7-10-1979',
      '11- 9-1974',
      ' 1-26-2001',
      2,
      NULL,
      1.699272,
      0,
      0.939441,
      1.538635,
      NULL,
      0.339349,
      1,
      8.936492,
      6.243392,
      6.001080,
      6,
      59.516113,
      28,
      1.806045,
      25.158386,
      NULL,
      NULL,
      2.393115,
      0,
      0.980384,
      0.339829,
      1,
      0,
      NULL,
      1.498455,
      1,
      0.026454,
      0,
      173,
      10,
      3,
      3,
      3,
      2.170954,
      NULL,
      1.463010,
      5,
      4,
      7,
      0,
      1.161384,
      5.032859,
      3.770447,
      0,
      1.021183,
      3,
      0,
      5.172794,
      0,
      1,
      0,
      NULL,
      NULL,
      1.777615,
      NULL,
      NULL,
      0,
      0.901986,
      0.854730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.903620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874713,
      1.957498,
      NULL,
      0,
      0,
      0,
      5.959500,
      0.008146,
      1.119049,
      5,
      1.017906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0.824696,
      NULL,
      1,
      3,
      4.303750,
      NULL,
      4,
      4.830963,
      NULL,
      4,
      3,
      0,
      1.926864,
      0,
      7,
      NULL,
      9,
      5,
      5.315704,
      NULL,
      7,
      6.822489,
      2,
      NULL,
      1,
      4.474907,
      NULL,
      3.311024,
      NULL,
      139.800849,
      ' 2- 3-1993',
      55.945367,
      2.206679,
      1,
      1,
      3.640633,
      1.016883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.469831,
      0.201770,
      3,
      4.767289,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236701,
      1.059473,
      2.698748,
      0.939965,
      1.333146,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.658917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.089725,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.550376,
      0,
      2.699281,
      2.770974,
      2,
      2.016816,
      0,
      2.245714,
      0.386195,
      NULL,
      NULL,
      2.474446,
      3,
      2.508552,
      3,
      NULL,
      NULL,
      2.443722,
      0.164273,
      1,
      1.825039,
      NULL,
      NULL,
      NULL,
      1,
      1.017118,
      0,
      1,
      1.197196,
      NULL,
      11.675644,
      4.439652,
      0.970072,
      1.364231,
      2.568665,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      40,
      NULL,
      43,
      2.707473,
      NULL,
      NULL,
      '41201',
      '32330',
      NULL,
      0.523544,
      '',
      '',
      '',
      2.694435,
      '31434',
      '13003',
      '241',
      0,
      NULL,
      362.808298,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.193027,
      3,
      1.864078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622748,
      2,
      2,
      NULL,
      NULL,
      3,
      0.117584,
      NULL,
      1.966239,
      0,
      2.027140,
      3.992842,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.835888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.107387,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.005683,
      0,
      1,
      14,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.561003,
      1,
      1.413007,
      0.647825,
      1,
      1.685679,
      NULL,
      NULL,
      0.906808,
      0,
      0,
      1.568844,
      0,
      1.980630,
      NULL,
      0,
      NULL,
      NULL,
      1.066257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4.592427,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884154,
      1.961563,
      NULL,
      NULL,
      0.731253,
      2,
      1.660200,
      4.950135,
      1.445482,
      2.720705,
      1.554587,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.213493,
      NULL,
      NULL,
      3.342538,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.077050,
      3,
      1,
      3,
      NULL,
      NULL,
      0.222821,
      NULL,
      3.243619,
      3,
      NULL,
      0,
      8,
      NULL,
      5,
      4,
      NULL,
      6.932649,
      5.352255,
      5,
      0.521318,
      1,
      NULL,
      NULL,
      3.692081,
      NULL,
      NULL,
      3.767116,
      1,
      1,
      8.114037,
      9,
      NULL,
      NULL,
      0.031442,
      0.755297,
      1,
      NULL,
      2,
      0,
      0.971917,
      2.157761,
      2.333673,
      3,
      3,
      1.378184,
      0.687819,
      4,
      2.669499,
      0,
      2,
      1,
      4,
      1,
      1,
      1,
      0,
      1.088926,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.536550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.371904,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.008184,
      NULL,
      NULL,
      0.506193,
      0.416945,
      1.986542,
      0,
      1,
      NULL,
      0.836832,
      NULL,
      NULL,
      1.236225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.050876,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.747157,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      624,
      256,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208132,
      NULL,
      NULL,
      2,
      1214.847915,
      NULL,
      50.326377,
      246,
      NULL,
      1,
      1.590069,
      NULL,
      0.601138,
      1.637166,
      1.929405,
      NULL,
      0.734890,
      NULL,
      0,
      0.207957,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.825663,
      1,
      0.736269,
      4,
      1.161115,
      0.621595,
      1,
      1.589419,
      1.036810,
      NULL,
      0.824289,
      1,
      NULL,
      1.214622,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.764834,
      1.814827,
      NULL,
      1,
      1.848532,
      NULL,
      NULL,
      2,
      NULL,
      0.479895,
      1,
      NULL,
      0.309722,
      3,
      NULL,
      1.996163,
      1,
      NULL,
      1.917456,
      NULL,
      0.926989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.476191,
      0,
      3,
      1,
      3.766617,
      33,
      NULL,
      0,
      NULL,
      1,
      '30121',
      NULL,
      '10313',
      NULL,
      '',
      '',
      '',
      0,
      '33121',
      '30222',
      '320');
commit;
end;
/


