set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      2.656796,
      0,
      0,
      NULL,
      NULL,
      '021',
      '12404300',
      33,
      18,
      '2314302',
      2,
      1.283174,
      1,
      2,
      '4033',
      4.758594,
      1,
      NULL,
      NULL,
      ' 8- 0-1978',
      46.245882,
      113,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238142,
      ' 1- 6-1983',
      NULL,
      ' 0- 5-1991',
      2,
      NULL,
      3.218167,
      1,
      1.592939,
      1.607892,
      3.507295,
      1,
      NULL,
      NULL,
      NULL,
      19,
      3.597335,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469816,
      4,
      NULL,
      1,
      0.010097,
      0.339474,
      1,
      1.460767,
      NULL,
      0,
      0.300237,
      0,
      0,
      1,
      0.181231,
      2.788707,
      0.561098,
      3.465004,
      8,
      NULL,
      0.332277,
      NULL,
      NULL,
      0.195567,
      3,
      1.855499,
      4,
      1,
      NULL,
      NULL,
      0.899248,
      0.680941,
      5,
      3.537550,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.425118,
      1,
      10.140195,
      NULL,
      0,
      1,
      1.724504,
      1,
      NULL,
      0,
      0.971999,
      2.391564,
      0.486608,
      3,
      2,
      NULL,
      2,
      0.811726,
      NULL,
      1.011749,
      NULL,
      3.900024,
      11.114197,
      1,
      3.811380,
      1.392422,
      1,
      NULL,
      NULL,
      0.105478,
      NULL,
      NULL,
      0.460916,
      1.057702,
      5.005140,
      4.437006,
      5,
      0.082736,
      NULL,
      1.975499,
      0.025169,
      1,
      0,
      1.242830,
      0.174412,
      1.811745,
      0.612841,
      1.399631,
      0,
      NULL,
      0.779390,
      NULL,
      0.125576,
      NULL,
      1.142131,
      0,
      0,
      1.318255,
      1.017303,
      0.901405,
      1.584164,
      1.096438,
      1.483157,
      0,
      0.923274,
      0,
      0,
      2.950303,
      3.770714,
      1.892131,
      5,
      4,
      NULL,
      1.357026,
      5.672668,
      NULL,
      1.048300,
      1.206811,
      2.668746,
      NULL,
      ' 5-15-1974',
      144,
      NULL,
      106,
      NULL,
      0.013216,
      NULL,
      3.676808,
      NULL,
      NULL,
      1.252388,
      0,
      NULL,
      3.623996,
      1.779762,
      0,
      5,
      7.845155,
      0,
      1,
      NULL,
      0.407185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.394131,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.810967,
      2.466236,
      7,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.107397,
      2.988679,
      0.901752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      0,
      0,
      3,
      18.623118,
      1.095592,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.323220,
      NULL,
      1.530724,
      3,
      NULL,
      0.678310,
      0,
      1,
      0.521006,
      2,
      0.277454,
      0,
      5.786067,
      NULL,
      2,
      1.720676,
      0.686435,
      1,
      0.630604,
      NULL,
      0,
      0.350828,
      1.472211,
      1,
      NULL,
      1,
      0.556880,
      1,
      5,
      1.686619,
      5.685520,
      1,
      5.014007,
      0,
      4.314460,
      7,
      1.168110,
      NULL,
      0.662248,
      1.796498,
      1.885072,
      0.786300,
      NULL,
      3.797609,
      2,
      9,
      NULL,
      0.601594,
      63.959503,
      0,
      3.173035,
      0.172739,
      '',
      '',
      '',
      2,
      '31424',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.582747,
      2.435864,
      28.395897,
      13.979524,
      1.721326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493552,
      0.171180,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.340690,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.922746,
      1,
      0.610747,
      NULL,
      NULL,
      0.292692,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.343160,
      NULL,
      NULL,
      1,
      4,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.266353,
      3,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      1.608501,
      NULL,
      2.253551,
      1.613653,
      1,
      1,
      0.085648,
      0,
      3,
      3.858197,
      1.182691,
      0.239905,
      NULL,
      0.717804,
      0.215213,
      NULL,
      NULL,
      1.976481,
      0.271504,
      0.021856,
      NULL,
      1.425279,
      3.784525,
      3,
      NULL,
      5.454514,
      1.526469,
      1.815425,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.898263,
      NULL,
      0.289559,
      1.585025,
      1,
      3,
      0,
      3.192819,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.788609,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.581251,
      NULL,
      NULL,
      0.178161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.002063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.735462,
      NULL,
      NULL,
      1.165477,
      NULL,
      NULL,
      2.213157,
      NULL,
      0.851328,
      0,
      2,
      NULL,
      1,
      3.971714,
      NULL,
      4.400798,
      4,
      0,
      0.952918,
      NULL,
      NULL,
      1,
      2.513608,
      3,
      0.784252,
      3.695540,
      1.060021,
      NULL,
      NULL,
      NULL,
      7,
      0.411117,
      5.079927,
      1.478367,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      1,
      1.800159,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454212,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659305,
      NULL,
      NULL,
      4.212227,
      NULL,
      NULL,
      0.251702,
      NULL,
      NULL,
      1.957850,
      1,
      2.528858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.191751,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.159931,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.280372,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      2,
      3.797491,
      1.806950,
      1.442833,
      NULL,
      NULL,
      0.720057,
      0,
      NULL,
      NULL,
      1.106380,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.468550,
      NULL,
      1.230371,
      284.159929,
      28,
      NULL,
      0.027221,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1.147849,
      0.863876,
      1.110314,
      0.482861,
      1.967474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.131292,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.501321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047906,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.490888,
      NULL,
      0.549769,
      NULL,
      NULL,
      1,
      1.149401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.803257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.880177,
      NULL,
      0,
      0.190330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.825761,
      NULL,
      0.574622,
      6.597896,
      1.632862,
      1.522286,
      2,
      4,
      1,
      0,
      2,
      1,
      NULL,
      2.366268,
      NULL,
      NULL,
      0.702758,
      NULL,
      1.979558,
      0.189492,
      NULL,
      1,
      0.271485,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.303376,
      NULL,
      1.415190,
      3.121062,
      NULL,
      1,
      0.048044,
      NULL,
      1.317097,
      1.825878,
      NULL,
      0,
      0.390145,
      NULL,
      1.912948,
      NULL,
      NULL,
      3.668047,
      0.345975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.521807,
      NULL,
      0.061361,
      NULL,
      5.299774,
      0.839306,
      NULL,
      0,
      NULL,
      NULL,
      78,
      85.568848,
      NULL,
      NULL,
      3,
      '42233',
      '',
      '',
      NULL,
      '21003',
      '',
      '',
      5.749029,
      '3042',
      '33101',
      '');
commit;
end;
/


