set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '3244441',
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 1-10-1990',
      NULL,
      NULL,
      1,
      2.684055,
      2.076896,
      ' 4-26-1980',
      7,
      1,
      233.089556,
      117,
      NULL,
      ' 1- 5-1977',
      '11- 1-1981',
      ' 8-23-1980',
      NULL,
      0.967498,
      1,
      1.923434,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8,
      3.647296,
      0,
      5,
      3,
      7.232182,
      1.381592,
      1,
      0,
      0.307016,
      0.270657,
      1.612586,
      0.547878,
      1,
      0,
      NULL,
      0,
      1,
      4,
      2.576766,
      0,
      5.536928,
      NULL,
      NULL,
      NULL,
      0.179566,
      NULL,
      1.338685,
      NULL,
      NULL,
      NULL,
      3,
      2,
      9,
      0.065370,
      0,
      NULL,
      0,
      1.008110,
      NULL,
      NULL,
      1.110011,
      NULL,
      NULL,
      2.817058,
      1.967755,
      1,
      1.358091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461955,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.358575,
      1.326832,
      1,
      0.332205,
      2.395039,
      0.085606,
      0,
      1,
      1.385745,
      NULL,
      0.333312,
      0.506545,
      3.247212,
      NULL,
      1,
      0,
      1.926638,
      0,
      NULL,
      1,
      2.546039,
      0,
      1,
      2.387891,
      NULL,
      6,
      1.511943,
      NULL,
      4,
      1.509211,
      NULL,
      0,
      1.289141,
      NULL,
      1,
      7,
      2.163947,
      0.180885,
      NULL,
      4,
      5.580024,
      3.282476,
      6.532725,
      0.615500,
      1,
      3,
      0.904378,
      ' 3-14-1988',
      14,
      NULL,
      11.558717,
      0.987996,
      0.527216,
      0.794282,
      3.354684,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.559794,
      8,
      6.923893,
      4.054361,
      2.763748,
      1.013420,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      1.387953,
      4,
      1,
      NULL,
      NULL,
      1,
      1,
      2.780143,
      NULL,
      1.463285,
      0,
      1.037974,
      0,
      5,
      3,
      5,
      4.708280,
      1,
      NULL,
      3,
      1.758966,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.762668,
      0.597823,
      NULL,
      0,
      1.362245,
      1,
      0.594685,
      NULL,
      1.879046,
      0.294638,
      NULL,
      NULL,
      NULL,
      2.310553,
      1,
      3.093245,
      2.199742,
      NULL,
      2,
      0.776754,
      3,
      0.101639,
      3,
      3,
      0.128872,
      2,
      0.018085,
      2.945583,
      0.966533,
      0.285410,
      NULL,
      1,
      NULL,
      1.021713,
      1,
      0,
      NULL,
      NULL,
      1.929252,
      1,
      1,
      0,
      3,
      NULL,
      0.704675,
      9.187094,
      5.920220,
      1.198515,
      10.350665,
      4,
      5,
      NULL,
      0.814902,
      5,
      1.505065,
      0.807680,
      2,
      1.494533,
      0.930442,
      3,
      NULL,
      NULL,
      61.513811,
      56.886402,
      4.879196,
      0.796209,
      2.103311,
      '32120',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.871875,
      '4420',
      '',
      '',
      3.080836,
      24,
      15,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.486877,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.091137,
      1.809933,
      1,
      NULL,
      NULL,
      NULL,
      1.708225,
      2,
      0,
      3,
      0.411220,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.687473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.112340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.487978,
      3.086185,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.111138,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.350484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      7,
      1,
      NULL,
      3,
      5.923804,
      1,
      0.059116,
      NULL,
      NULL,
      2.565347,
      0.865972,
      NULL,
      1,
      1,
      1.588283,
      3,
      1,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      3.929393,
      2.211261,
      1.142949,
      1.851623,
      2,
      0.929682,
      3.512358,
      0.160964,
      0.118467,
      NULL,
      5.941083,
      NULL,
      5.893271,
      3.574693,
      1,
      0.381340,
      NULL,
      NULL,
      1.982106,
      NULL,
      1.596438,
      NULL,
      0,
      0.213353,
      NULL,
      NULL,
      5.189874,
      NULL,
      NULL,
      1.710191,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.968795,
      NULL,
      NULL,
      1.016110,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.659339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.037097,
      NULL,
      NULL,
      1.920540,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.744667,
      1.725457,
      1.673572,
      0,
      NULL,
      NULL,
      NULL,
      4.683754,
      NULL,
      NULL,
      NULL,
      83.466438,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.842236,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.890554,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      1.857595,
      1.689957,
      NULL,
      NULL,
      NULL,
      3.668885,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.963735,
      NULL,
      1,
      12300.505553,
      0,
      NULL,
      NULL,
      0.147309,
      0,
      0.622751,
      1.181747,
      1.426950,
      1,
      0.483816,
      0,
      1.101631,
      1,
      1.646365,
      NULL,
      0,
      1.792489,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.459272,
      2,
      NULL,
      1.570081,
      4.862540,
      NULL,
      2,
      4.649937,
      1,
      3,
      0.420742,
      1.385539,
      2,
      NULL,
      0,
      1,
      NULL,
      1.316992,
      1,
      NULL,
      1.147931,
      0.892357,
      NULL,
      3.218762,
      1,
      NULL,
      0,
      2.463412,
      NULL,
      1.554329,
      0.551976,
      NULL,
      1.852253,
      1.333800,
      NULL,
      1,
      0,
      NULL,
      1.770896,
      3,
      NULL,
      0,
      3.463504,
      NULL,
      1,
      1.637917,
      2.994628,
      1.805011,
      NULL,
      2.500698,
      NULL,
      0.327213,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.647503,
      NULL,
      2,
      NULL,
      0.332326,
      NULL,
      172.685932,
      0,
      1.374306,
      NULL,
      0.776925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.892983,
      NULL,
      NULL,
      NULL,
      0.728077,
      NULL,
      3.201138,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.108590,
      NULL,
      1.366941,
      NULL,
      0.828107,
      NULL,
      113.468454,
      1,
      NULL,
      NULL,
      NULL,
      1.214764,
      NULL,
      0,
      NULL,
      NULL,
      0,
      9,
      0.622601,
      NULL,
      NULL,
      80,
      18,
      5,
      1,
      0,
      '40443',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      1.175052,
      NULL,
      '',
      '');
commit;
end;
/


