set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      NULL,
      7.212050,
      9,
      3,
      1.472004,
      7,
      '333',
      '10124321',
      31,
      67.213528,
      NULL,
      NULL,
      0,
      1,
      0,
      '2304',
      4,
      NULL,
      NULL,
      NULL,
      ' 2- 8-1975',
      146,
      25,
      NULL,
      0.217546,
      0.346817,
      '10- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      2.021517,
      NULL,
      ' 9-17-1986',
      ' 0- 4-1990',
      3.346502,
      3.161949,
      3.228540,
      1.957636,
      1,
      1,
      7,
      NULL,
      NULL,
      3.863575,
      1.957638,
      7.236997,
      2.914519,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      1.905045,
      0,
      1.992399,
      1,
      0.497845,
      1,
      0.788553,
      0.631356,
      1.488929,
      0,
      1.296774,
      2,
      NULL,
      15,
      NULL,
      9.016421,
      0,
      0.562529,
      3,
      1,
      0,
      10,
      NULL,
      2.952945,
      NULL,
      NULL,
      1.260188,
      9,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.798557,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.651114,
      1,
      0.776369,
      0,
      NULL,
      0,
      1,
      0,
      1.079453,
      2.789406,
      0,
      3,
      3,
      0.416828,
      0,
      3.170569,
      10,
      NULL,
      7,
      2.702492,
      0,
      0.200743,
      1.934773,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.722572,
      2.003796,
      NULL,
      NULL,
      0,
      0,
      0.149145,
      1,
      0,
      NULL,
      0.106561,
      1.535443,
      NULL,
      0,
      1.925998,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.175821,
      NULL,
      0,
      0,
      2,
      2,
      0.628253,
      0,
      0.314647,
      2.614736,
      0.896153,
      NULL,
      1.730049,
      3,
      0,
      3.282026,
      0.048163,
      4,
      5,
      2.966550,
      9.502443,
      1,
      3.338360,
      1,
      1,
      1,
      2.711106,
      ' 0- 1-1997',
      9.621643,
      ' 9-18-1977',
      67.481398,
      3.952143,
      2,
      NULL,
      0.040502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.977488,
      1,
      1,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870199,
      1.148724,
      NULL,
      NULL,
      NULL,
      1.404504,
      0.106622,
      4,
      0.945763,
      NULL,
      0.491893,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000160,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.613269,
      1.470450,
      0.716060,
      NULL,
      1.319824,
      0.415538,
      0,
      3,
      23,
      1.114067,
      1,
      NULL,
      NULL,
      NULL,
      5.154567,
      0.094362,
      1,
      1,
      1.540396,
      1,
      4.426628,
      NULL,
      0.191280,
      2.420846,
      1,
      5,
      4,
      5.746330,
      1,
      NULL,
      3.079010,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1.875744,
      1.476508,
      1,
      1.960761,
      0,
      NULL,
      1.239796,
      NULL,
      NULL,
      8,
      10,
      NULL,
      2,
      6.598540,
      6,
      NULL,
      0,
      7.645675,
      2.755542,
      1,
      2,
      NULL,
      2.154523,
      NULL,
      51,
      NULL,
      17.595969,
      15.492361,
      1,
      2,
      3,
      NULL,
      '33030',
      '',
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      44.232286,
      29.550261,
      7.618068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.232946,
      NULL,
      NULL,
      0.267365,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.509180,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.681067,
      NULL,
      NULL,
      5.180944,
      2,
      3,
      1,
      1.867321,
      NULL,
      NULL,
      NULL,
      1.491188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445331,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.592982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414241,
      NULL,
      NULL,
      1.247042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.377549,
      NULL,
      NULL,
      0.886820,
      NULL,
      NULL,
      1.489601,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.823853,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.588247,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.962586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113323,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.601130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.809038,
      NULL,
      NULL,
      1.169369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.225127,
      3,
      1.419689,
      0,
      4.840038,
      NULL,
      0.833313,
      NULL,
      NULL,
      1.247803,
      NULL,
      NULL,
      1.134515,
      NULL,
      1.824320,
      1,
      1.175651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.824841,
      NULL,
      0.188418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.624537,
      5,
      0.501501,
      0.983525,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486198,
      NULL,
      NULL,
      0,
      NULL,
      1,
      142.105427,
      4.851672,
      0.048665,
      0.479365,
      1.351847,
      0.366334,
      1,
      1,
      0.434672,
      NULL,
      1.329048,
      1.588839,
      NULL,
      0.861182,
      0.706319,
      1,
      1.201162,
      0.230726,
      1,
      2.730036,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.272212,
      NULL,
      0,
      NULL,
      19.400869,
      0.981802,
      NULL,
      1.543414,
      NULL,
      0,
      NULL,
      1.078184,
      NULL,
      NULL,
      NULL,
      0.726548,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061073,
      NULL,
      1.096052,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.385834,
      0,
      1.187577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210578,
      1.853495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196782,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.420290,
      NULL,
      0.386754,
      NULL,
      NULL,
      NULL,
      0.026896,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.502400,
      0,
      0.847778,
      0,
      NULL,
      1.126786,
      1,
      0,
      2.944230,
      3,
      0,
      0,
      1.087718,
      NULL,
      1,
      3.753555,
      NULL,
      1,
      2.713243,
      NULL,
      0,
      0,
      NULL,
      0.185892,
      1.202814,
      NULL,
      1,
      1.892524,
      NULL,
      0.036181,
      NULL,
      NULL,
      0.125349,
      0.160380,
      NULL,
      0,
      1.768560,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.697814,
      0,
      0.801834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415519,
      NULL,
      0.158404,
      NULL,
      0,
      7.889464,
      3,
      0,
      NULL,
      NULL,
      87.954232,
      41,
      3.251370,
      4,
      3,
      NULL,
      '30012',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


