set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9817670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.312990,
      4,
      0,
      NULL,
      NULL,
      3,
      3,
      2,
      NULL,
      NULL,
      52.768174,
      48.047746,
      NULL,
      0.651881,
      NULL,
      3,
      1,
      '2123',
      5,
      0,
      NULL,
      NULL,
      NULL,
      32.831143,
      164.668374,
      NULL,
      0,
      0,
      ' 8- 9-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      3.992875,
      '11-26-1974',
      NULL,
      NULL,
      1,
      0,
      2.373442,
      NULL,
      1.967626,
      NULL,
      1.959544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.354198,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0.227389,
      0.802670,
      1,
      1.239976,
      0,
      1,
      1,
      0.914615,
      0.330436,
      1,
      0.101733,
      1,
      4.166676,
      2.504212,
      3,
      2.708613,
      1.360361,
      NULL,
      0.374729,
      5,
      7,
      2,
      0.750989,
      3,
      1.824334,
      1.488052,
      0,
      7.012204,
      2.256098,
      3.794085,
      0,
      1,
      1.361569,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.661271,
      3.414890,
      NULL,
      1,
      3.272303,
      1,
      0,
      1.317893,
      0,
      NULL,
      1,
      1.095132,
      1,
      1.047514,
      0.721948,
      2.394059,
      0,
      NULL,
      1.739692,
      0.005715,
      0,
      0,
      1.014365,
      0.363222,
      0,
      NULL,
      NULL,
      2,
      1.046030,
      1.577293,
      NULL,
      0.107412,
      NULL,
      0.936278,
      3.225002,
      3,
      3,
      0,
      1.196986,
      9.147143,
      3.004656,
      3,
      NULL,
      4.720667,
      0.414205,
      NULL,
      NULL,
      1.515781,
      1,
      NULL,
      1,
      1.669057,
      1.885770,
      1.095908,
      NULL,
      2,
      1,
      0.828089,
      0.764904,
      1.867835,
      NULL,
      0.312422,
      1.037967,
      1.464854,
      5,
      0.584173,
      3.394986,
      2.755698,
      5.652993,
      0,
      1,
      5,
      0.465400,
      5,
      3.378434,
      NULL,
      1,
      1,
      NULL,
      1,
      ' 9-17-2001',
      1.134937,
      1.413895,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.933210,
      1.489756,
      1.411700,
      1,
      1.420866,
      NULL,
      1.188438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.912719,
      3.510132,
      3.883712,
      0,
      0.000457,
      NULL,
      1.170432,
      3.415897,
      0,
      0,
      6,
      0.604827,
      0,
      NULL,
      NULL,
      0.116574,
      0,
      0,
      1.464287,
      5.256005,
      NULL,
      1,
      ' 3- 3-1999',
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3.869210,
      2,
      NULL,
      NULL,
      0.098399,
      1.451525,
      0,
      1.535457,
      8,
      3.942387,
      0.848270,
      NULL,
      NULL,
      NULL,
      0.878072,
      NULL,
      1.496214,
      1,
      0,
      NULL,
      1,
      1.112673,
      1,
      0.115714,
      0.636894,
      2.218824,
      NULL,
      2.727945,
      NULL,
      2.596734,
      1,
      0.478414,
      1.032186,
      NULL,
      1.273235,
      0,
      1,
      0.454373,
      1,
      NULL,
      NULL,
      1,
      0.268111,
      1,
      3.319665,
      0.121725,
      NULL,
      6,
      0,
      5,
      NULL,
      3.994638,
      0.704757,
      1.421799,
      6.584378,
      0.183025,
      NULL,
      3.237723,
      NULL,
      1.772543,
      2.002712,
      38.415533,
      NULL,
      NULL,
      0,
      1.943499,
      5,
      1,
      '12034',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      5.021368,
      NULL,
      '0440',
      '',
      3,
      23,
      28.210160,
      32,
      0.345261,
      37,
      0,
      0,
      3.881180,
      NULL,
      1.856838,
      1,
      1.449220,
      NULL,
      0,
      NULL,
      3.089198,
      1,
      1,
      0.970832,
      NULL,
      0,
      0.219895,
      1.222354,
      2,
      2.185686,
      NULL,
      2.541648,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.008952,
      NULL,
      0.684897,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.108656,
      1.933287,
      2.207585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.177612,
      NULL,
      NULL,
      0.145006,
      NULL,
      NULL,
      0.882179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742251,
      1.363984,
      1.998757,
      0.323270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.228998,
      1.746425,
      1,
      3,
      3.567649,
      0,
      NULL,
      1.347489,
      NULL,
      5.738118,
      1.195299,
      0,
      0,
      NULL,
      NULL,
      2,
      1.102062,
      0.258464,
      NULL,
      1.108257,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649097,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.571503,
      NULL,
      NULL,
      1.817770,
      NULL,
      NULL,
      1.100560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.729538,
      NULL,
      NULL,
      0.241938,
      NULL,
      NULL,
      NULL,
      1.079672,
      1,
      6,
      NULL,
      1.895541,
      1.790399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.936402,
      1,
      1,
      0.552195,
      NULL,
      NULL,
      0,
      1.227111,
      1.159623,
      NULL,
      1,
      1.226509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.628067,
      1.867598,
      1,
      1.160750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.432769,
      NULL,
      NULL,
      NULL,
      0.013914,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.568055,
      NULL,
      NULL,
      NULL,
      1.665854,
      NULL,
      NULL,
      NULL,
      0.386598,
      NULL,
      NULL,
      NULL,
      1.480712,
      NULL,
      NULL,
      NULL,
      2.007231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284145,
      NULL,
      NULL,
      NULL,
      2.210515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771397,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.686287,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826722,
      1,
      1,
      NULL,
      NULL,
      0.904011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.179983,
      NULL,
      NULL,
      1.572830,
      1,
      0,
      1,
      0.814195,
      0,
      1,
      0.334389,
      0,
      0,
      0,
      0,
      0.524219,
      0,
      1.100805,
      0,
      0,
      1.942759,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686213,
      0.813865,
      NULL,
      2.163148,
      NULL,
      1,
      0,
      0.126146,
      1.417790,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      0.617320,
      NULL,
      3,
      1.091190,
      2,
      1.561001,
      1,
      0.313493,
      1,
      0.726117,
      0.458301,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.033030,
      0,
      0,
      1.895039,
      0.618742,
      2,
      3.355571,
      0,
      2,
      3.249864,
      0,
      NULL,
      1,
      2,
      1.726913,
      0.434076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904385,
      1.884821,
      NULL,
      1,
      0,
      1,
      1.482978,
      1.669699,
      3,
      NULL,
      NULL,
      NULL,
      8.580028,
      112.219876,
      NULL,
      3.090432,
      0,
      NULL,
      '43101',
      NULL,
      NULL,
      '',
      NULL,
      '',
      5.749686,
      '3314',
      '3203',
      '');
commit;
end;
/


