set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      2.057891,
      1.856316,
      4,
      0,
      '3131',
      0.866219,
      1,
      NULL,
      NULL,
      ' 6-20-2002',
      17,
      NULL,
      2,
      NULL,
      4.564774,
      '11-11-1982',
      13,
      1.718708,
      5,
      54,
      2.625764,
      ' 5-18-1992',
      '11- 0-1976',
      ' 5-24-1986',
      2,
      1.620043,
      3,
      0,
      1,
      2.918839,
      NULL,
      1,
      1,
      37,
      7,
      7.387067,
      9.872738,
      10.686894,
      6,
      NULL,
      24,
      7.930810,
      2,
      5,
      NULL,
      0,
      1,
      NULL,
      0,
      1.845902,
      1,
      1.673054,
      0.617391,
      1.821016,
      22.545416,
      NULL,
      9,
      3,
      NULL,
      3,
      0.038551,
      6,
      0.101874,
      7,
      NULL,
      4,
      NULL,
      4,
      8.472367,
      1.067191,
      2.829425,
      9,
      1.906351,
      2,
      NULL,
      0.752402,
      0.336270,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.293708,
      3.500578,
      0,
      NULL,
      NULL,
      1.478267,
      1.516800,
      NULL,
      0,
      NULL,
      NULL,
      3.954472,
      0,
      0,
      1,
      2,
      NULL,
      0,
      9.190066,
      4.782178,
      4,
      NULL,
      NULL,
      4.982609,
      NULL,
      1.504810,
      NULL,
      NULL,
      0.552892,
      NULL,
      NULL,
      3,
      1.077698,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1.274837,
      NULL,
      NULL,
      1,
      1.560829,
      1.575415,
      0.772270,
      NULL,
      0,
      1.790781,
      0,
      0.966910,
      NULL,
      1.385654,
      1,
      NULL,
      NULL,
      3.426270,
      NULL,
      5.337802,
      0,
      9,
      1.578503,
      1.658983,
      1,
      1.053835,
      3.758203,
      4,
      NULL,
      5.331017,
      5.531103,
      0,
      4,
      5,
      1,
      3.667213,
      '11-19-2003',
      74,
      ' 8-13-1983',
      118.355477,
      0.124948,
      0.085783,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272142,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.300675,
      NULL,
      2.850579,
      0,
      NULL,
      1.939016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3,
      1.601887,
      1,
      0.213756,
      0.486171,
      3,
      9.036969,
      6,
      4,
      8,
      6.156650,
      2.018470,
      1.171705,
      3,
      NULL,
      2.083950,
      1.455803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542174,
      0,
      NULL,
      0.279551,
      0.793895,
      NULL,
      2,
      NULL,
      34.431997,
      0.765935,
      1.918511,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.549204,
      2.417650,
      2.341582,
      NULL,
      7.218289,
      2,
      2.023264,
      0.773597,
      2,
      1.736403,
      7,
      2,
      2.580753,
      2.918084,
      0.546993,
      1.344110,
      0,
      NULL,
      0.229770,
      1.856461,
      1.212334,
      NULL,
      1.990348,
      0,
      0.470036,
      0.490640,
      1.106404,
      1,
      1.807290,
      0.737772,
      8,
      2,
      7,
      8,
      5,
      5,
      5.808090,
      2,
      NULL,
      3.303422,
      1,
      2.575929,
      22.938855,
      2.891999,
      2,
      NULL,
      NULL,
      14,
      11,
      4,
      1,
      3.683721,
      '23032',
      '',
      '',
      0.204271,
      '',
      '',
      NULL,
      1.193123,
      NULL,
      '',
      '',
      1.109400,
      NULL,
      7,
      1,
      0.045959,
      NULL,
      NULL,
      4.399018,
      NULL,
      0.879304,
      1,
      3.895511,
      0.025026,
      NULL,
      NULL,
      3,
      NULL,
      0.900444,
      0.512522,
      NULL,
      0,
      NULL,
      1,
      1,
      1.311393,
      NULL,
      NULL,
      3.371587,
      1,
      2,
      NULL,
      1,
      1.622355,
      0,
      NULL,
      1.228583,
      NULL,
      0,
      0.745651,
      0,
      1,
      1.484625,
      0.835023,
      2,
      0,
      0,
      3.485374,
      0,
      0.691445,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.150761,
      1.488310,
      3,
      1,
      NULL,
      1.071236,
      2.699374,
      0.212766,
      1,
      1.110108,
      3.548945,
      1.879123,
      NULL,
      1,
      2.945922,
      0,
      NULL,
      2.818182,
      0,
      NULL,
      NULL,
      0.857216,
      3,
      0,
      2,
      2,
      3,
      0,
      0.318651,
      NULL,
      2.382119,
      1,
      0.243146,
      1.772348,
      0.404399,
      1.218855,
      1.684621,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926708,
      NULL,
      NULL,
      3,
      0.811459,
      3,
      1.947645,
      NULL,
      NULL,
      3,
      NULL,
      2.194049,
      1,
      1.722696,
      1.400395,
      1,
      NULL,
      NULL,
      1.877117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.692949,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.358790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3.936775,
      4,
      0.213852,
      NULL,
      NULL,
      0.776506,
      NULL,
      NULL,
      0,
      3,
      0,
      2.382621,
      1,
      1.779753,
      7,
      6.879468,
      NULL,
      1,
      2.791808,
      NULL,
      3,
      3,
      NULL,
      2.239765,
      0,
      1.358832,
      NULL,
      0.827236,
      NULL,
      6,
      NULL,
      1.368164,
      0.186659,
      2,
      2.322266,
      NULL,
      3,
      NULL,
      NULL,
      1.177448,
      1.730179,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.557120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621604,
      NULL,
      NULL,
      2.236855,
      NULL,
      NULL,
      0.630160,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.208970,
      1,
      0.761640,
      1.131366,
      NULL,
      3.678248,
      0.381869,
      NULL,
      9.226143,
      4,
      NULL,
      NULL,
      10.459987,
      709,
      NULL,
      NULL,
      0.812910,
      NULL,
      NULL,
      NULL,
      0.854256,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458562,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.389412,
      1.672127,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.364530,
      0.247393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.552355,
      2,
      NULL,
      NULL,
      NULL,
      1.713899,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2.529664,
      2,
      NULL,
      NULL,
      NULL,
      3.308193,
      NULL,
      NULL,
      0,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      3.276433,
      3.956467,
      NULL,
      0,
      39,
      9,
      NULL,
      36.608974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318013,
      NULL,
      NULL,
      0.832221,
      NULL,
      NULL,
      1,
      6,
      0.907974,
      NULL,
      3.429509,
      NULL,
      NULL,
      1.724991,
      1.187741,
      1.162852,
      0,
      0.258223,
      NULL,
      0.650640,
      NULL,
      1.699652,
      1,
      1.345474,
      1,
      1,
      1,
      0,
      3.388469,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.134426,
      NULL,
      0.474073,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.345664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365370,
      NULL,
      NULL,
      2.863006,
      NULL,
      1.552062,
      NULL,
      239.253042,
      NULL,
      1.356798,
      NULL,
      NULL,
      NULL,
      1.370509,
      NULL,
      NULL,
      0,
      0.243820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348146,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.084594,
      NULL,
      3,
      NULL,
      3,
      NULL,
      53.708717,
      NULL,
      2.675680,
      NULL,
      1.199353,
      NULL,
      0.382269,
      0.626461,
      0,
      18.211235,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.689543,
      2.228410,
      7,
      3.543916,
      3.153479,
      0.248462,
      3,
      8,
      1.064125,
      1.458014,
      1.945032,
      1,
      1.655559,
      NULL,
      0,
      0.425573,
      NULL,
      2.086381,
      NULL,
      NULL,
      0.712891,
      0.724129,
      NULL,
      3,
      2,
      NULL,
      3.230947,
      2.524187,
      NULL,
      1,
      1.382531,
      NULL,
      0,
      1.461394,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.501285,
      NULL,
      1,
      0.741176,
      NULL,
      0,
      NULL,
      2.212048,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.945156,
      NULL,
      2.223017,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.791959,
      NULL,
      1.042592,
      NULL,
      1,
      NULL,
      2.656275,
      NULL,
      1,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      2.891654,
      NULL,
      3.325453,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.801121,
      NULL,
      3,
      NULL,
      1.804936,
      NULL,
      1.632785,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.522290,
      NULL,
      13.567697,
      1.478287,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.826652,
      NULL,
      5,
      5,
      1,
      0,
      NULL,
      NULL,
      14.584851,
      106.710610,
      5,
      1,
      6,
      NULL,
      '02422',
      '11132',
      0.306602,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


