set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '1302442',
      2,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      '10-29-1974',
      27.490087,
      NULL,
      2,
      0.095524,
      2,
      ' 8- 0-2000',
      23.177662,
      2.143536,
      289,
      NULL,
      0,
      ' 4-20-1999',
      NULL,
      ' 5- 4-1992',
      NULL,
      1,
      NULL,
      0.088637,
      0.979800,
      1,
      3.378241,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.135440,
      84,
      NULL,
      NULL,
      0,
      3,
      1,
      7.755993,
      NULL,
      0,
      1.899853,
      1,
      0.228970,
      1.182387,
      1.073264,
      0,
      0,
      3.990905,
      NULL,
      NULL,
      1,
      3,
      2.003243,
      2,
      3.432458,
      1.328025,
      0.413600,
      1.681488,
      0,
      3.070219,
      1.336301,
      0,
      NULL,
      0.060936,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205655,
      1.321881,
      2.209174,
      1,
      0.145461,
      1,
      0,
      1.608131,
      0,
      1.390292,
      3,
      NULL,
      0,
      3,
      3,
      2.230825,
      1.648216,
      1,
      1,
      2.155648,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141198,
      6,
      6,
      1.333492,
      3,
      4.469669,
      5,
      1,
      1,
      5.531461,
      3,
      1,
      1,
      6.638114,
      0.277652,
      0.477330,
      0.946852,
      NULL,
      1.726586,
      NULL,
      NULL,
      0,
      5.643991,
      0.963781,
      1.078931,
      0,
      4,
      3,
      1,
      1,
      NULL,
      1,
      2.532708,
      3,
      0.590523,
      4.750964,
      0,
      NULL,
      2.547475,
      2,
      1.140992,
      1.864403,
      5.407241,
      5,
      7,
      0,
      0,
      3.912795,
      ' 3-29-1999',
      53.748260,
      ' 0-10-1998',
      78.598317,
      1.673712,
      1.595801,
      1,
      0,
      NULL,
      1.724214,
      NULL,
      2.901985,
      0.060828,
      0.249301,
      4.355707,
      6,
      3.461768,
      1,
      1.396958,
      5.206583,
      1.078661,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485294,
      NULL,
      NULL,
      3.879354,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.700330,
      1.154542,
      1,
      NULL,
      NULL,
      NULL,
      3.241790,
      4,
      0,
      5,
      2,
      7,
      2,
      NULL,
      NULL,
      NULL,
      0.533746,
      5.433042,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0.158622,
      0,
      NULL,
      16.226103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123329,
      NULL,
      2.312260,
      0.281085,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      3,
      2,
      1,
      0.362898,
      0,
      3.569236,
      1.748708,
      0,
      2.768643,
      0.821890,
      NULL,
      0.548963,
      0.103248,
      NULL,
      0.004158,
      0,
      0.054085,
      1.772917,
      5.393339,
      1.258749,
      1.009424,
      7.806906,
      NULL,
      NULL,
      NULL,
      6.153890,
      NULL,
      2,
      NULL,
      4,
      3,
      1.781678,
      2,
      12.285153,
      2,
      1,
      NULL,
      22.460630,
      NULL,
      119.544462,
      0.478937,
      1,
      3.548973,
      '30300',
      '43323',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '4224',
      '',
      '',
      3,
      11,
      21.778368,
      NULL,
      3.792826,
      39,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.713275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.638264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.207956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.174863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244019,
      2.744417,
      2.286968,
      1,
      NULL,
      NULL,
      1.612047,
      NULL,
      NULL,
      2,
      1,
      1.586235,
      2.600648,
      2.905604,
      NULL,
      3.681137,
      1,
      1.341128,
      3,
      0.345542,
      3.296903,
      0,
      0,
      0.214875,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.516439,
      1.366427,
      3,
      0,
      0,
      9,
      8.997939,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356142,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.549371,
      2,
      0.231136,
      2,
      0,
      1,
      1.436128,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      3,
      0.288957,
      1,
      0.048925,
      1,
      0,
      5.547474,
      3,
      0.840861,
      1,
      NULL,
      NULL,
      0.476986,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.641613,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.110706,
      0.465195,
      0.187707,
      2.714210,
      1,
      NULL,
      5.080034,
      NULL,
      5.209443,
      2.635673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.231217,
      2.382209,
      1,
      NULL,
      NULL,
      0,
      0,
      6,
      5,
      NULL,
      2.249701,
      3.390832,
      2,
      0,
      0.200505,
      NULL,
      3,
      0,
      1,
      NULL,
      1.179551,
      5,
      5.054433,
      2,
      7,
      0,
      1,
      3.488214,
      0.045845,
      2.293453,
      0.755686,
      0.412496,
      1.969741,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3.880784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263681,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.173459,
      NULL,
      NULL,
      1.928832,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      7.984092,
      NULL,
      NULL,
      1.481403,
      1,
      0.594431,
      1.666385,
      NULL,
      1,
      0.596358,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.566803,
      NULL,
      NULL,
      NULL,
      1.523481,
      NULL,
      NULL,
      NULL,
      0.056473,
      NULL,
      NULL,
      NULL,
      2.809073,
      NULL,
      NULL,
      NULL,
      1.631038,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.738972,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.112434,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.661963,
      NULL,
      NULL,
      NULL,
      3.882476,
      NULL,
      NULL,
      NULL,
      2.238152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.392417,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949016,
      0,
      2,
      1.379214,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.591560,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      117,
      9,
      0.125395,
      NULL,
      0,
      NULL,
      1.768384,
      1,
      2,
      1.315818,
      NULL,
      0.700436,
      NULL,
      0.848959,
      1.075317,
      NULL,
      1.893034,
      1.083985,
      NULL,
      1,
      NULL,
      NULL,
      1.162564,
      NULL,
      0.628540,
      NULL,
      3,
      NULL,
      3.694137,
      NULL,
      37.237309,
      NULL,
      2.583733,
      NULL,
      37.164569,
      NULL,
      0.826713,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.349522,
      NULL,
      1.198162,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.801430,
      NULL,
      NULL,
      NULL,
      0.698361,
      NULL,
      NULL,
      NULL,
      1.483904,
      NULL,
      2.383199,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393491,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.893645,
      NULL,
      1,
      NULL,
      1.684930,
      0.847663,
      1.203103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.546365,
      3.908478,
      0,
      0.526009,
      NULL,
      2.373487,
      0.689063,
      1.187044,
      0.618332,
      0.025010,
      0,
      1.162919,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.995141,
      NULL,
      1,
      0.897445,
      NULL,
      3,
      2.763276,
      NULL,
      1,
      NULL,
      NULL,
      0.889100,
      0,
      NULL,
      3.123692,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343975,
      1,
      NULL,
      2,
      0,
      1.192173,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2.664016,
      1,
      NULL,
      2.425506,
      NULL,
      0.967556,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.535857,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.113770,
      NULL,
      3.216815,
      NULL,
      0.987298,
      NULL,
      24.162484,
      2,
      NULL,
      0.009573,
      NULL,
      0.414424,
      NULL,
      2.072729,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      7.023783,
      '04201',
      '33334',
      '33121',
      1,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


