set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9797944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.796790,
      1.259289,
      0.421610,
      3.146455,
      NULL,
      2,
      3.728675,
      2,
      NULL,
      NULL,
      24.723893,
      21.056994,
      '0010434',
      1.183898,
      1.501766,
      2,
      3,
      '0222',
      2.751306,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      NULL,
      NULL,
      NULL,
      1.900811,
      ' 0-10-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-2003',
      0,
      0.322084,
      2,
      1,
      1.142971,
      0,
      5.270731,
      0.210835,
      1,
      NULL,
      9,
      10.478306,
      5.145645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.063602,
      7,
      3.053735,
      NULL,
      NULL,
      0.825121,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817046,
      NULL,
      2,
      1,
      0,
      1.921768,
      NULL,
      0,
      1.279462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.908207,
      NULL,
      0,
      0.854304,
      3.030501,
      NULL,
      3.652865,
      2,
      1,
      NULL,
      0,
      2.937142,
      NULL,
      0.271697,
      1.813235,
      0,
      0,
      2,
      0.156159,
      0,
      3,
      1,
      3,
      NULL,
      0.283719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242465,
      0,
      1.321526,
      1.371266,
      0,
      0.941509,
      0.081976,
      NULL,
      0.104141,
      1,
      1.591797,
      0,
      0,
      0,
      1.575044,
      0,
      0.211694,
      1,
      0,
      NULL,
      1,
      3.548370,
      0.058670,
      1,
      0.559800,
      1,
      NULL,
      2.366595,
      1.690994,
      1,
      1,
      0.448693,
      0.323752,
      1.728364,
      0.426073,
      0.463006,
      1.053835,
      1,
      2,
      4,
      3.554810,
      9,
      7.762891,
      3,
      1.900245,
      0,
      1.248512,
      2,
      NULL,
      1087.857785,
      NULL,
      194,
      1,
      1.084660,
      1,
      1.008315,
      1.601072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489552,
      NULL,
      NULL,
      0.022953,
      1,
      1,
      0.357841,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.491798,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834851,
      0,
      1.024486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076733,
      1,
      3.976819,
      NULL,
      0.236576,
      NULL,
      1.432223,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.392808,
      0.182243,
      1,
      NULL,
      NULL,
      1,
      2,
      2.707106,
      2,
      2.103516,
      3,
      2,
      1,
      NULL,
      2.475747,
      NULL,
      1.786075,
      1.867824,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0.310660,
      0.965753,
      2.082699,
      0,
      4.278091,
      1.755501,
      2,
      4.245210,
      1,
      11,
      9,
      1.339774,
      2.141293,
      3,
      2.600440,
      2,
      3.826497,
      NULL,
      7,
      2.328737,
      1.890843,
      73.372180,
      NULL,
      NULL,
      NULL,
      4.991195,
      1.712115,
      0,
      NULL,
      NULL,
      NULL,
      1.264087,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      25,
      310.848933,
      NULL,
      NULL,
      21,
      0,
      NULL,
      3,
      3,
      1,
      2,
      0.378376,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.411686,
      1.842762,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.720058,
      2,
      NULL,
      NULL,
      NULL,
      1.623264,
      0.428331,
      1.832359,
      0.304418,
      0,
      NULL,
      0,
      0,
      3,
      1,
      0.716470,
      8,
      0.631155,
      4.378684,
      0,
      0.020601,
      NULL,
      NULL,
      NULL,
      0.715353,
      NULL,
      NULL,
      NULL,
      3.248301,
      NULL,
      2.473849,
      2.030845,
      1.469215,
      3.439882,
      NULL,
      NULL,
      2,
      1.691158,
      0.228061,
      NULL,
      NULL,
      NULL,
      0.714149,
      NULL,
      2,
      0.199187,
      1,
      NULL,
      NULL,
      1,
      3,
      1.714644,
      1,
      1.360227,
      NULL,
      NULL,
      1.415442,
      1,
      1,
      0.188200,
      1.371074,
      2,
      2.458710,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      4,
      1.483459,
      0.671234,
      NULL,
      NULL,
      NULL,
      0.041846,
      NULL,
      NULL,
      0.044676,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540054,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.550229,
      0,
      NULL,
      NULL,
      0,
      0,
      1.573118,
      3,
      5.105482,
      3,
      NULL,
      NULL,
      NULL,
      3.565895,
      3.145125,
      2,
      1,
      NULL,
      NULL,
      3,
      3,
      0.388115,
      6,
      5.991722,
      NULL,
      NULL,
      0,
      2.794972,
      NULL,
      1,
      2.813202,
      1.713292,
      2.132946,
      0.815858,
      1.978976,
      NULL,
      0.822389,
      5,
      4.637306,
      5,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.860093,
      1.306632,
      0,
      0.546911,
      0.887891,
      1,
      0.638145,
      NULL,
      NULL,
      1.028502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.674590,
      NULL,
      NULL,
      0.085273,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.316037,
      NULL,
      NULL,
      1.057786,
      NULL,
      NULL,
      6.129907,
      NULL,
      NULL,
      1,
      1,
      1,
      0.387615,
      1.574971,
      3.980342,
      NULL,
      NULL,
      NULL,
      0.922139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.689521,
      NULL,
      NULL,
      NULL,
      0.365664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.826052,
      NULL,
      NULL,
      NULL,
      1.202870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.987101,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732877,
      NULL,
      NULL,
      NULL,
      0.727593,
      NULL,
      7.371196,
      8,
      0.708236,
      93.334814,
      NULL,
      3,
      19.413742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.403873,
      NULL,
      1,
      145.677682,
      26.946170,
      NULL,
      0.731228,
      0.482978,
      NULL,
      NULL,
      0.123766,
      0.442100,
      0.483253,
      1.897376,
      NULL,
      0.051700,
      1.631558,
      0,
      1,
      0.122027,
      1,
      1.272888,
      0.529221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.659047,
      NULL,
      1.087705,
      NULL,
      1.468471,
      NULL,
      2,
      0,
      NULL,
      1,
      1.872922,
      NULL,
      NULL,
      0.679540,
      1.802239,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0.534819,
      NULL,
      0,
      0.018221,
      NULL,
      1.780748,
      1,
      NULL,
      0.900325,
      3,
      NULL,
      0,
      1.859310,
      NULL,
      1,
      0.629552,
      NULL,
      NULL,
      1.716967,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559500,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.289380,
      1,
      1.238413,
      0,
      NULL,
      NULL,
      31,
      77.648252,
      4,
      NULL,
      3.941495,
      '22011',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


