set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      '0102',
      0,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1989',
      36.733214,
      NULL,
      NULL,
      2,
      0,
      ' 0-25-1991',
      66.460650,
      NULL,
      257.143842,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-2002',
      NULL,
      0,
      0.107760,
      3,
      0,
      NULL,
      3,
      0.611827,
      0,
      NULL,
      14.797358,
      16,
      0,
      2,
      1.235424,
      0,
      11.144424,
      5.217270,
      NULL,
      7.286107,
      1,
      0.803286,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1.368069,
      0.969175,
      0.554610,
      0.312973,
      1.104778,
      1,
      0,
      0,
      1,
      1.697471,
      1.021027,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575373,
      2.315805,
      NULL,
      NULL,
      1.725665,
      NULL,
      1,
      NULL,
      3,
      1,
      0.169551,
      3,
      1,
      1.849553,
      1,
      3.865372,
      1.818760,
      1.441058,
      NULL,
      1,
      1,
      0,
      4.439062,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.125122,
      0,
      1.448076,
      NULL,
      NULL,
      NULL,
      7.357512,
      4,
      9,
      5,
      6.082996,
      NULL,
      3,
      NULL,
      1,
      1.789085,
      0,
      NULL,
      NULL,
      NULL,
      1.480073,
      3,
      7.527001,
      0.395678,
      1.277393,
      0,
      NULL,
      2.007629,
      NULL,
      0,
      NULL,
      3,
      1,
      3,
      4,
      0.481818,
      1.157220,
      0.245260,
      NULL,
      0,
      0,
      1,
      0,
      1.417843,
      NULL,
      NULL,
      0,
      1,
      ' 4-22-1976',
      950,
      ' 9-25-1990',
      1775,
      0.051006,
      5,
      0,
      0,
      0.569435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104217,
      1,
      1,
      NULL,
      0,
      1.827655,
      0.656714,
      0.891425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.845791,
      1,
      NULL,
      NULL,
      0.588404,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690610,
      1.196056,
      1,
      1,
      0,
      1.203315,
      1.661453,
      0.259979,
      NULL,
      0.478179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820540,
      2.337229,
      1.572425,
      3,
      2,
      3,
      3,
      3,
      3,
      1,
      0.557850,
      2,
      1,
      3,
      NULL,
      5.952293,
      1.552758,
      NULL,
      1.591119,
      0,
      1,
      3.136032,
      1.591367,
      0,
      1,
      NULL,
      0.896031,
      0.423323,
      1,
      1.034578,
      NULL,
      NULL,
      3.716467,
      2,
      0.796001,
      NULL,
      0.859991,
      5,
      1,
      0.155697,
      3,
      0,
      1.775252,
      23,
      NULL,
      1.478300,
      10,
      NULL,
      NULL,
      NULL,
      1,
      1.404362,
      1,
      '33013',
      NULL,
      '',
      1.134426,
      '',
      '',
      NULL,
      0.264317,
      '',
      '',
      '',
      NULL,
      11,
      575,
      NULL,
      2,
      NULL,
      1,
      4,
      3.594456,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.838537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.966472,
      NULL,
      NULL,
      0.934570,
      NULL,
      NULL,
      0.699804,
      0.230869,
      1,
      1.053730,
      NULL,
      NULL,
      1.991266,
      NULL,
      NULL,
      2.931087,
      1.004292,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.763519,
      1,
      0,
      0.701110,
      NULL,
      NULL,
      NULL,
      1.451064,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736998,
      1.147917,
      0,
      3.573189,
      1.484977,
      3,
      2.343009,
      3.774566,
      NULL,
      1,
      NULL,
      2,
      1.610081,
      NULL,
      0.404905,
      NULL,
      2.265489,
      0,
      0.501613,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.667836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.984154,
      NULL,
      1.113816,
      1.932808,
      0.218789,
      NULL,
      NULL,
      NULL,
      1.512160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639490,
      NULL,
      NULL,
      1.132807,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.796942,
      NULL,
      NULL,
      NULL,
      NULL,
      3.466595,
      NULL,
      2,
      0.851349,
      NULL,
      NULL,
      1.760046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338020,
      NULL,
      NULL,
      0.748266,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.678959,
      NULL,
      2.097068,
      1,
      1.139080,
      3.446567,
      0.349277,
      6,
      0.357569,
      1.364827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.446969,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      3,
      0.632920,
      2,
      1,
      0,
      1.682359,
      1.168377,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.569055,
      NULL,
      NULL,
      1.827226,
      NULL,
      NULL,
      0.491013,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676452,
      NULL,
      NULL,
      NULL,
      0.422086,
      0,
      1,
      0.622166,
      3.970973,
      1.079360,
      NULL,
      NULL,
      3.273574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043962,
      NULL,
      NULL,
      NULL,
      0.726222,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.640613,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.906024,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      429.928786,
      NULL,
      0.574371,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1377,
      1880,
      1,
      NULL,
      NULL,
      1.461799,
      NULL,
      NULL,
      0,
      1936.528042,
      0,
      1.903707,
      0.557811,
      0,
      1.527736,
      1.019355,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.044622,
      NULL,
      0,
      0.052515,
      NULL,
      0.797814,
      1.544572,
      0.690533,
      NULL,
      0.425916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.836446,
      NULL,
      3,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      1.530812,
      0,
      0,
      0.223231,
      NULL,
      2.487090,
      NULL,
      NULL,
      0,
      0.828595,
      NULL,
      1,
      0,
      NULL,
      0.472698,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.968950,
      0.504949,
      NULL,
      0.401938,
      0.387450,
      NULL,
      0.075289,
      NULL,
      NULL,
      NULL,
      2.386875,
      NULL,
      0,
      0.421075,
      NULL,
      1,
      1,
      1.789039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      0.068171,
      NULL,
      NULL,
      NULL,
      45.060138,
      4.825886,
      0,
      NULL,
      '44200',
      '',
      '',
      0.586140,
      '',
      '',
      NULL,
      1.770645,
      '',
      NULL,
      '');
commit;
end;
/


