set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9604470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3201313',
      3.539391,
      0.875995,
      3,
      3,
      '1043',
      3.183304,
      NULL,
      NULL,
      NULL,
      ' 1-11-2003',
      53.888941,
      NULL,
      3,
      0,
      1.480054,
      ' 2- 8-1988',
      34,
      2,
      314.261102,
      10.586859,
      0.531444,
      ' 9- 2-1995',
      ' 3-19-1988',
      ' 2-29-1980',
      NULL,
      3.571912,
      0.282794,
      0.338563,
      NULL,
      0.456866,
      NULL,
      1.020608,
      1,
      7,
      11.892574,
      NULL,
      2.117774,
      NULL,
      22,
      7,
      0.246512,
      0,
      0.488452,
      0.653248,
      1.195758,
      NULL,
      0.472435,
      1.480030,
      0.021510,
      0.725330,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.032065,
      NULL,
      1.291872,
      NULL,
      NULL,
      0,
      2,
      3.222198,
      NULL,
      0,
      1,
      1,
      0.322668,
      3,
      1,
      8,
      0,
      NULL,
      1.845873,
      0.807373,
      1,
      NULL,
      NULL,
      0.284660,
      NULL,
      NULL,
      0,
      0.634468,
      NULL,
      0.471325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.728567,
      0.969253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309703,
      NULL,
      1.316189,
      0,
      1,
      7,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.178479,
      1.542310,
      7.066302,
      1.674820,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1.893966,
      1.784926,
      1.918073,
      0,
      1.754054,
      NULL,
      1,
      1.071971,
      NULL,
      NULL,
      1.546453,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.111058,
      7,
      NULL,
      3,
      5,
      0.038698,
      1.138574,
      1.900683,
      NULL,
      ' 6- 4-1994',
      670.038244,
      ' 9- 1-1979',
      NULL,
      1,
      0.783806,
      0,
      0.192876,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166081,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.080855,
      0.911442,
      1.588422,
      1,
      1,
      3.549936,
      5,
      0.088499,
      5,
      0.672092,
      NULL,
      NULL,
      NULL,
      1.225229,
      0,
      0.144464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.342495,
      NULL,
      NULL,
      0,
      0.238986,
      1,
      0,
      NULL,
      NULL,
      1.318989,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.466366,
      0,
      1,
      2,
      NULL,
      0.745005,
      1,
      2.305334,
      1,
      NULL,
      3.015113,
      2.295755,
      0.485648,
      0.407084,
      1,
      0,
      1,
      5.506944,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1.046550,
      9,
      3,
      1,
      NULL,
      10.683985,
      NULL,
      5,
      1,
      NULL,
      1,
      3,
      NULL,
      65,
      3,
      NULL,
      NULL,
      62.209915,
      19,
      30,
      1.139199,
      4,
      0.251051,
      '34230',
      '',
      '',
      0.872788,
      '',
      '',
      '',
      0.441537,
      '',
      '',
      NULL,
      3.332871,
      6.761797,
      206.032104,
      70.941413,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.788452,
      1,
      3,
      0,
      NULL,
      NULL,
      0.520277,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.056274,
      1.587034,
      2,
      1,
      1.663411,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.490441,
      NULL,
      NULL,
      1.065779,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1.226328,
      NULL,
      NULL,
      NULL,
      1.210507,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248343,
      1.740286,
      NULL,
      NULL,
      NULL,
      1.122158,
      NULL,
      NULL,
      0.816268,
      0.810417,
      0,
      3.370408,
      0.657969,
      1.002460,
      3,
      0,
      NULL,
      0,
      0.038005,
      0.301559,
      0.074184,
      3.426487,
      1.841650,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      1.835035,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.629005,
      0,
      3,
      0.412330,
      0.577033,
      0,
      NULL,
      NULL,
      NULL,
      3.040156,
      4.389686,
      NULL,
      NULL,
      1,
      NULL,
      0.180125,
      0.265878,
      5.419533,
      2.383855,
      2.213569,
      0.445370,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.321488,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.290862,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.189827,
      2,
      0,
      0,
      NULL,
      NULL,
      5,
      1.156542,
      3.000749,
      NULL,
      3,
      1.283822,
      0.827634,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.035156,
      3,
      3.732173,
      7.725199,
      2,
      7,
      3.990329,
      NULL,
      NULL,
      0.436660,
      1.659459,
      2.742307,
      NULL,
      NULL,
      1,
      1.609258,
      1.987754,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.087246,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.824633,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.911165,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.233724,
      NULL,
      NULL,
      NULL,
      0.522231,
      NULL,
      NULL,
      NULL,
      1.877395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713670,
      NULL,
      NULL,
      NULL,
      0.389790,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.898365,
      0.517752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.737757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.811558,
      432.571840,
      20.244148,
      1.525732,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.627110,
      0.622466,
      2.626537,
      NULL,
      NULL,
      1,
      1.133872,
      0,
      NULL,
      0.202315,
      0.633471,
      NULL,
      2.823321,
      NULL,
      3.179857,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.822850,
      NULL,
      174,
      NULL,
      2,
      NULL,
      24.561338,
      NULL,
      1,
      NULL,
      NULL,
      0.850223,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.149853,
      NULL,
      NULL,
      NULL,
      0.933219,
      NULL,
      3.790605,
      NULL,
      NULL,
      NULL,
      0.809486,
      NULL,
      NULL,
      NULL,
      1.628537,
      NULL,
      0.712857,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.628823,
      NULL,
      NULL,
      NULL,
      0.547445,
      NULL,
      0,
      0.777149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.326615,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.833820,
      NULL,
      0,
      NULL,
      1.731737,
      0.342848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316282,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100643,
      NULL,
      0.449852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.993650,
      0,
      2.068562,
      1,
      2.032429,
      NULL,
      470.830982,
      1.182946,
      2.755407,
      0,
      0.362951,
      1,
      NULL,
      NULL,
      3,
      16.242797,
      7,
      0.627990,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.492046,
      0.340090,
      1.948312,
      1,
      3,
      2.737090,
      1.872956,
      1.146025,
      1.434375,
      1,
      NULL,
      2.589527,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.796079,
      NULL,
      1.296136,
      1.074329,
      NULL,
      0.851551,
      0.970303,
      NULL,
      1.644500,
      NULL,
      NULL,
      1,
      1.300233,
      NULL,
      0.847831,
      1.039660,
      NULL,
      1.180545,
      1.272845,
      NULL,
      0,
      0,
      NULL,
      1.564800,
      0.282781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117535,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      35,
      54.152012,
      NULL,
      5.180457,
      1.823104,
      NULL,
      '02140',
      NULL,
      1,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


