set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8514545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2410144',
      2,
      1.147610,
      2,
      1,
      '0133',
      NULL,
      0,
      NULL,
      NULL,
      ' 4-10-1997',
      28.867015,
      NULL,
      5.264981,
      1,
      1,
      ' 4-17-1983',
      13,
      2,
      272.816597,
      100.283291,
      1,
      '10- 3-1996',
      ' 6- 4-1995',
      '10-18-1982',
      NULL,
      1,
      0.444396,
      0.391767,
      1.700950,
      1,
      NULL,
      0.983556,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      20,
      13.085020,
      5.384310,
      14.889500,
      0.539028,
      5,
      9.984689,
      3.884127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991350,
      0.647095,
      0,
      NULL,
      8.503126,
      1.796697,
      5.768311,
      0,
      1,
      9,
      5.001701,
      NULL,
      1,
      NULL,
      1.147521,
      NULL,
      1.786419,
      NULL,
      4,
      3,
      2.106538,
      1.639247,
      NULL,
      NULL,
      1.734988,
      NULL,
      NULL,
      NULL,
      0,
      0.428291,
      2,
      1,
      1,
      1,
      0.020800,
      0,
      1,
      NULL,
      1.228658,
      0.436138,
      NULL,
      1,
      NULL,
      3.049715,
      2,
      1,
      NULL,
      1,
      1.989689,
      3,
      NULL,
      0.847149,
      1,
      0,
      NULL,
      NULL,
      0.666853,
      NULL,
      NULL,
      1,
      1,
      5,
      1.814607,
      2,
      NULL,
      7,
      1,
      NULL,
      0,
      1.045618,
      1.480437,
      1.085980,
      4,
      1,
      0,
      1,
      1.583854,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      1,
      0.014516,
      1.268235,
      0.215459,
      1,
      NULL,
      3.544700,
      2,
      0,
      NULL,
      3.221744,
      1.826797,
      1.995011,
      3.453933,
      NULL,
      NULL,
      0,
      5,
      2,
      0.971496,
      NULL,
      273,
      NULL,
      519.859916,
      2,
      NULL,
      NULL,
      1.743228,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356635,
      0.988643,
      1.091306,
      3.601515,
      NULL,
      1.079620,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.702158,
      5.068024,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.491365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.462177,
      0.509357,
      0,
      1.473551,
      NULL,
      NULL,
      1,
      12,
      0,
      1.316422,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.779611,
      0.675494,
      0.720551,
      NULL,
      NULL,
      2,
      1.025631,
      NULL,
      NULL,
      3.322344,
      NULL,
      3.145680,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      0.453595,
      1.835590,
      1,
      1.304131,
      1.353849,
      1.101650,
      NULL,
      1,
      0.028316,
      1.864030,
      1.915111,
      0.405885,
      6.584669,
      10,
      7,
      5,
      8,
      7.521394,
      0,
      3.685460,
      0.508908,
      NULL,
      0.423175,
      0.870047,
      41.393850,
      0,
      3,
      NULL,
      49.376532,
      57.169042,
      43.759778,
      5.374840,
      0,
      5.331152,
      '34110',
      '21000',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      29.834857,
      143.048953,
      2.008820,
      NULL,
      5,
      0,
      2.120794,
      NULL,
      1.614487,
      0.857863,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.258297,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      2.429153,
      2,
      3.658218,
      0,
      NULL,
      NULL,
      1.979183,
      NULL,
      NULL,
      1.232575,
      NULL,
      NULL,
      0.722824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0.532523,
      NULL,
      NULL,
      NULL,
      0.038234,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.627927,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.904447,
      0.617571,
      1,
      NULL,
      3,
      1.906132,
      0.547250,
      1,
      0,
      NULL,
      0.706415,
      1.135931,
      0.243537,
      2.606107,
      2.189228,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676715,
      NULL,
      NULL,
      1.927024,
      NULL,
      1.363529,
      NULL,
      1.710813,
      0,
      NULL,
      0.235555,
      NULL,
      NULL,
      NULL,
      0.517603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.579035,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.525297,
      1.777760,
      2,
      0.343339,
      1.640807,
      4.480519,
      1.958370,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.777939,
      NULL,
      NULL,
      0.933616,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      1.407043,
      0,
      0,
      NULL,
      NULL,
      4.006716,
      0.582836,
      0.912599,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312901,
      NULL,
      NULL,
      2.473749,
      0.265462,
      1.310898,
      1.252183,
      0,
      NULL,
      NULL,
      0.219784,
      1,
      7.126117,
      NULL,
      5,
      NULL,
      3.032701,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.362402,
      1.389811,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.189160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.566180,
      NULL,
      NULL,
      0.646913,
      NULL,
      NULL,
      1.135719,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1.608988,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2.655763,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303152,
      NULL,
      NULL,
      NULL,
      0.702045,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.952175,
      NULL,
      NULL,
      NULL,
      1.767113,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.844070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.033072,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.635338,
      NULL,
      NULL,
      NULL,
      3.008763,
      2,
      5,
      0.367749,
      NULL,
      10.380654,
      1,
      2.313087,
      52,
      1.156901,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.713494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.020752,
      NULL,
      1,
      609.043268,
      10.485962,
      1,
      3.563230,
      1,
      0,
      1,
      0.257283,
      0.753346,
      2,
      0.970505,
      2,
      0,
      0,
      0.744338,
      0.900938,
      1.909424,
      0.366400,
      NULL,
      3.493651,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.209668,
      NULL,
      61.034346,
      NULL,
      1,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122449,
      NULL,
      0.469203,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.652751,
      NULL,
      0.815643,
      NULL,
      1.802497,
      3.504825,
      0.010598,
      NULL,
      NULL,
      1.275219,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.700678,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.840861,
      1.267196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.502037,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.402883,
      NULL,
      NULL,
      NULL,
      1.444452,
      NULL,
      1,
      1,
      0,
      NULL,
      1.656282,
      NULL,
      0.158420,
      NULL,
      NULL,
      NULL,
      1.316098,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.893918,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.244066,
      NULL,
      0,
      NULL,
      1.389588,
      NULL,
      NULL,
      NULL,
      0,
      1.419774,
      0.193597,
      NULL,
      0,
      NULL,
      1.164199,
      NULL,
      NULL,
      NULL,
      1.898376,
      NULL,
      0,
      NULL,
      0.211274,
      0.302087,
      0.490381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.807810,
      7.160855,
      3,
      4,
      2,
      NULL,
      12,
      0.233902,
      1.225708,
      1.547312,
      1.913029,
      3,
      NULL,
      3.981640,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0.415405,
      0,
      NULL,
      0.567163,
      1.068263,
      NULL,
      0,
      0.751682,
      NULL,
      NULL,
      NULL,
      NULL,
      2.110437,
      1.232994,
      NULL,
      1.756956,
      0.848780,
      NULL,
      0,
      0.576739,
      NULL,
      0.601411,
      0.436160,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      5.994583,
      6,
      8.347079,
      1.951049,
      1,
      3.555574,
      49,
      64,
      1.627772,
      0.500316,
      1.913361,
      '31340',
      NULL,
      '',
      0.661547,
      NULL,
      '',
      '',
      1.124268,
      '',
      '',
      '');
commit;
end;
/


