set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7942292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.841794,
      NULL,
      6,
      NULL,
      7,
      3.450236,
      0,
      1.077134,
      NULL,
      NULL,
      68,
      32,
      '2410330',
      2,
      1.392522,
      2,
      3,
      '2213',
      4.844782,
      0.311263,
      NULL,
      NULL,
      ' 2-12-1985',
      36.979637,
      NULL,
      NULL,
      1.724028,
      0,
      '10- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 7-20-1974',
      ' 0-19-1990',
      1.812720,
      0,
      3.306819,
      0,
      3,
      0.636324,
      3,
      0,
      0.450066,
      NULL,
      4.898529,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.971628,
      NULL,
      1.938853,
      1.422896,
      0.447641,
      NULL,
      1.396766,
      NULL,
      NULL,
      0.417310,
      1,
      NULL,
      5.117593,
      1.126535,
      NULL,
      NULL,
      1.863460,
      0,
      0.892604,
      0.420907,
      6.329296,
      0.859147,
      1.503244,
      0,
      0.547031,
      NULL,
      1.881933,
      0,
      0,
      0.079723,
      NULL,
      0.443824,
      NULL,
      NULL,
      0.575951,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      0.810621,
      1,
      0,
      1,
      1.294882,
      0,
      1.182508,
      0.201501,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.146105,
      0,
      0,
      4,
      NULL,
      1,
      1.227226,
      1.225481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152892,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      1.552574,
      0.798934,
      7,
      NULL,
      2,
      0,
      1,
      1.429924,
      1,
      0,
      3.633714,
      1,
      NULL,
      2,
      1.485664,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0.186954,
      1,
      0,
      2,
      1.494859,
      1,
      NULL,
      1.579973,
      7.360596,
      6.355654,
      0,
      4,
      10,
      4,
      1.302884,
      0.132945,
      NULL,
      0.769953,
      ' 5- 7-1984',
      366.666051,
      ' 8-26-1994',
      23.359042,
      0,
      NULL,
      0.688629,
      2,
      1.626999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.288233,
      7.397875,
      0.883783,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.437344,
      2,
      NULL,
      4.180699,
      1.638394,
      2,
      3,
      3,
      1,
      7,
      0.467554,
      0.147772,
      0,
      0,
      2.031762,
      1.225468,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.105612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.648358,
      1,
      0,
      0.667817,
      NULL,
      2.783628,
      0,
      0.420418,
      0,
      NULL,
      NULL,
      NULL,
      0.803778,
      1,
      3,
      0,
      1,
      0,
      1,
      0.290078,
      NULL,
      1,
      NULL,
      0.972888,
      0,
      NULL,
      NULL,
      1,
      0.949300,
      1.920793,
      0,
      0.673206,
      0,
      0,
      0.406151,
      0,
      NULL,
      1,
      1,
      0.398046,
      1.337844,
      1,
      NULL,
      1,
      8.743642,
      1,
      5,
      NULL,
      NULL,
      2,
      NULL,
      0.476477,
      2,
      2,
      0,
      1,
      NULL,
      3.111777,
      3.528267,
      22,
      NULL,
      0.683151,
      17.871864,
      2.109342,
      0,
      2,
      NULL,
      '',
      '',
      0.673939,
      '',
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      2,
      NULL,
      31,
      21,
      1.601689,
      70.826348,
      3,
      3,
      0.713685,
      3.296689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.431786,
      NULL,
      NULL,
      3,
      1,
      0,
      0.509790,
      2.456757,
      3.533021,
      NULL,
      1.864783,
      2.542101,
      3.851082,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.595743,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.955289,
      2.742489,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633650,
      NULL,
      NULL,
      NULL,
      0.732936,
      NULL,
      0.411485,
      NULL,
      NULL,
      NULL,
      0.718508,
      NULL,
      NULL,
      1,
      1.622624,
      1,
      3.284006,
      NULL,
      1,
      2.195967,
      1.823009,
      1.077519,
      1,
      NULL,
      NULL,
      1.129270,
      1.546647,
      0.900025,
      0.996379,
      0,
      NULL,
      NULL,
      1.365281,
      NULL,
      NULL,
      0.126456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432558,
      1.594438,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.474610,
      1,
      1.865782,
      3,
      3.780452,
      2.057253,
      0.274665,
      0,
      1.537925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3.619790,
      3.474891,
      0,
      2.847269,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      0.543284,
      NULL,
      NULL,
      0.787197,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.102745,
      3.507210,
      1.151017,
      NULL,
      NULL,
      5,
      2.585191,
      5.231025,
      0,
      NULL,
      3.233424,
      3,
      NULL,
      NULL,
      NULL,
      3.018675,
      0,
      2.248728,
      0,
      0.096595,
      2.938581,
      2.283884,
      6,
      1.169158,
      NULL,
      NULL,
      0,
      NULL,
      6.470814,
      0,
      NULL,
      1.063261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.325891,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.179110,
      NULL,
      NULL,
      0.133081,
      NULL,
      NULL,
      3.241806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.261415,
      1.314709,
      NULL,
      1.807817,
      3,
      1.184220,
      NULL,
      NULL,
      3.371806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.829268,
      NULL,
      NULL,
      NULL,
      1.930489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.180016,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.796013,
      NULL,
      NULL,
      NULL,
      1.632373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030846,
      NULL,
      NULL,
      NULL,
      0.993102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782767,
      NULL,
      NULL,
      NULL,
      7.501421,
      NULL,
      NULL,
      NULL,
      0.135352,
      2.465162,
      3,
      1,
      3.448231,
      1.731579,
      1.175132,
      3,
      NULL,
      1,
      0.885094,
      NULL,
      NULL,
      2,
      8,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.132898,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0.232263,
      1.104237,
      1.309701,
      0.954290,
      0.942622,
      1.167405,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092026,
      2,
      1,
      3.372256,
      1.420195,
      0.329304,
      0,
      3,
      6,
      3.649410,
      1.207782,
      1,
      0,
      1.212311,
      NULL,
      3.999450,
      2.020527,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.472540,
      NULL,
      NULL,
      1,
      0.168034,
      NULL,
      0.596824,
      1.203655,
      NULL,
      1,
      0.425058,
      NULL,
      1.176304,
      0,
      NULL,
      0.726409,
      0.462185,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816993,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.828915,
      4,
      4.010816,
      1.015369,
      NULL,
      NULL,
      109,
      126,
      5,
      5.763128,
      1,
      '01232',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL);
commit;
end;
/


