set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '04',
      31,
      33,
      '4313110',
      3,
      NULL,
      4,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      62.286992,
      0,
      NULL,
      3.612184,
      2.317856,
      ' 9-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '10-19-2003',
      ' 7- 5-1975',
      1,
      1.276476,
      1,
      NULL,
      NULL,
      1.005129,
      2.907615,
      0,
      NULL,
      NULL,
      1.692370,
      NULL,
      5.135703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.633003,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1.575607,
      1,
      2.063520,
      1.279992,
      0.575102,
      NULL,
      NULL,
      0,
      1.425842,
      5,
      5,
      0,
      6.271197,
      0.528583,
      0.188572,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.194045,
      1,
      7.280057,
      2.437514,
      3,
      3,
      1.866309,
      1,
      0,
      0.408289,
      3,
      3.789317,
      2.131554,
      1,
      2.949928,
      3,
      0.209930,
      0.944182,
      0.308177,
      7.980473,
      1,
      2.773385,
      NULL,
      1.811746,
      4.813192,
      3.138204,
      0,
      NULL,
      NULL,
      0.911267,
      NULL,
      NULL,
      0,
      2,
      0,
      1.017446,
      2.903512,
      2.732195,
      1,
      0.309356,
      1,
      0,
      0.115882,
      NULL,
      1,
      NULL,
      0,
      0.813385,
      NULL,
      NULL,
      1,
      NULL,
      0.628559,
      4.680658,
      NULL,
      0,
      1,
      0,
      3.044899,
      0.275474,
      NULL,
      3.782048,
      NULL,
      0,
      0,
      NULL,
      3,
      1,
      9.650478,
      5,
      2,
      NULL,
      1.565110,
      6.167437,
      7.846131,
      3,
      5,
      9.697485,
      0,
      2.997570,
      ' 9-14-1987',
      99,
      ' 1-12-1996',
      58,
      3,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780289,
      1.215719,
      0.127037,
      8.613107,
      NULL,
      1.957541,
      1.099192,
      0.453553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.740061,
      0.332703,
      7.063994,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396520,
      1.382359,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277250,
      NULL,
      1.171929,
      0.359982,
      NULL,
      0,
      1,
      1,
      6.911863,
      1.479508,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.063769,
      3,
      1.542747,
      0.300235,
      1,
      NULL,
      3,
      0,
      0,
      3,
      1,
      0,
      0,
      2,
      NULL,
      1,
      0.258136,
      0,
      NULL,
      0,
      0,
      0,
      0.143635,
      1,
      0,
      0.328994,
      0,
      1,
      1,
      1,
      0,
      NULL,
      11,
      NULL,
      1.693859,
      2,
      4,
      NULL,
      1,
      4.622833,
      0,
      NULL,
      NULL,
      21.726630,
      2.741082,
      0.455155,
      29.592457,
      NULL,
      9,
      58.802406,
      NULL,
      2,
      0.219729,
      '44424',
      '',
      '',
      1.121452,
      '',
      '',
      '',
      0.813142,
      '',
      '',
      '',
      NULL,
      9.253094,
      2.240160,
      15,
      1.173040,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.810928,
      2.764634,
      0.548531,
      1.904962,
      NULL,
      NULL,
      2.707724,
      0.625808,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      2.432581,
      3.306428,
      1.360276,
      0.788930,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      6.909898,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.571902,
      3.338837,
      3.336933,
      2,
      1.262121,
      NULL,
      2.818910,
      2,
      2,
      1.966943,
      2.980877,
      NULL,
      NULL,
      0,
      0.019178,
      NULL,
      2,
      2,
      3,
      1,
      NULL,
      2,
      1.211325,
      2.151893,
      0.043029,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.365567,
      2.600084,
      1,
      1,
      NULL,
      0.398977,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.034888,
      NULL,
      NULL,
      NULL,
      0.443116,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1.156213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.509050,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.454390,
      NULL,
      NULL,
      3.023973,
      NULL,
      NULL,
      0.539465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.486038,
      0.025708,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3.048618,
      NULL,
      NULL,
      1,
      0.383852,
      7.041798,
      NULL,
      3.239515,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.486379,
      0.678982,
      NULL,
      1.883770,
      0.858577,
      NULL,
      2,
      0,
      3,
      1.019090,
      0.577610,
      3.346597,
      2,
      0,
      NULL,
      2.005921,
      0.756668,
      6.607946,
      9,
      0,
      5,
      7.857639,
      2,
      1.475103,
      NULL,
      6.273245,
      NULL,
      1.523058,
      0.179403,
      1,
      0,
      0.566947,
      NULL,
      NULL,
      0.554881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.177142,
      NULL,
      NULL,
      0.998963,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6.255096,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0.945331,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962408,
      NULL,
      NULL,
      NULL,
      1.250482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510632,
      NULL,
      NULL,
      NULL,
      1.073532,
      3,
      NULL,
      0.417927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886190,
      NULL,
      NULL,
      1.422369,
      NULL,
      NULL,
      0.288111,
      NULL,
      NULL,
      1.733439,
      NULL,
      1.632598,
      54,
      5,
      0.805563,
      1.371601,
      0.566378,
      1.980730,
      1.693214,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1.119601,
      0.003398,
      1,
      1.008811,
      NULL,
      2.234249,
      NULL,
      1.848409,
      NULL,
      NULL,
      NULL,
      1.981860,
      NULL,
      2,
      NULL,
      2,
      NULL,
      15,
      NULL,
      NULL,
      10.479020,
      24.411343,
      0,
      0.477100,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.179402,
      NULL,
      0,
      NULL,
      0.237936,
      NULL,
      0,
      NULL,
      0.746636,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.455528,
      NULL,
      1.903698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335891,
      1.463130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.845723,
      NULL,
      1,
      NULL,
      2.114499,
      NULL,
      223,
      NULL,
      1.235815,
      NULL,
      1.283468,
      NULL,
      0.895073,
      NULL,
      0,
      1.751376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132447,
      NULL,
      NULL,
      1.299701,
      NULL,
      NULL,
      NULL,
      243,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.320587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.906160,
      14,
      NULL,
      NULL,
      1.845917,
      3,
      3,
      3.838313,
      1,
      NULL,
      0.017060,
      NULL,
      1.553123,
      2.940962,
      4.496100,
      NULL,
      3.121658,
      1,
      NULL,
      0,
      1.601131,
      NULL,
      0.885359,
      1.402514,
      NULL,
      1,
      0.124475,
      NULL,
      1.708244,
      1.860265,
      NULL,
      1.767893,
      1.107300,
      NULL,
      1.867934,
      1.734792,
      NULL,
      1,
      1.452510,
      NULL,
      1.698431,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.792444,
      0.355625,
      NULL,
      0.519261,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      7.131816,
      1,
      NULL,
      NULL,
      70,
      NULL,
      4.219378,
      0.378228,
      1,
      '22133',
      '31133',
      '',
      1.772105,
      '',
      NULL,
      NULL,
      0.012902,
      '',
      '',
      NULL);
commit;
end;
/


