set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710248';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.813072,
      3,
      2.645361,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      15.320479,
      '2202410',
      3.058588,
      NULL,
      1,
      3,
      '1001',
      3,
      1.590760,
      NULL,
      NULL,
      '10-11-1993',
      38,
      NULL,
      NULL,
      0,
      0,
      ' 0-12-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      0.658062,
      ' 1- 2-1979',
      ' 7-13-1998',
      ' 2-24-2003',
      3.726725,
      0.138132,
      1,
      1,
      1,
      0,
      0.713881,
      2.069810,
      NULL,
      NULL,
      NULL,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.399288,
      2.623978,
      1,
      1.968590,
      1.877861,
      0,
      0,
      0.324418,
      1.961775,
      1.045514,
      NULL,
      NULL,
      0,
      1.410949,
      1.264003,
      1,
      6.573665,
      NULL,
      3.163131,
      NULL,
      1,
      0.108764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      5.574696,
      3,
      NULL,
      NULL,
      3.176134,
      3.983874,
      0.014949,
      3.511301,
      1.868930,
      1.028655,
      0.409321,
      2.502899,
      0,
      NULL,
      0,
      1,
      0.872214,
      3,
      0,
      1,
      NULL,
      NULL,
      4,
      1.351514,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.873265,
      5.824118,
      4.989536,
      1.901272,
      0,
      NULL,
      0,
      1,
      1.610240,
      1,
      0.543729,
      NULL,
      1.483784,
      1.184247,
      1,
      1.619924,
      NULL,
      0.468533,
      NULL,
      NULL,
      1,
      5.550069,
      1,
      1.244773,
      3,
      1.687119,
      7.163695,
      1.422270,
      0.917162,
      1,
      1.355579,
      6,
      1.996986,
      3,
      4.787612,
      5.407215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      6.403266,
      4.923355,
      1,
      0,
      3,
      ' 5-15-2000',
      267.669276,
      ' 1-24-1988',
      19.195521,
      3.495186,
      1,
      0,
      5.613326,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325448,
      1.742647,
      0,
      5.660495,
      0.744099,
      1.858831,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.505718,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.953938,
      NULL,
      NULL,
      NULL,
      1.656291,
      0,
      11,
      5.024905,
      6,
      3.506279,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6.040692,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.313420,
      NULL,
      NULL,
      0.516865,
      NULL,
      NULL,
      7.432906,
      0.733269,
      0.843679,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630256,
      3.566876,
      1.577001,
      3.829190,
      1.285276,
      0.716053,
      1.215258,
      0,
      2.592488,
      1.172812,
      1,
      1.990419,
      NULL,
      3.209878,
      NULL,
      0,
      1.225178,
      1.440065,
      1.310683,
      1.435258,
      0,
      1,
      NULL,
      1,
      1.823111,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      8,
      9.007200,
      6.653313,
      0.600418,
      1,
      4,
      0.040511,
      3,
      3.239569,
      NULL,
      3.376937,
      1,
      10.879400,
      NULL,
      1.640821,
      15,
      NULL,
      26,
      7.414782,
      NULL,
      2.640056,
      1.753768,
      NULL,
      '',
      '',
      0.506821,
      '',
      '',
      '',
      1,
      '34243',
      NULL,
      '',
      NULL,
      18.338059,
      77,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094448,
      2.008935,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.064111,
      1.272447,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.025950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.429091,
      5,
      6.971600,
      0.181897,
      1,
      NULL,
      NULL,
      NULL,
      1.507729,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.520111,
      0.065846,
      3,
      3,
      1,
      1,
      2.615753,
      NULL,
      0,
      1.069405,
      3.969101,
      1,
      NULL,
      1.644156,
      1,
      1,
      0.089501,
      1.637155,
      NULL,
      1,
      0.718973,
      0,
      1.958004,
      3.349824,
      0,
      2,
      0.914745,
      NULL,
      NULL,
      3,
      2.270568,
      2,
      0.936563,
      NULL,
      3,
      1.248798,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.406455,
      3.649102,
      2.176597,
      1.951600,
      NULL,
      NULL,
      3.786433,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.602820,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.683235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.684855,
      1.143789,
      2.564043,
      1.047828,
      NULL,
      NULL,
      3.209717,
      NULL,
      0.815959,
      8,
      7.302819,
      7.015589,
      NULL,
      1,
      0,
      1,
      0,
      0.033726,
      NULL,
      0,
      1,
      NULL,
      3.100437,
      NULL,
      4,
      NULL,
      3.228681,
      3,
      NULL,
      2,
      3.651171,
      3.020264,
      2,
      3,
      NULL,
      0,
      1.964454,
      2.053029,
      2.196139,
      3,
      8,
      NULL,
      6,
      NULL,
      1,
      0,
      NULL,
      7.879981,
      1,
      1.357072,
      0,
      0.625685,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.298806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.468237,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.695566,
      NULL,
      NULL,
      NULL,
      3.038623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.372875,
      NULL,
      NULL,
      NULL,
      2.988250,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.597282,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.943734,
      2.981996,
      1,
      3,
      NULL,
      0.786802,
      1,
      NULL,
      NULL,
      NULL,
      1.105810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.488091,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960721,
      19.788344,
      3,
      0,
      1,
      0.442529,
      1.375460,
      0,
      1,
      NULL,
      0.801898,
      0,
      0.715027,
      1.123920,
      3.354521,
      NULL,
      1.192023,
      1.083517,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.823593,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3.344898,
      39,
      22.332222,
      1.155042,
      2,
      3,
      NULL,
      0.061218,
      NULL,
      NULL,
      NULL,
      0.071602,
      NULL,
      0.894462,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.900804,
      NULL,
      0,
      NULL,
      0.526484,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.853405,
      5,
      5,
      NULL,
      4.477940,
      0.505221,
      0,
      3.766683,
      11.040601,
      1,
      1.562991,
      1.988647,
      1,
      1.102435,
      NULL,
      0.613644,
      2,
      NULL,
      NULL,
      1.087180,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.513247,
      NULL,
      3.177146,
      3,
      NULL,
      3,
      3.272296,
      NULL,
      1,
      0.350178,
      NULL,
      0,
      1,
      NULL,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      13.208396,
      NULL,
      NULL,
      1,
      2,
      6,
      NULL,
      5,
      0,
      2.099393,
      '02121',
      '24443',
      NULL,
      1,
      '',
      '',
      '',
      0.350543,
      '32023',
      '',
      '');
commit;
end;
/


