set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3,
      5.017601,
      0,
      0,
      1.058740,
      2.387810,
      0.310050,
      '24',
      NULL,
      32,
      24,
      '1121422',
      2,
      0.225959,
      2,
      1,
      '4413',
      0,
      0,
      NULL,
      NULL,
      '10- 0-2002',
      13,
      44.400423,
      NULL,
      1,
      9,
      ' 0- 0-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 5-28-1996',
      ' 3-23-1989',
      1,
      2.565403,
      1,
      NULL,
      0,
      1,
      10.893714,
      0.281082,
      1,
      12,
      9,
      18,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.177095,
      NULL,
      5,
      0.876434,
      1.782673,
      NULL,
      0,
      6.253294,
      9,
      NULL,
      1,
      0,
      0.426808,
      0,
      6.039053,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.773710,
      NULL,
      0,
      0.724864,
      1,
      2,
      NULL,
      0.480756,
      3,
      2.968855,
      NULL,
      0,
      2.386044,
      1.418255,
      1.242958,
      2,
      2,
      2.559548,
      0.458265,
      1,
      0.010323,
      9,
      1,
      0.397420,
      3,
      0.895159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.947175,
      1,
      NULL,
      1.135823,
      1,
      0.600309,
      1.684033,
      0,
      0,
      1,
      1.957319,
      NULL,
      1.656748,
      0.889273,
      0.803752,
      1,
      1.579454,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1.861798,
      1,
      0.184811,
      2.213255,
      0.074907,
      2,
      6.795153,
      3,
      1.920204,
      0.703667,
      0,
      5,
      0,
      9,
      NULL,
      2,
      5,
      11.592126,
      NULL,
      9.326631,
      3,
      2.677281,
      0.417990,
      NULL,
      ' 0- 2-1984',
      NULL,
      '11-14-1977',
      34.554279,
      0.641144,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.856191,
      0.914100,
      1,
      0,
      NULL,
      1.494270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.816387,
      0.699750,
      2,
      1,
      2,
      0,
      0,
      3.111172,
      3.915812,
      0,
      1,
      6.325101,
      0.817527,
      NULL,
      NULL,
      NULL,
      NULL,
      4.675797,
      0.136649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.523528,
      NULL,
      1,
      1,
      0.910248,
      2,
      23,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.146561,
      1.879611,
      NULL,
      3,
      NULL,
      1.762167,
      2,
      3,
      2,
      0,
      3.428724,
      NULL,
      0,
      3.690686,
      3,
      2.657538,
      1.331499,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.337127,
      0.957425,
      4.291065,
      1,
      1,
      3,
      0.400534,
      NULL,
      NULL,
      3,
      NULL,
      6,
      0.560333,
      2.951122,
      NULL,
      NULL,
      0.879137,
      6,
      0.832178,
      NULL,
      3.190276,
      29,
      3,
      2.376201,
      62.305472,
      NULL,
      40,
      16,
      NULL,
      3.895329,
      2,
      '33411',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.802737,
      '',
      '',
      '',
      1.790162,
      9,
      13,
      28,
      0.230866,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597833,
      0.821563,
      1.879629,
      1.188598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401990,
      NULL,
      NULL,
      0,
      3,
      2,
      1.117252,
      NULL,
      0,
      3,
      3.164241,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.784841,
      NULL,
      NULL,
      7.484533,
      NULL,
      NULL,
      0.335623,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663185,
      1,
      3.771311,
      NULL,
      2.252796,
      NULL,
      0,
      1.244541,
      0.931640,
      0,
      3,
      1,
      1,
      1,
      3.377745,
      1,
      NULL,
      2.979759,
      0.174998,
      NULL,
      0,
      NULL,
      0.350310,
      NULL,
      3,
      3,
      0.687049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.208919,
      1.560495,
      0.039847,
      NULL,
      NULL,
      NULL,
      1.711044,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396364,
      NULL,
      NULL,
      1.594827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.748175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927298,
      NULL,
      NULL,
      0.095245,
      NULL,
      NULL,
      1.970671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.621925,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      2,
      3,
      2,
      3,
      NULL,
      3,
      4,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3.921082,
      NULL,
      NULL,
      NULL,
      2.233321,
      2,
      NULL,
      NULL,
      9,
      0,
      5.573329,
      3,
      NULL,
      2.935488,
      2.731482,
      1,
      0.057475,
      NULL,
      1,
      1,
      0.318344,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.657413,
      NULL,
      NULL,
      0.805350,
      NULL,
      NULL,
      0.385793,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081058,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.956839,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.462224,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289008,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.265039,
      1.007560,
      NULL,
      3.144529,
      1.364617,
      NULL,
      NULL,
      NULL,
      0.642134,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.722998,
      NULL,
      0.436665,
      363.480473,
      NULL,
      1,
      1,
      0.490792,
      0.005671,
      0.238149,
      0,
      NULL,
      0.015520,
      1.191092,
      1,
      1,
      1,
      1.775349,
      NULL,
      0,
      1.603170,
      1.664419,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.968430,
      1,
      0.523292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.679105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258481,
      1.350866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780224,
      0.868811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736900,
      1.289288,
      NULL,
      NULL,
      NULL,
      1.058687,
      NULL,
      49,
      NULL,
      1.520917,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5.218808,
      4.403485,
      3.384297,
      1,
      1.514870,
      0.237988,
      1,
      2.450683,
      0.184332,
      1,
      0.378255,
      0.602215,
      1.021757,
      1,
      1,
      NULL,
      3,
      1.045400,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238741,
      NULL,
      NULL,
      0,
      NULL,
      0.908275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.705261,
      0,
      NULL,
      0.278626,
      NULL,
      NULL,
      NULL,
      1.148159,
      NULL,
      1,
      1.988981,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.566391,
      NULL,
      6,
      5.225299,
      1,
      0,
      NULL,
      NULL,
      42.414969,
      113,
      NULL,
      0.575318,
      2,
      '41301',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3.727733,
      '3132',
      '',
      '');
commit;
end;
/


