set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9423680';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.787701,
      4.078248,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '402',
      NULL,
      1.785004,
      17.043819,
      NULL,
      1.034594,
      1.972978,
      2,
      1,
      '0040',
      1,
      1.121877,
      NULL,
      NULL,
      ' 6-16-1991',
      93.844929,
      56.970430,
      NULL,
      0,
      1.397404,
      ' 2- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1998',
      0.429840,
      NULL,
      NULL,
      NULL,
      0,
      1.528905,
      3,
      2.187893,
      NULL,
      NULL,
      NULL,
      11,
      3.828734,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255848,
      3.116596,
      NULL,
      0,
      1.287319,
      0,
      1.490054,
      0,
      NULL,
      NULL,
      NULL,
      1.025417,
      0,
      0,
      3.293845,
      0.324144,
      6,
      1.214515,
      1.481335,
      NULL,
      5,
      0.516778,
      4,
      1,
      9.924887,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      4.215543,
      0,
      0,
      0,
      NULL,
      NULL,
      1.655033,
      NULL,
      NULL,
      4.372575,
      5,
      2,
      1.919955,
      2,
      0.333126,
      1.774818,
      1.538115,
      1,
      1.344893,
      NULL,
      2.960698,
      0,
      NULL,
      1.696431,
      2.169764,
      NULL,
      0.353735,
      0.241540,
      0.436974,
      NULL,
      2.536775,
      0,
      NULL,
      NULL,
      0.052137,
      1.733310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842282,
      0.770995,
      1.784119,
      1.102099,
      0.661107,
      3,
      0.114546,
      0.759322,
      0,
      2,
      NULL,
      1.494844,
      NULL,
      3,
      NULL,
      1,
      1,
      0.043231,
      0.248009,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      0.044294,
      3,
      2.001479,
      0.826079,
      0,
      0.718087,
      1,
      1.589485,
      0,
      0.023775,
      NULL,
      8,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.516412,
      0,
      0.884170,
      1,
      0,
      NULL,
      ' 2-13-1991',
      184.871904,
      ' 2- 8-1993',
      201.079804,
      NULL,
      1.140033,
      1.327684,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.697144,
      NULL,
      1,
      1.226703,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543545,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.306005,
      NULL,
      0,
      NULL,
      NULL,
      1.037383,
      NULL,
      0.351941,
      2.548642,
      NULL,
      0.554181,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560898,
      1.699413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.145459,
      1,
      NULL,
      NULL,
      0.933298,
      0,
      1.092535,
      1,
      NULL,
      2.935073,
      NULL,
      NULL,
      NULL,
      NULL,
      3.101409,
      0,
      0,
      0.270414,
      0,
      1,
      0,
      2.250229,
      3.015532,
      3,
      0.538950,
      1.291991,
      NULL,
      3.171150,
      2,
      3,
      2.056974,
      NULL,
      NULL,
      5.483669,
      NULL,
      0,
      1.978398,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      3,
      10,
      NULL,
      NULL,
      1,
      6,
      1.738460,
      0.418949,
      4.213165,
      NULL,
      3.486721,
      NULL,
      36,
      3.267864,
      0,
      15.170003,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.407593,
      '00341',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      3,
      13,
      7,
      22,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      1.634246,
      1.273201,
      NULL,
      NULL,
      1.582255,
      3.258245,
      NULL,
      0.812551,
      NULL,
      NULL,
      2,
      1,
      0.665209,
      NULL,
      0,
      1.392888,
      3,
      NULL,
      NULL,
      3.832355,
      2.096940,
      1.471212,
      2,
      3,
      3,
      0,
      3.171620,
      NULL,
      7.210245,
      7.939004,
      NULL,
      0.020181,
      1.294991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.844760,
      1,
      NULL,
      2.528304,
      NULL,
      0.786260,
      2,
      3,
      1.345750,
      NULL,
      NULL,
      0.395748,
      3,
      1,
      0.496346,
      0.823437,
      0.117371,
      0,
      0,
      0.539493,
      0.804657,
      0,
      0.937950,
      NULL,
      3,
      0.793381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372540,
      2.460371,
      1,
      NULL,
      7,
      1.674927,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.849194,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.752385,
      3,
      0,
      NULL,
      0,
      0,
      0.015767,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.985988,
      NULL,
      NULL,
      1.872710,
      NULL,
      NULL,
      1.927176,
      NULL,
      NULL,
      1.293420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.058854,
      NULL,
      1.740257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.768856,
      5.716123,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.278447,
      0.264377,
      NULL,
      2,
      0.804700,
      2.239832,
      6,
      9,
      8,
      0.211591,
      3,
      1,
      NULL,
      1.521719,
      2.047844,
      1.097737,
      3.938881,
      1.239688,
      0.261563,
      2.959657,
      0,
      6,
      9,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470521,
      NULL,
      1,
      0,
      0.925073,
      0,
      1.863657,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348430,
      NULL,
      NULL,
      1.661457,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.756451,
      1,
      0,
      1.084446,
      1.738573,
      2.314586,
      0.095716,
      NULL,
      NULL,
      4.553758,
      NULL,
      NULL,
      NULL,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058056,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.466493,
      NULL,
      NULL,
      NULL,
      1.904593,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.080536,
      NULL,
      NULL,
      NULL,
      1.691063,
      NULL,
      NULL,
      NULL,
      6.564552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.795023,
      0,
      1,
      NULL,
      NULL,
      1.475043,
      NULL,
      NULL,
      1.086239,
      NULL,
      NULL,
      0.754050,
      NULL,
      NULL,
      1.676974,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.086543,
      NULL,
      1,
      1.683759,
      1,
      1.745792,
      0.388148,
      1,
      NULL,
      1,
      1.434113,
      1,
      1.228960,
      0,
      0.257761,
      1.029189,
      NULL,
      0.388412,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.026859,
      NULL,
      1.966675,
      1,
      NULL,
      1.612825,
      1.432193,
      3.015550,
      NULL,
      1.672572,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.222541,
      NULL,
      NULL,
      0,
      0.600190,
      NULL,
      1,
      0.937770,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.346077,
      NULL,
      0.968111,
      0.967496,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.243415,
      NULL,
      0,
      NULL,
      NULL,
      0.612374,
      1.579720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.363323,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3.822796,
      0.597954,
      NULL,
      NULL,
      65,
      127,
      2.454474,
      1.059613,
      3.912186,
      '10203',
      '',
      NULL,
      1,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


