set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1,
      0,
      0.376344,
      3.517770,
      2,
      3,
      NULL,
      '111',
      '04022340',
      14.409407,
      NULL,
      '2420404',
      1,
      0,
      NULL,
      0,
      '0234',
      1,
      NULL,
      NULL,
      NULL,
      '11-24-1987',
      22.191541,
      39.977860,
      NULL,
      0,
      1.822974,
      ' 1- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10-18-1976',
      ' 6-25-1987',
      ' 1- 6-1976',
      1,
      0.790417,
      1.572688,
      0,
      1,
      0.782332,
      NULL,
      2.235545,
      NULL,
      NULL,
      NULL,
      NULL,
      7.084207,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.791572,
      NULL,
      1,
      0.819231,
      NULL,
      NULL,
      NULL,
      1,
      1.357445,
      NULL,
      NULL,
      1.749032,
      1,
      1,
      NULL,
      0,
      2.855632,
      6,
      0,
      0,
      NULL,
      2,
      9,
      9.714801,
      3.493255,
      5.746999,
      NULL,
      1.478788,
      1,
      0.355694,
      3.631781,
      3.642134,
      0,
      1.523802,
      1.847668,
      NULL,
      NULL,
      0.004093,
      NULL,
      NULL,
      NULL,
      3,
      3.729884,
      3,
      1,
      1,
      2,
      2,
      NULL,
      1.405739,
      2.366910,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      3.732315,
      0.831897,
      0.388205,
      0,
      0.606887,
      NULL,
      1.296906,
      1.828869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.531443,
      NULL,
      3,
      1.555345,
      5.181956,
      0,
      0.053387,
      1,
      0,
      4,
      1,
      3,
      3.230905,
      0.742381,
      1.603023,
      0.373816,
      NULL,
      NULL,
      1.059513,
      0.771873,
      2.279938,
      1.622363,
      0,
      0,
      3.450322,
      3.782995,
      0.766077,
      0.488257,
      0.679593,
      5,
      0.624808,
      4,
      0,
      NULL,
      0.478858,
      NULL,
      2.865777,
      0,
      1.381393,
      3.987052,
      3.103008,
      NULL,
      0,
      3,
      0,
      1,
      ' 8-24-2003',
      2,
      '11-20-1995',
      32.562401,
      2.133433,
      0.710778,
      1.437607,
      3.066047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106815,
      0.619502,
      NULL,
      1.243299,
      0,
      1.440947,
      6.870807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.613889,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      2,
      6,
      6.341641,
      6.771352,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.152817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.266030,
      1.167146,
      0,
      NULL,
      0,
      0.447705,
      0.748484,
      0.724599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.492131,
      0.144360,
      3,
      3,
      3,
      1.025951,
      2.571138,
      3,
      2,
      2.654168,
      0,
      1,
      3.824866,
      2,
      0.972840,
      1.706461,
      NULL,
      1,
      1.672708,
      0.021125,
      0,
      0,
      1,
      0,
      1.294815,
      0,
      NULL,
      3.979761,
      3.905551,
      0,
      7.033450,
      4,
      0,
      0.323650,
      9,
      0,
      1.321627,
      3,
      NULL,
      NULL,
      0,
      0,
      39.099974,
      3.271389,
      0,
      37.171015,
      NULL,
      38,
      39.874391,
      3,
      NULL,
      5.708133,
      '24023',
      '23320',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '41210',
      NULL,
      '',
      0.932301,
      0,
      63,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.241654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478605,
      NULL,
      NULL,
      0.041819,
      NULL,
      NULL,
      0.138401,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.006229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.827841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.506826,
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      6.215972,
      3.636032,
      0,
      0.930400,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.518682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.462801,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.934098,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.625879,
      NULL,
      NULL,
      0.923205,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.753465,
      0,
      7.402995,
      NULL,
      NULL,
      3.525876,
      3,
      2,
      1.863840,
      NULL,
      NULL,
      2,
      1.781707,
      3.789202,
      1.174787,
      0.145330,
      1,
      7,
      4,
      2.964565,
      1,
      5.513587,
      NULL,
      0.399213,
      NULL,
      NULL,
      1.228073,
      0.976279,
      1,
      1.326956,
      1.556008,
      0.298209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.712125,
      1.898842,
      0.575122,
      0.660536,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.051046,
      NULL,
      NULL,
      1.900746,
      NULL,
      0.208810,
      1,
      3,
      0.031065,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504318,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.015596,
      NULL,
      1,
      142,
      3,
      3.819234,
      1.373492,
      1.444327,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      0.751965,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.606099,
      NULL,
      1,
      NULL,
      0.233682,
      NULL,
      2.779301,
      NULL,
      3,
      NULL,
      61,
      NULL,
      NULL,
      NULL,
      22.125344,
      NULL,
      2.897209,
      3,
      1,
      NULL,
      NULL,
      0.362881,
      NULL,
      1.596381,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.968411,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.718304,
      NULL,
      1,
      NULL,
      2.619286,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669328,
      NULL,
      NULL,
      1,
      NULL,
      1.244133,
      NULL,
      NULL,
      NULL,
      1.982392,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.425801,
      1.948200,
      1.981626,
      NULL,
      3.156608,
      NULL,
      221,
      NULL,
      1,
      NULL,
      0.588891,
      NULL,
      0,
      NULL,
      1.644649,
      NULL,
      0.815740,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.617354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859496,
      NULL,
      1.161890,
      3,
      NULL,
      0,
      NULL,
      526.472312,
      NULL,
      2.940420,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      1,
      NULL,
      1.083479,
      1,
      1,
      1,
      1,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1.715256,
      NULL,
      NULL,
      1.812180,
      NULL,
      0,
      1.332065,
      NULL,
      0,
      0.135879,
      NULL,
      1,
      1.218851,
      NULL,
      1.798555,
      0,
      NULL,
      0.073532,
      1.695244,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.551247,
      NULL,
      1,
      1,
      NULL,
      1.038505,
      1.454113,
      0.186393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.110715,
      NULL,
      1.090880,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.425694,
      1.136493,
      7,
      NULL,
      NULL,
      '03131',
      1.658517,
      '',
      '',
      '',
      NULL,
      '04100',
      '',
      '');
commit;
end;
/


