set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678720';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      NULL,
      26,
      22,
      '0124111',
      NULL,
      1.777204,
      0,
      NULL,
      '3133',
      2,
      1.215907,
      NULL,
      NULL,
      ' 4- 4-1995',
      139,
      20,
      NULL,
      0.704259,
      0,
      ' 3- 6-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.670653,
      1.045863,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      1,
      15.663748,
      2.084846,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981635,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      0,
      NULL,
      1.449923,
      NULL,
      1.026936,
      0,
      1.283950,
      1.396224,
      3,
      NULL,
      0.541476,
      1,
      1,
      1.220396,
      0.158488,
      1.786966,
      9.831508,
      1,
      1,
      NULL,
      0.868037,
      NULL,
      NULL,
      9,
      0,
      5,
      1,
      2.531200,
      1.848001,
      NULL,
      NULL,
      NULL,
      1.656770,
      5,
      NULL,
      9.815298,
      1.699424,
      3.383899,
      0,
      1.882716,
      2.018335,
      0,
      0.358624,
      3.015400,
      0.488074,
      2.815899,
      1.659218,
      0,
      1.188552,
      3.731148,
      1.728201,
      2,
      1.797379,
      0.440822,
      7.892607,
      NULL,
      NULL,
      1.420890,
      1.230668,
      4,
      1,
      NULL,
      NULL,
      1.940147,
      NULL,
      0,
      0,
      4,
      1.041253,
      1,
      1.446827,
      NULL,
      0,
      1,
      1,
      0,
      0.304412,
      1.781160,
      1,
      0,
      1,
      1,
      0.657271,
      0,
      0,
      NULL,
      2.900098,
      6.106784,
      0,
      2,
      3,
      1,
      8,
      5.246078,
      1,
      7.359297,
      NULL,
      1,
      0,
      1,
      0.835067,
      NULL,
      0.123430,
      3,
      2.566217,
      2.109477,
      4.802628,
      8,
      NULL,
      9.995171,
      2.940496,
      3.330402,
      NULL,
      3,
      ' 0-15-1986',
      11,
      ' 1-21-2000',
      7.900731,
      1.618812,
      2.902759,
      4.901358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237383,
      0.874881,
      0.862913,
      1,
      1.130168,
      4,
      1.487283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537538,
      NULL,
      4,
      2,
      1,
      NULL,
      1.639235,
      0,
      NULL,
      2,
      1.735254,
      7,
      1.631393,
      1.406782,
      NULL,
      NULL,
      NULL,
      1,
      7.873141,
      1.390791,
      2.002093,
      0,
      8,
      7.269234,
      NULL,
      NULL,
      NULL,
      1.921187,
      NULL,
      1.187022,
      1.238723,
      5.011066,
      6.076355,
      5.522212,
      ' 0-25-1979',
      26,
      NULL,
      NULL,
      0,
      NULL,
      5,
      2.969699,
      2,
      1.178877,
      0,
      1,
      1.307602,
      0.467034,
      0,
      NULL,
      1,
      1.105877,
      NULL,
      NULL,
      NULL,
      3.110153,
      1.245927,
      1.240614,
      3,
      3,
      2.332464,
      3.144144,
      3,
      NULL,
      1,
      2.516679,
      NULL,
      NULL,
      2,
      3.265703,
      1,
      3,
      0,
      0.508343,
      3,
      1.634431,
      NULL,
      0,
      0.908054,
      0.816098,
      NULL,
      1,
      0.744148,
      NULL,
      0.219523,
      1.947636,
      1.380534,
      9.934878,
      3.054377,
      2.698118,
      2.038303,
      8.561844,
      2.969559,
      4,
      2.245766,
      NULL,
      0.962372,
      1.912139,
      NULL,
      52,
      3,
      1,
      NULL,
      NULL,
      18.146602,
      66,
      4.133847,
      5,
      0.680057,
      '40244',
      '33024',
      '',
      1.895026,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1.576436,
      17,
      5.048634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.612708,
      5.052369,
      2,
      3.813444,
      0,
      1.051268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.487020,
      NULL,
      1.171518,
      192.558412,
      3.355059,
      1,
      1,
      1.901805,
      0.364952,
      0.270897,
      1.643317,
      NULL,
      NULL,
      0.969050,
      0.576170,
      NULL,
      NULL,
      1.575392,
      1.851728,
      1.608945,
      NULL,
      NULL,
      1.639759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.228560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.319329,
      NULL,
      3.687568,
      NULL,
      3,
      NULL,
      9.186731,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.455234,
      0.657417,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643630,
      2,
      NULL,
      0.815613,
      NULL,
      1.828203,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.003167,
      NULL,
      3,
      24.614747,
      17.807430,
      0.673092,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.778873,
      4.255386,
      NULL,
      1.151951,
      0,
      1.578684,
      4,
      3.059425,
      1.231813,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.173502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.799172,
      3,
      NULL,
      0,
      1.386785,
      NULL,
      0.628483,
      1.753795,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.504533,
      NULL,
      3,
      2,
      NULL,
      0,
      1.539711,
      NULL,
      2,
      0,
      1.754029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0.610419,
      NULL,
      NULL,
      65,
      17,
      NULL,
      5.094753,
      5.135461,
      '33111',
      NULL,
      '',
      0.936710,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


