set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908405';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      '0210',
      2,
      1.823859,
      NULL,
      NULL,
      ' 2-22-1983',
      24.895657,
      NULL,
      NULL,
      2,
      0,
      NULL,
      24,
      1,
      328,
      89,
      NULL,
      ' 0-26-2002',
      '10- 3-1989',
      ' 7-22-1975',
      2,
      NULL,
      NULL,
      1.740710,
      1.910510,
      2.226764,
      3,
      1.304660,
      NULL,
      5.355685,
      4,
      NULL,
      NULL,
      14,
      23,
      2.677522,
      22,
      2,
      0,
      1.270303,
      1,
      NULL,
      1,
      0.528168,
      1,
      NULL,
      1.444895,
      1,
      0,
      1.936994,
      118,
      5.542477,
      NULL,
      0,
      3.517984,
      6,
      NULL,
      5,
      8,
      0.035102,
      6.574613,
      5,
      1.324065,
      1.007634,
      0.041284,
      2.465996,
      NULL,
      4.964845,
      0.793989,
      NULL,
      NULL,
      NULL,
      1.796557,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4.430261,
      3,
      2,
      0,
      0.315325,
      1,
      1.526106,
      1.227223,
      NULL,
      3,
      0,
      NULL,
      1.464191,
      NULL,
      0,
      0,
      2,
      NULL,
      3.333480,
      1.682009,
      NULL,
      NULL,
      NULL,
      3,
      1.321664,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      2.857946,
      0.476523,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1.392531,
      0,
      NULL,
      2,
      0,
      0.987158,
      0,
      0,
      NULL,
      NULL,
      0.810596,
      8,
      0.363934,
      1,
      2,
      0.360893,
      5,
      9.502843,
      0.995888,
      10.069688,
      4.779322,
      NULL,
      NULL,
      5,
      0,
      NULL,
      4.476561,
      0.534221,
      NULL,
      NULL,
      3,
      NULL,
      11.101093,
      6,
      11,
      8,
      4.870226,
      NULL,
      ' 0-25-1978',
      1206,
      ' 2-26-1988',
      818,
      3.418317,
      2.807269,
      0.461288,
      4,
      0.143926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456578,
      1,
      NULL,
      NULL,
      1,
      5.063184,
      1,
      0.036113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166738,
      1.550894,
      1.173741,
      NULL,
      NULL,
      NULL,
      0.487800,
      4,
      0,
      0,
      0,
      3,
      1.590443,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      0.673028,
      1,
      3,
      NULL,
      0.470372,
      1.271557,
      NULL,
      NULL,
      NULL,
      1,
      1.373743,
      3.367560,
      3.370512,
      1.995935,
      0,
      2,
      1,
      NULL,
      2.867119,
      NULL,
      0.964900,
      0,
      3,
      1,
      1.021225,
      NULL,
      0,
      0.971043,
      4.024775,
      0.486485,
      1,
      NULL,
      1,
      1.921000,
      NULL,
      0,
      1.800146,
      0,
      NULL,
      2,
      0.460837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      34.048199,
      13,
      72.356951,
      3,
      1,
      4.211869,
      '12013',
      '20020',
      '',
      1.368932,
      '',
      '',
      NULL,
      2.578621,
      '43422',
      '',
      '',
      0.447624,
      26.782831,
      395.907502,
      12.483273,
      2,
      18,
      41.739522,
      53,
      7,
      3,
      1,
      1.835556,
      0,
      NULL,
      NULL,
      3,
      1.747093,
      1.521516,
      3,
      1,
      3,
      3.128220,
      0,
      0,
      0,
      NULL,
      3.974533,
      1.378912,
      0.080025,
      2,
      1,
      1.736532,
      0.940182,
      0.381443,
      NULL,
      2.650027,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.769984,
      0,
      NULL,
      NULL,
      8.112119,
      4,
      1,
      1,
      0.716555,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.417142,
      1.202989,
      0.442927,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      1,
      3,
      3.881593,
      0,
      2.762144,
      2,
      1.522611,
      0.467351,
      3,
      2.025841,
      NULL,
      NULL,
      1.867658,
      1.355907,
      0.301759,
      NULL,
      NULL,
      1,
      0,
      1,
      5.085325,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.105169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.736053,
      0,
      3.626675,
      2.149315,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.225393,
      4,
      2,
      1.557327,
      3,
      NULL,
      1.986751,
      NULL,
      NULL,
      7.946268,
      3.745232,
      0.790334,
      1,
      NULL,
      NULL,
      1.574519,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.543763,
      NULL,
      NULL,
      NULL,
      1,
      3.439826,
      1.817228,
      NULL,
      2,
      4,
      5.966652,
      3.178037,
      1,
      2.083285,
      5,
      2.297006,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.922414,
      1,
      9,
      6.633624,
      7.414252,
      NULL,
      3.835904,
      3.047479,
      1,
      1,
      2.608315,
      0.190463,
      NULL,
      3,
      NULL,
      NULL,
      2.213917,
      6,
      3.075468,
      NULL,
      4,
      0.226839,
      5.869050,
      1.920994,
      0,
      1.659102,
      1.699793,
      0,
      NULL,
      0,
      1.423812,
      0.193857,
      NULL,
      NULL,
      1.326614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.135401,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368196,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.455663,
      0,
      0.998213,
      0.871295,
      3,
      1.891431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.737859,
      NULL,
      NULL,
      NULL,
      0.578355,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292755,
      NULL,
      NULL,
      NULL,
      1.799518,
      NULL,
      NULL,
      NULL,
      0.618541,
      NULL,
      NULL,
      NULL,
      1.419725,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.179007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211509,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      10.565551,
      4,
      0,
      0.609592,
      NULL,
      NULL,
      3.800618,
      34,
      7,
      0.230880,
      NULL,
      NULL,
      1,
      1.269730,
      2,
      0,
      NULL,
      11,
      0,
      18,
      3.685220,
      1.026905,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.435973,
      0.624217,
      1.211159,
      0,
      0.535407,
      0,
      0.752891,
      0.001187,
      0,
      0,
      NULL,
      NULL,
      0.608943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746540,
      1.990550,
      NULL,
      NULL,
      1,
      NULL,
      0.463587,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829734,
      1,
      0.943147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633231,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.384257,
      NULL,
      0,
      1.412465,
      2.894515,
      NULL,
      1.997889,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.984060,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305047,
      NULL,
      1.435150,
      NULL,
      NULL,
      NULL,
      0,
      0.180055,
      2,
      NULL,
      NULL,
      NULL,
      3.580010,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.459591,
      NULL,
      1.776037,
      0.903684,
      NULL,
      NULL,
      3,
      0.454438,
      NULL,
      NULL,
      NULL,
      NULL,
      4.994431,
      NULL,
      6,
      1.467129,
      1,
      3.909256,
      NULL,
      2,
      2.323173,
      1,
      0.329271,
      NULL,
      1.862029,
      NULL,
      NULL,
      0.220925,
      NULL,
      NULL,
      3.687748,
      NULL,
      NULL,
      NULL,
      NULL,
      2.225476,
      0.596837,
      NULL,
      1,
      0.967258,
      NULL,
      1,
      NULL,
      NULL,
      1.036353,
      1,
      NULL,
      1.834780,
      0.070271,
      NULL,
      NULL,
      1.786942,
      NULL,
      0.672886,
      0,
      NULL,
      1.542352,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829383,
      NULL,
      1.687038,
      NULL,
      1,
      NULL,
      7.216588,
      NULL,
      9,
      1.509138,
      1,
      2,
      NULL,
      8,
      4,
      1,
      3.043832,
      '01120',
      '12243',
      '',
      0.111925,
      NULL,
      NULL,
      '',
      1.444432,
      '43304',
      '',
      '');
commit;
end;
/


