set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9011057';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3341004',
      3.174059,
      NULL,
      0,
      0,
      '4434',
      1,
      1,
      NULL,
      NULL,
      ' 8-12-1991',
      54.857367,
      NULL,
      3.480051,
      1,
      0,
      '11-21-1976',
      24,
      NULL,
      143,
      62.658561,
      0,
      ' 4- 0-1998',
      ' 5-27-1982',
      ' 6-20-1997',
      NULL,
      1.557593,
      NULL,
      1,
      0.024530,
      1,
      2,
      0,
      NULL,
      0.418616,
      9.401451,
      10,
      0.131705,
      NULL,
      25,
      3,
      15.650849,
      2,
      1.165999,
      1.530131,
      0,
      NULL,
      0,
      0.585052,
      0.964875,
      0.262515,
      1,
      3,
      1,
      0.700507,
      0.852776,
      2,
      0.914975,
      2,
      1,
      NULL,
      0.783978,
      0.168780,
      3,
      0,
      6,
      NULL,
      NULL,
      1,
      1.093263,
      2,
      1,
      2,
      NULL,
      0,
      1,
      1,
      1.142254,
      NULL,
      NULL,
      0.026117,
      NULL,
      NULL,
      NULL,
      0,
      1.710760,
      1.510322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901493,
      1.720861,
      0,
      1.297901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0.060509,
      3,
      NULL,
      0.922905,
      1.852454,
      0,
      1,
      1.415186,
      0.032403,
      NULL,
      1,
      0.680002,
      0,
      0.143075,
      1.279938,
      0,
      NULL,
      1,
      2.313172,
      0.111245,
      1.645304,
      0,
      1,
      1,
      0.180127,
      1.087031,
      4.610036,
      0.859211,
      0,
      1,
      3.722311,
      1,
      1.978907,
      5.932485,
      7.570372,
      9.577648,
      NULL,
      0,
      4.648592,
      NULL,
      NULL,
      4,
      4,
      6,
      1,
      ' 8-22-1988',
      NULL,
      ' 1-16-1997',
      NULL,
      NULL,
      0,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454677,
      0.888730,
      1.313918,
      5.531633,
      NULL,
      1.655212,
      1,
      0.366019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.267647,
      NULL,
      1.235957,
      1.828990,
      0,
      1.003745,
      2,
      1.881804,
      NULL,
      NULL,
      NULL,
      1.300923,
      0,
      7.333269,
      3,
      0,
      NULL,
      5.743888,
      0.617481,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.955054,
      1.306476,
      0,
      1.629634,
      0.529649,
      2.583194,
      18,
      NULL,
      0.657172,
      NULL,
      NULL,
      NULL,
      5,
      0.964654,
      3.889290,
      3,
      1,
      NULL,
      4,
      NULL,
      1,
      3,
      0.983010,
      0,
      0.577998,
      3,
      5,
      1,
      0.116787,
      1.477713,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0.204544,
      4.761690,
      1.191697,
      11.186685,
      1,
      3.909875,
      0.586700,
      NULL,
      3.748202,
      3.805962,
      2.315917,
      4,
      NULL,
      1.623916,
      0.668394,
      40,
      3,
      2.967630,
      NULL,
      NULL,
      29.101872,
      72.971675,
      3,
      1.982678,
      2,
      '30024',
      '11141',
      '40422',
      0.505665,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      4.266741,
      9.057917,
      35.012566,
      NULL,
      27.309041,
      0,
      6,
      2,
      3,
      0.678525,
      1.885943,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.585534,
      3,
      1.132704,
      0.631899,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.073895,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      9,
      1.301857,
      3,
      1.015808,
      NULL,
      NULL,
      NULL,
      1.263401,
      NULL,
      NULL,
      NULL,
      0.976382,
      NULL,
      NULL,
      1.512454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.403256,
      0.879383,
      1,
      0.138063,
      0,
      1.280285,
      5,
      5,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.550796,
      2.983217,
      2.325098,
      0.904500,
      2,
      1,
      2.175193,
      NULL,
      0.538624,
      0.715096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.683702,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.353985,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      5.847664,
      NULL,
      NULL,
      5,
      NULL,
      1.701057,
      0.915775,
      NULL,
      NULL,
      NULL,
      0.486600,
      NULL,
      3.840605,
      2,
      0.266709,
      2,
      3,
      2,
      1.932191,
      5.580313,
      5,
      1,
      0.854842,
      0.891902,
      1.662254,
      NULL,
      NULL,
      2.710304,
      1,
      0.189040,
      1.672042,
      NULL,
      NULL,
      4.624398,
      1.555091,
      0,
      NULL,
      5,
      NULL,
      0,
      NULL,
      0.117949,
      0,
      NULL,
      0.775578,
      NULL,
      1.991253,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899903,
      NULL,
      NULL,
      1.160751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652820,
      NULL,
      NULL,
      1.185858,
      NULL,
      NULL,
      0.452089,
      1.321200,
      1.791206,
      0.296595,
      0.051176,
      2.738842,
      NULL,
      NULL,
      NULL,
      0,
      1.312496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152997,
      1.179507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.355042,
      3,
      NULL,
      NULL,
      0.191368,
      1.254010,
      NULL,
      NULL,
      1.313603,
      1,
      NULL,
      NULL,
      0,
      1.791200,
      NULL,
      NULL,
      3,
      3.455880,
      NULL,
      NULL,
      0.530722,
      0.265680,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.732870,
      3.695764,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.832654,
      1.355385,
      NULL,
      NULL,
      0.246016,
      1,
      NULL,
      NULL,
      0.499706,
      0.577231,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.139558,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017140,
      11,
      2,
      5.278230,
      2.067435,
      1.896397,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      6,
      2,
      0.164571,
      NULL,
      NULL,
      1,
      NULL,
      0,
      59,
      NULL,
      0,
      NULL,
      0.955373,
      NULL,
      0.160554,
      0,
      0,
      2.267453,
      0,
      1,
      1.862804,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      131,
      NULL,
      NULL,
      NULL,
      26.717081,
      1.060085,
      1.041037,
      NULL,
      NULL,
      1,
      NULL,
      0.237481,
      NULL,
      1.067734,
      NULL,
      3.675637,
      NULL,
      0.441566,
      NULL,
      1,
      NULL,
      1.339164,
      NULL,
      1.650813,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.252294,
      NULL,
      NULL,
      NULL,
      1.060446,
      NULL,
      1.493025,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.255241,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      35.040178,
      NULL,
      1.094102,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.363848,
      1.787035,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.408369,
      1,
      NULL,
      2.150413,
      1,
      1,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.676903,
      NULL,
      0.715898,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      27,
      NULL,
      1.972902,
      NULL,
      NULL,
      NULL,
      3.929875,
      1.021666,
      0,
      NULL,
      0.559724,
      NULL,
      1.992700,
      0,
      0,
      3,
      3.587199,
      NULL,
      0,
      0.927348,
      0.201580,
      NULL,
      1.401998,
      1,
      1.237479,
      2,
      1.745239,
      1.439287,
      NULL,
      0.289971,
      0.792528,
      NULL,
      0.687491,
      0.811444,
      NULL,
      1.665090,
      NULL,
      1,
      0.689018,
      NULL,
      1.125262,
      1,
      0,
      0.026236,
      1.310396,
      0.686401,
      3.178410,
      0.816961,
      1,
      NULL,
      0,
      3,
      0.359759,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215907,
      NULL,
      NULL,
      0,
      4,
      0.583166,
      2,
      1.524105,
      NULL,
      NULL,
      54.737017,
      86.998807,
      2,
      0.480609,
      0,
      '33033',
      '22012',
      '32032',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


