set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '34',
      1.286440,
      31.422910,
      '0001344',
      1,
      1.910610,
      NULL,
      NULL,
      '4324',
      5.410307,
      0,
      NULL,
      NULL,
      NULL,
      76.235187,
      NULL,
      NULL,
      1.386697,
      1,
      ' 1- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-10-2001',
      ' 1- 1-1985',
      ' 1-13-1976',
      3.334200,
      0.419838,
      NULL,
      2,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.068372,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1,
      0,
      9,
      NULL,
      1.992498,
      1,
      1.905757,
      3.401483,
      0.502709,
      3,
      NULL,
      1,
      0,
      0.062824,
      1,
      1,
      3.492331,
      0.412942,
      3.251414,
      1.857521,
      1.401609,
      0.228919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.781817,
      3.432233,
      NULL,
      0.500307,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      2.722133,
      3,
      2.111084,
      1.948479,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095806,
      2.727145,
      NULL,
      0,
      2,
      NULL,
      0.548708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129522,
      8.446017,
      3,
      1,
      6,
      0.964959,
      NULL,
      0.358038,
      1,
      0.078302,
      1.973210,
      1,
      1.148241,
      0,
      0.200376,
      NULL,
      0,
      0,
      0.998521,
      NULL,
      0.201103,
      0,
      1,
      1,
      3.232514,
      0.145396,
      NULL,
      0,
      0.303697,
      6.048214,
      2,
      6,
      0,
      1.507224,
      1,
      NULL,
      2.726293,
      NULL,
      NULL,
      0,
      5.932834,
      8.230402,
      4,
      7.973276,
      2,
      NULL,
      NULL,
      NULL,
      '11-23-2000',
      NULL,
      ' 7-21-1984',
      31,
      3,
      NULL,
      1,
      3.280486,
      2.406928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.076276,
      1.692251,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718798,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.607591,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.296986,
      0.290952,
      0.251354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.616403,
      8,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      1,
      1.049637,
      3.538910,
      NULL,
      3,
      1,
      NULL,
      6,
      1,
      3.136506,
      3.312706,
      NULL,
      NULL,
      0,
      0,
      1.511484,
      0,
      0,
      0,
      0.274941,
      1.440200,
      0.131013,
      0,
      1,
      0,
      4,
      2.187539,
      5,
      9,
      NULL,
      0,
      0,
      0.876107,
      4,
      NULL,
      0,
      NULL,
      13,
      2.304215,
      3.605580,
      13.093954,
      NULL,
      45,
      58.743944,
      2.979469,
      0,
      1.908000,
      '42434',
      '',
      '',
      1,
      '403',
      '',
      '',
      0.296884,
      NULL,
      '',
      '',
      3,
      27,
      23.627285,
      17,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.048181,
      2.365313,
      0,
      NULL,
      NULL,
      0.786578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.482262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.743549,
      2,
      0,
      NULL,
      NULL,
      2,
      1.009155,
      0,
      NULL,
      1,
      3,
      0.077083,
      NULL,
      1.257721,
      0.550614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529031,
      2.978264,
      3.758825,
      2,
      3.711338,
      2.934728,
      NULL,
      3.620556,
      0.478253,
      NULL,
      0.936907,
      NULL,
      1,
      0.606971,
      2.846363,
      2,
      NULL,
      0.703273,
      0,
      2,
      1.638325,
      3.021484,
      0,
      NULL,
      0.442321,
      2.483018,
      2.148592,
      0,
      0.747770,
      NULL,
      NULL,
      2.578070,
      NULL,
      1,
      0.388273,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.990816,
      NULL,
      NULL,
      NULL,
      0.204155,
      NULL,
      NULL,
      2,
      3.401057,
      1.173920,
      3,
      2,
      2.323924,
      0.864746,
      NULL,
      NULL,
      4,
      1.693880,
      4.190983,
      0.643929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.279391,
      NULL,
      NULL,
      0.600696,
      NULL,
      NULL,
      0.814613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873837,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      6.514895,
      4,
      5.689836,
      6.419312,
      0.699817,
      2.421018,
      NULL,
      NULL,
      NULL,
      0.931512,
      3.657365,
      2.396556,
      NULL,
      3,
      1.316990,
      1,
      1.732102,
      NULL,
      3.319512,
      4,
      5,
      0.506782,
      2,
      2.102021,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      3.247651,
      NULL,
      3,
      NULL,
      3,
      1.697885,
      NULL,
      NULL,
      0.959592,
      1.184925,
      3.924496,
      NULL,
      0.294012,
      0.994062,
      1.569754,
      1.833161,
      1.146800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.550489,
      0.563972,
      NULL,
      1.125432,
      0.230476,
      1.435351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.003562,
      0.165913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.425266,
      NULL,
      NULL,
      0,
      NULL,
      0.838182,
      35.987941,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.856137,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.230349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.278702,
      1.416635,
      1.605956,
      0.068992,
      NULL,
      5.139929,
      0.629658,
      0.196866,
      NULL,
      2,
      0,
      1,
      0.167329,
      1.101215,
      NULL,
      0.156609,
      3,
      NULL,
      0.992357,
      NULL,
      NULL,
      0.358311,
      0.751512,
      NULL,
      0.868447,
      0,
      NULL,
      0,
      1.976265,
      NULL,
      3.469902,
      3,
      NULL,
      1.553144,
      1.686020,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2.448807,
      NULL,
      0,
      0,
      NULL,
      3.329719,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532776,
      NULL,
      0,
      NULL,
      0.275673,
      NULL,
      3,
      NULL,
      8,
      1,
      3.742428,
      0.070486,
      39,
      NULL,
      0,
      NULL,
      0,
      NULL,
      '',
      '',
      2,
      '332',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


