set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '40',
      6.453987,
      36.474015,
      NULL,
      3,
      0,
      4,
      0,
      '0230',
      NULL,
      0,
      NULL,
      NULL,
      ' 9- 4-1995',
      NULL,
      10.084693,
      NULL,
      3,
      NULL,
      ' 0-12-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0.175860,
      NULL,
      ' 7- 6-1999',
      ' 9-20-1985',
      0.924088,
      NULL,
      1,
      NULL,
      1.810858,
      1.626894,
      NULL,
      3.900440,
      NULL,
      NULL,
      NULL,
      8.212293,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.405886,
      NULL,
      NULL,
      1,
      1.444534,
      0,
      NULL,
      NULL,
      0.204725,
      NULL,
      1.870956,
      3.764420,
      NULL,
      1.791638,
      0.663602,
      5.412425,
      0.321587,
      2,
      1.797274,
      2.951138,
      0,
      0,
      1,
      3.318471,
      1.137890,
      1.335552,
      1.032254,
      0.466445,
      NULL,
      0.518861,
      0.978518,
      1.041167,
      1,
      0.435987,
      0,
      NULL,
      NULL,
      1.952295,
      NULL,
      3.099719,
      NULL,
      NULL,
      NULL,
      1.830110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.515601,
      1.182698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.450288,
      3,
      1.278122,
      1.954968,
      0,
      0.408574,
      0.641620,
      0.965750,
      0.145976,
      1.054084,
      1,
      0.376189,
      0.134803,
      0.041161,
      0,
      0,
      0,
      NULL,
      1.051220,
      NULL,
      1,
      2,
      3,
      0.996892,
      0.133555,
      1.864479,
      1,
      7.912421,
      0,
      1.776081,
      3,
      0,
      NULL,
      2.181898,
      NULL,
      5.980046,
      7.649222,
      0,
      2.187112,
      7,
      5,
      4.120943,
      3.264247,
      3,
      0,
      NULL,
      0.908783,
      3.442703,
      ' 7- 2-2001',
      18.673701,
      ' 6-27-1979',
      7,
      NULL,
      1.546542,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221294,
      1.863361,
      1.346536,
      1.555284,
      0,
      0,
      0,
      0.942841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.158685,
      3,
      2.669929,
      2,
      3,
      0,
      0,
      1.217601,
      0.234001,
      1.605513,
      0.188299,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.008312,
      6,
      7.834082,
      0,
      2,
      5.058298,
      0.215692,
      NULL,
      NULL,
      2.507323,
      3,
      0.694608,
      5.804293,
      3.076849,
      1,
      2.177985,
      ' 2-26-1977',
      NULL,
      ' 0-27-1988',
      1.054517,
      0.750945,
      NULL,
      NULL,
      2.945840,
      0.906762,
      0,
      0.813763,
      NULL,
      NULL,
      1,
      1.929094,
      1.154097,
      2,
      1.413803,
      NULL,
      NULL,
      NULL,
      2.753997,
      NULL,
      1.587055,
      0,
      1,
      3,
      0,
      2.722387,
      1,
      1.983287,
      7,
      0,
      0.769004,
      1,
      2.460963,
      2,
      0,
      2.039203,
      0.075632,
      0.979837,
      NULL,
      0,
      0,
      NULL,
      0.026971,
      0,
      0.884788,
      1.202103,
      NULL,
      NULL,
      2,
      0,
      3,
      4.061463,
      2,
      NULL,
      3,
      6.366827,
      NULL,
      2.735091,
      2,
      0,
      2.154415,
      NULL,
      34,
      1.664599,
      NULL,
      33.953452,
      NULL,
      NULL,
      NULL,
      5,
      3.551661,
      2,
      '11441',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      38.830175,
      18.989888,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.621286,
      1.603429,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.878706,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545271,
      NULL,
      NULL,
      1.954958,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.406797,
      NULL,
      NULL,
      0.307800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.214264,
      NULL,
      NULL,
      0.193885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541257,
      NULL,
      NULL,
      1.797402,
      NULL,
      NULL,
      1.665151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283613,
      0.223835,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.605468,
      NULL,
      NULL,
      NULL,
      NULL,
      3.962907,
      1.526625,
      0.879007,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.371886,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.303911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975375,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.321712,
      NULL,
      3.564169,
      6.450282,
      0,
      NULL,
      0,
      3.060089,
      NULL,
      NULL,
      2.637183,
      0,
      0,
      1.468670,
      0,
      NULL,
      1.369624,
      3.613826,
      2.877411,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.981537,
      NULL,
      1.539037,
      1,
      3.059924,
      1,
      0.498993,
      1.068471,
      NULL,
      3.530551,
      5.966873,
      NULL,
      0.677932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.638934,
      0.220672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      2.862013,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.868238,
      NULL,
      NULL,
      NULL,
      0.798772,
      NULL,
      NULL,
      NULL,
      0.874216,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.849192,
      NULL,
      NULL,
      NULL,
      1.345366,
      NULL,
      NULL,
      NULL,
      1.083460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.640713,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.607042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489961,
      NULL,
      NULL,
      NULL,
      13.282164,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1.845179,
      6,
      2.530288,
      0.460677,
      NULL,
      27,
      3.004213,
      1.599405,
      NULL,
      0.798166,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      78.177907,
      NULL,
      1,
      1,
      0,
      1.894521,
      0,
      1,
      1.759593,
      1,
      1.047668,
      NULL,
      1,
      0,
      0.769602,
      0,
      0,
      0.598256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.675699,
      0.748004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182543,
      0,
      NULL,
      0.097186,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088804,
      NULL,
      0,
      NULL,
      1,
      1,
      1.083976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215864,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381518,
      0,
      NULL,
      0.145550,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.061491,
      NULL,
      0.313792,
      2.229420,
      1,
      0.922209,
      NULL,
      NULL,
      0.891160,
      0.532571,
      0.810831,
      1.240786,
      0,
      1.140437,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.056952,
      NULL,
      NULL,
      NULL,
      1.299041,
      0,
      1.983542,
      2.541710,
      7.622555,
      0.886462,
      3.201051,
      NULL,
      1,
      1.010952,
      1,
      1.053326,
      0.893574,
      1,
      3.590592,
      3.859068,
      NULL,
      1.047457,
      1.025409,
      NULL,
      NULL,
      0.966841,
      3.468229,
      0,
      2,
      3.403922,
      3.106990,
      1.479224,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.951410,
      0.128417,
      3.155947,
      3,
      0,
      1,
      0,
      1,
      0,
      1.754735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.188237,
      1.144174,
      1.238309,
      5.315436,
      3.297815,
      NULL,
      NULL,
      NULL,
      NULL,
      18.060311,
      98,
      1,
      1.177009,
      2,
      '42424',
      '21344',
      '',
      NULL,
      NULL,
      '',
      '',
      0.555318,
      '',
      NULL,
      NULL);
commit;
end;
/


