set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7603326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1341233',
      3,
      NULL,
      NULL,
      1,
      NULL,
      3.355437,
      1,
      NULL,
      NULL,
      ' 2- 7-1979',
      NULL,
      NULL,
      3,
      2.155997,
      NULL,
      ' 2-27-1975',
      39,
      2.324704,
      152,
      31.412972,
      2.178602,
      '11-13-1997',
      NULL,
      NULL,
      2.632977,
      3.812375,
      2.295979,
      NULL,
      1,
      NULL,
      3,
      0.801609,
      NULL,
      NULL,
      NULL,
      8.106327,
      NULL,
      NULL,
      14.264284,
      1.414426,
      NULL,
      1.271599,
      4,
      2,
      NULL,
      3,
      0.364676,
      1,
      1.809128,
      0.455781,
      0,
      0,
      NULL,
      1,
      1.946105,
      0.994815,
      3.263742,
      2.425772,
      NULL,
      5.007561,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      0.237486,
      1,
      0.949738,
      1,
      0.590397,
      6,
      3.932749,
      1.470367,
      0.467399,
      NULL,
      1,
      NULL,
      NULL,
      0.234923,
      NULL,
      NULL,
      7.977262,
      2,
      7.768495,
      NULL,
      NULL,
      NULL,
      1.811844,
      2.321225,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      10.423835,
      NULL,
      0,
      9.417817,
      0.892952,
      NULL,
      1,
      1.746342,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      3,
      NULL,
      0.533714,
      3,
      5.851060,
      7.509284,
      0,
      4.336812,
      1.210283,
      2,
      1,
      0.398523,
      NULL,
      NULL,
      2,
      1.938098,
      0.802078,
      0.154361,
      NULL,
      0,
      NULL,
      5.262507,
      1.364199,
      4.306667,
      1.544376,
      5,
      NULL,
      0.327311,
      NULL,
      5.849025,
      2.975415,
      4,
      NULL,
      3.411513,
      0.789943,
      8,
      5,
      9.156759,
      7,
      10,
      0.254997,
      4.611329,
      NULL,
      NULL,
      0.252882,
      7.163686,
      0.842529,
      ' 4-11-1980',
      38,
      ' 5-18-2001',
      12.504070,
      1.759053,
      NULL,
      1,
      5.893799,
      0.510868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213187,
      1.939625,
      1,
      0,
      1.887598,
      1,
      NULL,
      1.234077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.015448,
      0,
      4.906671,
      8,
      9,
      7,
      5.372153,
      1,
      NULL,
      NULL,
      NULL,
      0.219312,
      NULL,
      1.272562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      0.477841,
      0,
      2,
      76,
      0,
      1.815298,
      NULL,
      NULL,
      NULL,
      1,
      0.815729,
      2,
      2,
      NULL,
      NULL,
      0.941322,
      0,
      0.946034,
      0,
      0.595509,
      2,
      1.576538,
      0,
      3.289786,
      2.002162,
      1.886755,
      2.013889,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0.626917,
      0.573421,
      NULL,
      0,
      1,
      0.239762,
      5,
      0,
      NULL,
      1,
      7.063902,
      11.346027,
      1,
      0.655207,
      5,
      2,
      6,
      3.165139,
      0,
      NULL,
      21.290173,
      1.401287,
      0.950694,
      NULL,
      NULL,
      12,
      89.204031,
      NULL,
      NULL,
      1.056187,
      '30131',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.623728,
      6.153283,
      45,
      0.298444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141222,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      0.181328,
      NULL,
      NULL,
      NULL,
      0,
      0.467021,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.168943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.887964,
      NULL,
      NULL,
      NULL,
      2.865163,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131316,
      NULL,
      NULL,
      NULL,
      0.149357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.572995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.926049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964271,
      NULL,
      NULL,
      0.022339,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644918,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528053,
      NULL,
      NULL,
      1.243573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.697415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.223460,
      1.069467,
      0,
      NULL,
      NULL,
      2.545821,
      5,
      3.757187,
      NULL,
      NULL,
      NULL,
      1,
      3.620824,
      0.946038,
      0,
      3.052470,
      1,
      0.297655,
      2.552561,
      1.452805,
      NULL,
      0,
      2,
      3.170355,
      NULL,
      NULL,
      1.634017,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.309359,
      1.348110,
      0.240034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062746,
      0,
      1.081499,
      1,
      1.061324,
      0.587028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.560521,
      1,
      1.280449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262678,
      0,
      1.619244,
      0,
      NULL,
      NULL,
      1.096939,
      NULL,
      NULL,
      1.141127,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.074765,
      0,
      1,
      1.244483,
      0,
      0,
      0.528218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148263,
      0.048586,
      3.187791,
      1,
      0.409675,
      1.043211,
      3,
      1.441173,
      10,
      2,
      3,
      0,
      NULL,
      0,
      NULL,
      1.821703,
      1.036907,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.146984,
      1,
      NULL,
      1.085149,
      1.303118,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      0.992024,
      0,
      NULL,
      0,
      NULL,
      0.062024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405836,
      NULL,
      0,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      128,
      151.375853,
      1.935333,
      1,
      0.382150,
      '12332',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0.919435,
      '',
      '',
      '');
commit;
end;
/


