set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7931645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      '20',
      5.252551,
      NULL,
      '0420002',
      3,
      0,
      1,
      0,
      '1123',
      5.857665,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1975',
      NULL,
      3,
      NULL,
      2,
      0.011080,
      ' 9-28-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-24-2002',
      0.242529,
      2.455989,
      NULL,
      0,
      0.213863,
      0,
      3.286609,
      0,
      1,
      348,
      9,
      NULL,
      6.932110,
      NULL,
      NULL,
      NULL,
      NULL,
      4.963622,
      0,
      NULL,
      1.556244,
      1,
      1.634644,
      0.495353,
      0,
      1.370469,
      NULL,
      0.109389,
      0.418442,
      0,
      3,
      13,
      2,
      NULL,
      NULL,
      1.983752,
      0.514301,
      5,
      NULL,
      1,
      0.996066,
      6.372678,
      0.806920,
      0,
      1.327864,
      2.241474,
      NULL,
      7,
      0,
      3.219158,
      NULL,
      0.023745,
      0.391541,
      NULL,
      NULL,
      0.482663,
      NULL,
      NULL,
      0,
      2.004151,
      NULL,
      0,
      2,
      2.453685,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      0,
      NULL,
      0.753992,
      1,
      1.727244,
      5.695090,
      1.801771,
      1,
      3.299071,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.129760,
      NULL,
      0,
      1.183324,
      NULL,
      NULL,
      NULL,
      1.136984,
      NULL,
      0,
      1,
      0,
      0.660063,
      0,
      0.282408,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.648557,
      NULL,
      0.205790,
      NULL,
      NULL,
      1.426551,
      0.073033,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0.038569,
      NULL,
      0.997385,
      0,
      2,
      7,
      NULL,
      1.915752,
      4,
      NULL,
      5,
      NULL,
      2.564453,
      '11-10-1978',
      2594.094267,
      NULL,
      119,
      3.204385,
      1,
      NULL,
      8.600430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461399,
      4.087927,
      1,
      NULL,
      1,
      0,
      1.887115,
      5.547287,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.578556,
      0.428188,
      0.317039,
      1,
      NULL,
      1.859565,
      NULL,
      NULL,
      NULL,
      1,
      1.245761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.257677,
      1.368275,
      NULL,
      1522.913868,
      1.101550,
      2,
      95.161457,
      30.309152,
      483,
      3.279572,
      1,
      3.671482,
      0.864711,
      NULL,
      0.862610,
      NULL,
      3,
      2.320316,
      3,
      3.389481,
      NULL,
      2,
      2,
      1.892164,
      0.145425,
      1,
      0,
      1,
      2,
      1,
      NULL,
      1,
      1.180231,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1.222353,
      0.903378,
      7,
      NULL,
      NULL,
      2.280242,
      11,
      1,
      1.813155,
      3.164954,
      1.225125,
      0.172610,
      1,
      0,
      39.271773,
      1.732845,
      2,
      67.721100,
      NULL,
      64,
      NULL,
      0.220463,
      2,
      2,
      '01444',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.347014,
      28.910626,
      NULL,
      NULL,
      3.127543,
      15,
      26.852634,
      208.596651,
      5,
      3.804534,
      0.959878,
      NULL,
      0,
      NULL,
      NULL,
      1.456434,
      1.696049,
      3.970133,
      0.880217,
      NULL,
      NULL,
      1.952683,
      1.608071,
      2,
      1,
      NULL,
      NULL,
      2.979198,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.401809,
      1.284566,
      0,
      1.289219,
      NULL,
      NULL,
      1,
      0.931255,
      1,
      3.748833,
      NULL,
      0.034837,
      6.759272,
      1,
      1,
      0.244968,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      1,
      1,
      1.869081,
      3,
      0,
      2.736907,
      2.348321,
      2,
      2,
      NULL,
      0.817178,
      1.067167,
      NULL,
      2,
      1.112760,
      NULL,
      NULL,
      1.151142,
      0,
      1.464714,
      NULL,
      2.592761,
      1.968817,
      NULL,
      NULL,
      1.290489,
      NULL,
      NULL,
      1.217398,
      1.222095,
      NULL,
      6.444509,
      3.082656,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.008972,
      NULL,
      0,
      1.800015,
      0.247762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.169577,
      NULL,
      NULL,
      3.146210,
      1.372752,
      1.240291,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.758322,
      NULL,
      NULL,
      0.716830,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.146521,
      NULL,
      NULL,
      0.300958,
      NULL,
      NULL,
      0.394720,
      NULL,
      NULL,
      0.497089,
      NULL,
      NULL,
      1.002412,
      NULL,
      NULL,
      1.160604,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394812,
      0.605743,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.898099,
      2.845403,
      1.997854,
      3,
      NULL,
      1,
      NULL,
      6,
      1,
      NULL,
      2,
      3.429305,
      3,
      NULL,
      1.464703,
      NULL,
      NULL,
      3,
      1.303537,
      NULL,
      NULL,
      4.280744,
      3.096778,
      1,
      4,
      5.301526,
      NULL,
      1.071064,
      3.831107,
      3,
      1,
      NULL,
      1,
      1,
      0.881368,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361062,
      NULL,
      NULL,
      1.771322,
      NULL,
      NULL,
      3.181952,
      NULL,
      NULL,
      1.380353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.867545,
      NULL,
      NULL,
      1,
      2.411873,
      2,
      1.572811,
      0,
      3.888808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.782555,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.925807,
      NULL,
      NULL,
      NULL,
      1.952544,
      NULL,
      NULL,
      NULL,
      3.242004,
      NULL,
      NULL,
      NULL,
      1.338285,
      NULL,
      NULL,
      NULL,
      1.812769,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.904768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798228,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397791,
      NULL,
      NULL,
      NULL,
      3.764247,
      NULL,
      NULL,
      NULL,
      2.123344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971225,
      5.236542,
      0.252174,
      1.778920,
      2.411046,
      473,
      102,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921053,
      66.168320,
      NULL,
      1.337411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.106425,
      1,
      0,
      1.539453,
      NULL,
      1,
      1.516722,
      0,
      NULL,
      NULL,
      0.138359,
      1.007430,
      1,
      0.876519,
      1.566493,
      1,
      NULL,
      1,
      0,
      0.351706,
      1.859683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779632,
      0,
      3.785908,
      6.385571,
      1,
      5.683067,
      NULL,
      NULL,
      8,
      2.720640,
      NULL,
      0,
      3.596647,
      3,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.943564,
      NULL,
      1.918527,
      1,
      NULL,
      1,
      0,
      NULL,
      1.121420,
      NULL,
      NULL,
      1.881723,
      2.017600,
      NULL,
      0.227216,
      0.149160,
      NULL,
      0,
      2,
      NULL,
      0.528577,
      1,
      NULL,
      1.549649,
      1,
      1.948389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.034037,
      3.482253,
      3.649877,
      2,
      0.318213,
      NULL,
      33,
      38,
      1,
      0,
      NULL,
      '12341',
      '42023',
      '',
      0.581810,
      '',
      '',
      '',
      1.056644,
      '',
      '',
      '');
commit;
end;
/


