set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2001341',
      0.357212,
      NULL,
      NULL,
      0,
      '2420',
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.468476,
      0,
      3,
      ' 3- 8-1991',
      24,
      3,
      61.046829,
      72.124934,
      1.657849,
      ' 7- 1-1988',
      ' 3-26-1991',
      NULL,
      0.021096,
      0.419896,
      0.328543,
      NULL,
      1.544183,
      0,
      0.765269,
      1,
      1.988021,
      23.713914,
      10,
      3,
      0,
      NULL,
      1,
      NULL,
      22.275552,
      3,
      1,
      5.749039,
      1.242394,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.964579,
      1,
      NULL,
      1.177534,
      2,
      3,
      1,
      3,
      0,
      NULL,
      1,
      1,
      1.113639,
      2,
      4.540910,
      1.668453,
      0,
      3.324597,
      3,
      NULL,
      NULL,
      3,
      3.733930,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.102119,
      1.082493,
      1.653395,
      3,
      0.708812,
      1.775842,
      0.714276,
      NULL,
      NULL,
      3.918605,
      1.247100,
      NULL,
      0.310672,
      0,
      0.739790,
      1,
      NULL,
      1,
      1.650393,
      3.021957,
      1,
      1,
      4,
      1.501425,
      2.301820,
      1,
      1.964450,
      NULL,
      NULL,
      1.905519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.712416,
      NULL,
      0.941022,
      0,
      5,
      NULL,
      1,
      0.342048,
      7.765118,
      1,
      1.294276,
      1.346602,
      1,
      NULL,
      NULL,
      1.762541,
      NULL,
      4.588239,
      1,
      4,
      1.869623,
      NULL,
      2,
      1.811525,
      2,
      0.045002,
      0,
      1,
      0.592947,
      1,
      4,
      NULL,
      5.578721,
      0.478370,
      2.730225,
      1.383217,
      2,
      NULL,
      8,
      6.528362,
      3.369202,
      3.946303,
      3,
      ' 8-21-1980',
      166,
      ' 8-15-2000',
      6.844298,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.128521,
      0.668049,
      NULL,
      1.069181,
      0.846346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      182.693655,
      2.131158,
      NULL,
      1,
      0.051436,
      NULL,
      3.446108,
      3.993436,
      NULL,
      0.638154,
      0.718024,
      2.342141,
      NULL,
      3.350322,
      1.181441,
      1.657478,
      1,
      0.075973,
      1,
      0.073150,
      3.690866,
      3,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.653845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660791,
      0,
      0.796143,
      0.631754,
      0.559143,
      0,
      1,
      3,
      26,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.204635,
      2,
      2.603251,
      NULL,
      0.114083,
      3,
      3,
      0.919577,
      3.372291,
      NULL,
      NULL,
      0.258619,
      2.535426,
      0,
      3,
      NULL,
      0,
      0.049197,
      2,
      0.596100,
      1.382604,
      0.043206,
      1.159073,
      0,
      1.583447,
      0.417915,
      1,
      1,
      0,
      0.990185,
      NULL,
      3.993310,
      7.005576,
      NULL,
      NULL,
      0.341178,
      0.831557,
      NULL,
      3,
      2.942926,
      0.932732,
      1.043839,
      NULL,
      3.331588,
      1,
      NULL,
      14,
      71.513432,
      4.665933,
      3,
      1.013913,
      1.517448,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      30.677148,
      NULL,
      17.761699,
      2,
      11.838998,
      8.188093,
      1,
      NULL,
      2.094318,
      0,
      NULL,
      1,
      1,
      NULL,
      1.313354,
      NULL,
      NULL,
      2.421860,
      1,
      0,
      3.196632,
      NULL,
      0,
      3,
      2,
      1.873897,
      1.539546,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.946462,
      0.124057,
      2,
      2.114540,
      3.587116,
      1.012383,
      3,
      2.645585,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.061082,
      6,
      0.363201,
      0.765161,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.864125,
      2.026075,
      1.692237,
      NULL,
      NULL,
      NULL,
      1.475151,
      NULL,
      NULL,
      3,
      1.555663,
      0.603332,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      1.690900,
      NULL,
      0.818822,
      1,
      1.276787,
      NULL,
      NULL,
      1.219242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      NULL,
      1,
      1.915701,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.604296,
      2.922435,
      2.982735,
      1,
      1.904060,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      1.110932,
      3.722704,
      NULL,
      3,
      1,
      6,
      7,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.188365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036763,
      3.696003,
      1,
      0.504357,
      3.938989,
      NULL,
      4.846095,
      1,
      0,
      7.157976,
      2,
      5,
      5,
      4.919321,
      5,
      3,
      3,
      NULL,
      1.913224,
      0,
      2.783242,
      1.352018,
      1,
      NULL,
      1.815373,
      1.214871,
      NULL,
      0.271015,
      3.476574,
      0.886414,
      1,
      NULL,
      NULL,
      0,
      2,
      1.914150,
      1.599611,
      1.530852,
      NULL,
      5.100122,
      4.862214,
      7.111044,
      5,
      5,
      6.703620,
      1.069075,
      2.385923,
      7.396274,
      NULL,
      1.820630,
      0.805093,
      1,
      1,
      2.136583,
      NULL,
      NULL,
      0.920230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024077,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.961759,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0.315492,
      1.641557,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      42.787598,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.580342,
      NULL,
      NULL,
      NULL,
      2.807824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676220,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.452730,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.356445,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928078,
      NULL,
      NULL,
      NULL,
      3.098535,
      NULL,
      NULL,
      NULL,
      2.655956,
      NULL,
      NULL,
      NULL,
      2,
      0.851687,
      9,
      0,
      NULL,
      19.822843,
      7.595435,
      0.206131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      10,
      NULL,
      1,
      NULL,
      NULL,
      1.704728,
      NULL,
      1.127159,
      NULL,
      1,
      1,
      NULL,
      0,
      0.201368,
      1,
      NULL,
      1,
      1.337448,
      0,
      0,
      1.377719,
      1.220259,
      1.822406,
      NULL,
      0.390965,
      0.680331,
      1,
      0.464124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.444970,
      1.017420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.751136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.496817,
      0.894142,
      3.589312,
      NULL,
      4.247852,
      1,
      1,
      NULL,
      0.515309,
      0.808562,
      0,
      1,
      0.993964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      0,
      3.046835,
      0,
      1.624584,
      0.015889,
      NULL,
      1.605764,
      NULL,
      0,
      0.618643,
      NULL,
      NULL,
      0.615306,
      NULL,
      1.094203,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.777520,
      2.910720,
      NULL,
      1.559870,
      1,
      NULL,
      1,
      1.261500,
      NULL,
      0,
      1,
      NULL,
      1,
      1.638566,
      NULL,
      0.030112,
      3,
      NULL,
      NULL,
      1.104833,
      NULL,
      2.394651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.619157,
      NULL,
      0,
      NULL,
      3.927941,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.552015,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.595124,
      NULL,
      1.140930,
      NULL,
      NULL,
      NULL,
      22,
      1,
      NULL,
      1.282296,
      NULL,
      0,
      NULL,
      0,
      NULL,
      5.543293,
      0.637591,
      2,
      1.481908,
      NULL,
      NULL,
      NULL,
      131.211345,
      2,
      0.608678,
      3.555765,
      '03021',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


