set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4301023',
      3.752597,
      NULL,
      1,
      2,
      '4323',
      2,
      NULL,
      4.044474,
      10.100885,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.190793,
      ' 5- 9-1979',
      39,
      2.583753,
      525.829749,
      1573,
      4.006057,
      NULL,
      NULL,
      ' 0- 7-1992',
      NULL,
      0,
      0.251694,
      0.857992,
      0.445838,
      1.541850,
      0,
      1.451905,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      37.284678,
      NULL,
      5,
      NULL,
      4,
      NULL,
      0.610233,
      1,
      2.727225,
      0,
      1.753491,
      0.899983,
      1.860844,
      NULL,
      0.693555,
      NULL,
      1,
      0,
      0.525216,
      4,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.399415,
      NULL,
      NULL,
      NULL,
      1.205549,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.542762,
      1.460871,
      NULL,
      NULL,
      NULL,
      0.558878,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.712224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.253154,
      1.160437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.993971,
      NULL,
      1.318262,
      1,
      2,
      1,
      1.668677,
      1.267084,
      NULL,
      3,
      1.096995,
      2,
      0.994997,
      0,
      0,
      0.682104,
      0.728753,
      NULL,
      NULL,
      5,
      1,
      1.078382,
      1,
      NULL,
      5,
      5,
      0,
      5.559645,
      NULL,
      NULL,
      1,
      3,
      2,
      4.686972,
      5,
      3.711280,
      3,
      2.191101,
      0.644308,
      5,
      NULL,
      8.729238,
      5,
      6.356806,
      NULL,
      0.825195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.713332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951296,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0.433336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318169,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.953789,
      1.125989,
      NULL,
      NULL,
      NULL,
      0,
      1.842530,
      1,
      1.373168,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223481,
      NULL,
      1,
      1.868587,
      1.687166,
      0,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      3.922579,
      0,
      0,
      3,
      NULL,
      2,
      1,
      0.313012,
      1.950052,
      NULL,
      3.126325,
      0.643302,
      0,
      NULL,
      0,
      NULL,
      0.776461,
      1,
      1,
      1,
      0.072187,
      0,
      1.385503,
      1.518069,
      0.907265,
      0,
      0,
      0.064753,
      NULL,
      NULL,
      2.690066,
      1.141354,
      1.491888,
      11.407021,
      7.707842,
      NULL,
      2.505559,
      0.214353,
      NULL,
      3.053355,
      0,
      NULL,
      2,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      '',
      NULL,
      NULL,
      1.739336,
      '23111',
      '',
      '',
      0,
      '',
      '',
      '',
      2.119006,
      37.444887,
      NULL,
      18.384099,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      1.082776,
      NULL,
      NULL,
      0.543507,
      NULL,
      NULL,
      0.028937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988631,
      1.005005,
      0.286490,
      1,
      1.317960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.103929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.934770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841589,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.804734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.812074,
      NULL,
      NULL,
      6.235244,
      NULL,
      NULL,
      3.885091,
      NULL,
      NULL,
      NULL,
      3,
      2.275586,
      1,
      NULL,
      NULL,
      NULL,
      5.579632,
      3.400439,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.820778,
      NULL,
      NULL,
      0.190465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.072570,
      1.483968,
      1,
      NULL,
      4.272557,
      4.236639,
      5,
      NULL,
      4.856636,
      1,
      0.375694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.876258,
      NULL,
      3,
      1.875761,
      3.279024,
      6,
      4,
      0.625537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.309812,
      NULL,
      8,
      4.591046,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444167,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153319,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.793677,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.920022,
      NULL,
      NULL,
      1.776612,
      NULL,
      NULL,
      1.475173,
      NULL,
      0,
      174,
      0.206228,
      1,
      1.310561,
      0,
      0.158842,
      1.894557,
      1.294028,
      0.430371,
      0,
      NULL,
      NULL,
      1.923256,
      1,
      0.855967,
      0,
      1,
      NULL,
      NULL,
      0.890430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.299417,
      NULL,
      0,
      7,
      4,
      0.516930,
      12,
      1.717408,
      0.392251,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274658,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311191,
      NULL,
      NULL,
      NULL,
      1.442057,
      NULL,
      1.666184,
      3.818169,
      5,
      0.976817,
      NULL,
      NULL,
      34.679059,
      41.945424,
      NULL,
      NULL,
      0.597790,
      '',
      NULL,
      '',
      2.577108,
      '24004',
      '',
      NULL,
      0,
      '',
      '',
      NULL);
commit;
end;
/


