set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0104211',
      2.240231,
      1,
      NULL,
      NULL,
      '4241',
      3.435152,
      1.556728,
      NULL,
      NULL,
      NULL,
      36.130641,
      NULL,
      4.253757,
      3,
      3.880714,
      NULL,
      47,
      0,
      177.910795,
      176,
      NULL,
      ' 6- 9-1992',
      ' 3-10-1995',
      ' 5- 4-1976',
      NULL,
      0.215041,
      2,
      1.070401,
      1,
      0,
      3.161945,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6.960154,
      25,
      4,
      NULL,
      3,
      0,
      2.157410,
      6,
      0.688633,
      1.804687,
      3,
      0.470834,
      NULL,
      NULL,
      NULL,
      1.742126,
      1,
      1,
      0,
      0,
      0,
      0,
      3,
      0.452554,
      NULL,
      1,
      1.586368,
      1.162127,
      10,
      1,
      0.070385,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.596891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.616580,
      1.100884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875336,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807938,
      0.708458,
      NULL,
      1,
      5,
      5.703017,
      7,
      1.944320,
      0.728148,
      6,
      NULL,
      NULL,
      0,
      5.567189,
      0.392371,
      0.965826,
      0.644971,
      0.003231,
      0,
      NULL,
      1,
      1.629248,
      3,
      0.175177,
      0.582074,
      0.775857,
      3.105879,
      1,
      0.703123,
      1.870516,
      0,
      0,
      1,
      0.623124,
      NULL,
      1.524808,
      2.950271,
      NULL,
      4,
      7.500195,
      3.544894,
      NULL,
      NULL,
      2,
      0.932420,
      0,
      4.706686,
      0,
      ' 7-16-1976',
      161,
      ' 1-27-1975',
      106.525128,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.577261,
      0.087965,
      0.978076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.027724,
      3.130478,
      NULL,
      0,
      1,
      0.112835,
      0,
      5,
      0.852663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.220815,
      5.725142,
      4.275603,
      NULL,
      5,
      1.553902,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.340090,
      1.785948,
      NULL,
      1.394435,
      0,
      NULL,
      NULL,
      2,
      29.696732,
      2,
      0.212499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.953104,
      3,
      NULL,
      0,
      0.477287,
      1,
      3,
      NULL,
      0.888742,
      3.195902,
      2,
      1.532764,
      1.558535,
      3.282514,
      0,
      1,
      1,
      3,
      1,
      0,
      NULL,
      1,
      0,
      0.135426,
      1.526394,
      1,
      0,
      NULL,
      1.045175,
      5.641551,
      0,
      4.528577,
      11,
      11.989116,
      0.418600,
      0.076014,
      0,
      2.680058,
      3.231887,
      NULL,
      0.322619,
      16,
      3.787727,
      2,
      NULL,
      28,
      NULL,
      52,
      1.770385,
      0,
      NULL,
      '34102',
      '',
      '',
      1.007285,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.744157,
      10.636625,
      27.265292,
      NULL,
      2,
      45,
      NULL,
      2.346904,
      1.540227,
      3,
      NULL,
      NULL,
      0,
      0.500202,
      1.748381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306583,
      NULL,
      NULL,
      0.961867,
      NULL,
      2.578400,
      3.821309,
      0.407181,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.215685,
      0,
      1.384765,
      3,
      0,
      2,
      2.654030,
      NULL,
      NULL,
      2,
      NULL,
      7,
      11,
      5.311079,
      0.120197,
      0.976686,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      2.518269,
      0.470930,
      3.618237,
      0,
      0,
      0,
      3,
      0,
      3.544673,
      3,
      0.239247,
      3,
      1,
      0.549434,
      1,
      2.908066,
      0,
      NULL,
      0.992817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.893789,
      3.889212,
      3.523573,
      3.158089,
      0,
      1.608253,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.829809,
      0,
      1.053049,
      1.276063,
      1,
      NULL,
      NULL,
      NULL,
      3.400791,
      1.570546,
      2.325286,
      1.791222,
      NULL,
      1,
      NULL,
      NULL,
      7,
      2,
      1,
      1.049183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434304,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.521067,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.073509,
      0.875646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.984706,
      2,
      0.344089,
      2,
      2.098020,
      NULL,
      1.860263,
      6.766712,
      5.499542,
      NULL,
      1.334881,
      0,
      0,
      3.838105,
      1,
      1,
      2.277160,
      0.839960,
      0,
      1.321828,
      1.149833,
      5,
      7,
      2.963524,
      2.329328,
      NULL,
      2.305307,
      2,
      2,
      1.244078,
      1,
      0,
      0.508117,
      0.212776,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.540538,
      NULL,
      NULL,
      1.387348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.429310,
      NULL,
      NULL,
      2.352238,
      NULL,
      NULL,
      0,
      0.118756,
      1,
      1,
      1.310848,
      2.193964,
      1.962967,
      NULL,
      NULL,
      0.889314,
      NULL,
      NULL,
      NULL,
      5.594244,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.677701,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.887687,
      NULL,
      NULL,
      NULL,
      1.845853,
      NULL,
      NULL,
      NULL,
      1.627613,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.384584,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.116503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.255052,
      NULL,
      NULL,
      NULL,
      3.317306,
      2,
      NULL,
      1.726439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.514969,
      NULL,
      1.366392,
      335.911027,
      3,
      1.225068,
      0,
      1,
      0,
      0.259321,
      1,
      0,
      NULL,
      1.759251,
      1.271305,
      0.158384,
      0.972658,
      0,
      NULL,
      0.587808,
      0,
      1.757759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592512,
      1.859511,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.976650,
      NULL,
      0.037173,
      NULL,
      NULL,
      NULL,
      0.876190,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.305520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586475,
      1.165718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436547,
      1.636246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417165,
      1,
      NULL,
      2.113336,
      NULL,
      0.066692,
      NULL,
      NULL,
      NULL,
      0.567359,
      NULL,
      1,
      NULL,
      1,
      1.235340,
      NULL,
      31.811008,
      36,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.587673,
      0,
      2,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      1.236666,
      0,
      NULL,
      NULL,
      1.507635,
      NULL,
      NULL,
      0,
      2.590791,
      NULL,
      0.867565,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.056344,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.659052,
      NULL,
      NULL,
      0.107717,
      NULL,
      1.795348,
      1,
      NULL,
      1.950232,
      0.389705,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.259114,
      NULL,
      1,
      NULL,
      2.579313,
      NULL,
      NULL,
      NULL,
      1.541338,
      NULL,
      1.554866,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.973716,
      NULL,
      2.772838,
      NULL,
      2.286072,
      1,
      NULL,
      0,
      3,
      NULL,
      1.821110,
      NULL,
      1.613756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.497143,
      NULL,
      0,
      NULL,
      1.953008,
      NULL,
      NULL,
      NULL,
      2.397550,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.527951,
      NULL,
      4,
      1,
      NULL,
      NULL,
      79,
      10,
      4.612719,
      0,
      4,
      '13430',
      '23023',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


