set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4312212',
      5,
      0,
      1,
      3,
      NULL,
      1.097719,
      0.083853,
      NULL,
      NULL,
      '11-21-1993',
      14,
      NULL,
      3,
      1.088303,
      0,
      ' 6- 1-1987',
      NULL,
      2.490220,
      49.480736,
      156,
      3.742137,
      ' 0- 6-1980',
      NULL,
      ' 5-14-1983',
      1.761789,
      NULL,
      2,
      1,
      1,
      1,
      0,
      1,
      1.893112,
      NULL,
      3,
      1.784719,
      5,
      9,
      13.459744,
      7.617695,
      25,
      5,
      1,
      NULL,
      2.154560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      11,
      1.125650,
      0.727407,
      NULL,
      0,
      2,
      5,
      NULL,
      1.500722,
      7,
      NULL,
      7,
      NULL,
      NULL,
      3,
      0,
      3.903054,
      NULL,
      NULL,
      NULL,
      1.696285,
      NULL,
      NULL,
      11,
      7,
      NULL,
      2.638038,
      1.892644,
      0,
      3,
      0,
      1.631550,
      0.245476,
      2,
      0,
      2.867452,
      0.043100,
      1,
      2,
      0.853219,
      NULL,
      0.599146,
      9,
      11,
      NULL,
      8.090537,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921958,
      NULL,
      NULL,
      1.820202,
      NULL,
      1.870477,
      1,
      NULL,
      1.572014,
      NULL,
      0.062512,
      NULL,
      0.486944,
      0,
      0,
      0.150462,
      NULL,
      1.807687,
      NULL,
      NULL,
      1.877005,
      NULL,
      0,
      0.694887,
      1,
      NULL,
      0.367856,
      NULL,
      1.548725,
      NULL,
      1.234170,
      0,
      NULL,
      5,
      1,
      1,
      6,
      1.370893,
      4,
      0,
      5,
      NULL,
      4,
      3,
      NULL,
      NULL,
      0,
      0.490814,
      ' 2- 9-1982',
      339,
      ' 3-12-2002',
      506,
      1.197751,
      0,
      2.710303,
      0.632518,
      0.550531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290430,
      1,
      0,
      1.497271,
      0.371473,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      2.604216,
      0,
      NULL,
      3.058093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.335674,
      1.238274,
      4,
      0.787572,
      NULL,
      NULL,
      NULL,
      1,
      3.288396,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.591396,
      NULL,
      1.350236,
      NULL,
      0.819765,
      1.114458,
      0,
      1.063274,
      13,
      0.480303,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.944668,
      3,
      0.642500,
      3.839230,
      0,
      1.631873,
      0,
      NULL,
      1.629550,
      2.695684,
      0.666446,
      0,
      NULL,
      1,
      0.821721,
      1.893044,
      1,
      1,
      1,
      NULL,
      1.532384,
      0,
      0.993182,
      1.833368,
      0,
      0.034477,
      1.380573,
      NULL,
      0,
      0,
      0,
      8.937763,
      3,
      5,
      4,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      2.172552,
      1,
      26.657968,
      1.325514,
      3.521782,
      NULL,
      25,
      10,
      NULL,
      4.595430,
      1.622788,
      0,
      '14201',
      '',
      '',
      1.010449,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.336217,
      12,
      16,
      5.776205,
      3,
      NULL,
      2.066851,
      2.729773,
      3.697160,
      NULL,
      2.722421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630026,
      NULL,
      NULL,
      0.155890,
      NULL,
      NULL,
      1,
      0.394292,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.300035,
      0.194120,
      2,
      2,
      1,
      1,
      NULL,
      0.424830,
      1,
      3,
      NULL,
      10.654039,
      7.191526,
      8,
      1.242452,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462945,
      NULL,
      NULL,
      NULL,
      1.060452,
      0.132189,
      0,
      3.743962,
      NULL,
      1,
      2,
      1,
      0,
      0.844439,
      0.762914,
      1.311205,
      3.522438,
      2.589420,
      1,
      1.483448,
      3.356704,
      NULL,
      0.044478,
      2,
      1,
      1.647075,
      0,
      NULL,
      NULL,
      0.832623,
      NULL,
      NULL,
      0.028501,
      NULL,
      NULL,
      1.340299,
      NULL,
      0.843092,
      NULL,
      3,
      5,
      NULL,
      1.719920,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.851639,
      NULL,
      NULL,
      2,
      0.448005,
      NULL,
      NULL,
      3.876243,
      0,
      0.040576,
      NULL,
      NULL,
      2,
      7,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.302143,
      NULL,
      0.852378,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.109967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.532723,
      3.314489,
      3,
      3.848593,
      0,
      2,
      NULL,
      2,
      NULL,
      0.770579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964593,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1.852951,
      6.395605,
      5,
      2.984795,
      NULL,
      2,
      NULL,
      3,
      1.353961,
      1,
      2.628771,
      0.025937,
      NULL,
      3.802204,
      0.459103,
      6.048067,
      0,
      0,
      0.392841,
      3,
      0.593594,
      NULL,
      NULL,
      4.395933,
      NULL,
      1.447112,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.276328,
      NULL,
      NULL,
      1.189046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501384,
      NULL,
      NULL,
      1,
      0.798572,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131542,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.459082,
      NULL,
      NULL,
      NULL,
      1.442428,
      NULL,
      NULL,
      NULL,
      1.203061,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.517590,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.097526,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.921080,
      NULL,
      NULL,
      NULL,
      3.699285,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.366516,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.675759,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.513976,
      NULL,
      NULL,
      1.208008,
      NULL,
      NULL,
      0.943557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.930452,
      NULL,
      2.876511,
      0.063010,
      1.714172,
      0,
      NULL,
      NULL,
      1,
      0.907760,
      1.486066,
      NULL,
      1.641836,
      0.679425,
      0,
      0.234111,
      1,
      1.875889,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556255,
      1.458052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.386890,
      NULL,
      1.896574,
      NULL,
      3.799419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.959260,
      1.863810,
      1.840417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584293,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139121,
      0.872191,
      NULL,
      3.019602,
      NULL,
      0.811514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.968612,
      NULL,
      31,
      37,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5,
      1.702358,
      0,
      NULL,
      0.140607,
      4.288434,
      2.372263,
      NULL,
      1.432623,
      0.702751,
      1,
      NULL,
      1,
      0.019304,
      NULL,
      0.793540,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2.308508,
      NULL,
      1,
      0,
      NULL,
      1.737570,
      0.392387,
      NULL,
      0,
      1,
      NULL,
      1,
      1.391274,
      NULL,
      1.181749,
      NULL,
      NULL,
      0.460567,
      1.556473,
      NULL,
      1.681462,
      NULL,
      1,
      1,
      NULL,
      1.891570,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.759972,
      NULL,
      1,
      NULL,
      0.103996,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.196983,
      NULL,
      1.993074,
      NULL,
      21,
      NULL,
      1662.628500,
      0.647928,
      3.852823,
      NULL,
      0,
      NULL,
      0.484996,
      NULL,
      NULL,
      NULL,
      1.612186,
      NULL,
      0,
      NULL,
      1.606764,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.194657,
      NULL,
      14,
      0.470283,
      949.237161,
      0,
      NULL,
      1,
      NULL,
      0.336942,
      NULL,
      1,
      2,
      4,
      1.174043,
      NULL,
      NULL,
      27,
      39,
      NULL,
      NULL,
      3,
      '02312',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.136689,
      '',
      NULL,
      '');
commit;
end;
/


